/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.impl;

import com.vmware.content.library.Item;
import com.vmware.content.library.ItemModel;
import com.vmware.content.library.SubscribedItem;
import com.vmware.content.library.item.TransferEndpoint;
import com.vmware.content.library.item.UpdateSession;
import com.vmware.content.library.item.updatesession.File;
import com.vmware.content.library.item.updatesession.FileTypes;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.library.util.LibraryUtil;
import com.vmware.vsphere.client.libraryItem.specs.CopyLibraryItemSpec;
import com.vmware.vsphere.client.libraryItem.specs.DeleteLibraryItemSpec;
import com.vmware.vsphere.client.libraryItem.specs.EditLibraryItemSpec;
import com.vmware.vsphere.client.libraryItem.specs.EvictLibraryItemSpec;
import com.vmware.vsphere.client.libraryItem.specs.ImportLibraryItemSpec;
import com.vmware.vsphere.client.libraryItem.specs.LibraryItemNameValidatorSpec;
import com.vmware.vsphere.client.libraryItem.specs.LibraryItemUrlValidatorSpec;
import com.vmware.vsphere.client.libraryItem.specs.SyncLibraryItemSpec;
import com.vmware.vsphere.client.libraryItem.util.LibraryItemUtil;
import com.vmware.vsphere.client.util.uri.UriSchemeUtil;
import com.vmware.vsphere.client.util.vapi.VapiUtil;
import com.vmware.vsphere.client.vapi.tasks.VapiAsyncCallback;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryItemMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(LibraryItemMutationProvider.class);
    private static final String LIBRARY_ITEMS_PROP = "com.vmware.content.LibraryModel/libraryItem";
    private static final String LIBRARY_ITEM_NAME_PROP = "com.vmware.content.library.ItemModel/name";
    private final Item _libraryItemService;
    private final SubscribedItem _subscribedLibraryItemService;
    private final DataService _dataService;
    private final UpdateSession _updateSession;
    private final File _updateSessionFile;
    private VapiTaskMonitor _vapiTaskMonitor;

    public LibraryItemMutationProvider(Item libraryItemService, SubscribedItem subscribedLibraryItemService, DataService dataService, UpdateSession updateSession, File updateSessionFile) {
        Validate.notNull((Object)libraryItemService, (String)"libraryItemService");
        Validate.notNull((Object)subscribedLibraryItemService, (String)"subscribedLibraryItemService");
        Validate.notNull((Object)dataService, (String)"dataService");
        Validate.notNull((Object)updateSession, (String)"updateSession");
        Validate.notNull((Object)updateSessionFile, (String)"updateSessionFile");
        this._libraryItemService = libraryItemService;
        this._subscribedLibraryItemService = subscribedLibraryItemService;
        this._dataService = dataService;
        this._updateSession = updateSession;
        this._updateSessionFile = updateSessionFile;
    }

    public void setVapiTaskMonitor(VapiTaskMonitor vapiTaskMonitor) {
        this._vapiTaskMonitor = vapiTaskMonitor;
    }

    public OperationResult add(CopyLibraryItemSpec copySpec) {
        OperationResult result = new OperationResult();
        if (copySpec.sourceLibraryItemUri == null) {
            String errMsg = LibraryItemUtil.getLocalizedString("error.noLibraryItemURI");
            _logger.error((Object)errMsg);
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        String cloneLibraryItemToken = VapiUtil.newClientToken();
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(cloneLibraryItemToken, this._vapiTaskMonitor);
        ItemModel item = new ItemModel();
        item.setName(copySpec.itemName);
        item.setDescription(copySpec.itemDescription);
        URI libraryUri = copySpec.selectedLibraryUri;
        String libraryId = UriSchemeUtil.getId((URI)libraryUri);
        item.setLibraryId(libraryId);
        String sourceLibraryItemId = UriSchemeUtil.getId((URI)copySpec.sourceLibraryItemUri);
        try {
            this._libraryItemService.copy(cloneLibraryItemToken, sourceLibraryItemId, item, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception ex) {
            _logger.error((Object)("Error copying content library item.\nSpec: \n" + ObjectUtil.prettyPrint((Object)((Object)copySpec))), (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public OperationResult remove(URI libraryItemUri, DeleteLibraryItemSpec removeSpec) {
        OperationResult result = new OperationResult();
        result.entity = libraryItemUri;
        if (LibraryItemUtil.isNullOrEmpty(libraryItemUri).booleanValue()) {
            String errMsg = LibraryItemUtil.getLocalizedString("error.noLibraryItemURI");
            _logger.error((Object)errMsg);
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItemUri);
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating delete library item. Client token: " + asyncCallback.getActivationId()));
        try {
            this._libraryItemService.delete(libraryItemId, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Library item delete operation failed", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult apply(URI libraryItemUri, SyncLibraryItemSpec syncSpec) {
        OperationResult result = new OperationResult();
        result.entity = libraryItemUri;
        if (LibraryItemUtil.isNullOrEmpty(libraryItemUri).booleanValue()) {
            String errMsg = LibraryItemUtil.getLocalizedString("error.noLibraryItemURI");
            _logger.error((Object)errMsg);
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItemUri);
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating sync library item. Client token: " + asyncCallback.getActivationId()));
        try {
            this._subscribedLibraryItemService.sync(libraryItemId, true, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Sync library item operation failed", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult apply(URI libraryItemUri, EvictLibraryItemSpec syncSpec) {
        OperationResult result = new OperationResult();
        result.entity = libraryItemUri;
        if (LibraryItemUtil.isNullOrEmpty(libraryItemUri).booleanValue()) {
            String errMsg = LibraryItemUtil.getLocalizedString("error.noLibraryItemURI");
            _logger.error((Object)errMsg);
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItemUri);
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating evict on library item content. Client token: " + asyncCallback.getActivationId()));
        try {
            this._subscribedLibraryItemService.evict(libraryItemId, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Evict library item operation failed", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult apply(URI libraryItemUri, EditLibraryItemSpec editSpec) {
        OperationResult result = new OperationResult();
        result.entity = libraryItemUri;
        if (LibraryItemUtil.isNullOrEmpty(libraryItemUri).booleanValue()) {
            String errMsg = LibraryItemUtil.getLocalizedString("error.noLibraryItemURI");
            _logger.error((Object)errMsg);
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItemUri);
        ItemModel libraryItem = new ItemModel();
        if (!StringUtil.isNullOrEmpty((String)editSpec.itemName)) {
            libraryItem.setName(editSpec.itemName);
        }
        if (editSpec.itemDescription != null) {
            libraryItem.setDescription(editSpec.itemDescription);
        }
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating update library item. Client token: " + asyncCallback.getActivationId()));
        try {
            this._libraryItemService.update(libraryItemId, libraryItem, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Edit library item operation failed", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult apply(URI libraryItemUri, ImportLibraryItemSpec importSpec) {
        OperationResult result = new OperationResult();
        result.entity = libraryItemUri;
        if (LibraryItemUtil.isNullOrEmpty(libraryItemUri).booleanValue()) {
            String errMsg = LibraryItemUtil.getLocalizedString("error.noLibraryItemURI");
            _logger.error((Object)errMsg);
            result.error = ErrorTransformUtil.convertError((String)errMsg);
            return result;
        }
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItemUri);
        ItemModel libraryItem = new ItemModel();
        if (!StringUtil.isNullOrEmpty((String)importSpec.itemName)) {
            libraryItem.setName(importSpec.itemName);
        }
        if (importSpec.itemDescription != null) {
            libraryItem.setDescription(importSpec.itemDescription);
        }
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating update library item. Client token: " + asyncCallback.getActivationId()));
        try {
            this._libraryItemService.update(libraryItemId, libraryItem, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Edit library item operation failed", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        result = LibraryItemUtil.triggerUploadContents(importSpec, libraryItemId, result, this._libraryItemService, this._updateSession, this._updateSessionFile, this._vapiTaskMonitor);
        return result;
    }

    public ValidationResult validate(LibraryItemNameValidatorSpec spec) {
        return this.validateItemNameInternal(null, spec);
    }

    public ValidationResult validate(URI libraryItemUri, LibraryItemNameValidatorSpec spec) {
        return this.validateItemNameInternal(libraryItemUri, spec);
    }

    public ValidationResult validate(URI libraryItemUri, LibraryItemUrlValidatorSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = libraryItemUri;
        validationResult.result = true;
        try {
            URI uri = new URI(spec.url);
            TransferEndpoint ep = new TransferEndpoint();
            ep.setUri(uri);
            FileTypes.ProbeResult result = this._updateSessionFile.probe(ep);
            validationResult.result = result;
        }
        catch (Exception e) {
            _logger.error((Object)("probe url failed for url: " + spec.url), (Throwable)e);
        }
        return validationResult;
    }

    private ValidationResult validateItemNameInternal(URI libraryItemUri, LibraryItemNameValidatorSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = libraryItemUri;
        validationResult.result = true;
        try {
            for (int i = 0; i < spec.libraryItemNames.length; ++i) {
                if (this.isItemNameUnique(libraryItemUri, spec.libraryItemNames[i], spec.libraryUri).booleanValue()) continue;
                validationResult.result = false;
                break;
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error when validating library item name uniqueness", (Throwable)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    private Boolean isItemNameUnique(URI libraryItemUri, String itemName, URI libraryUri) throws Exception {
        Boolean isNameUnique = true;
        String libraryItemName = StringUtils.trim((String)itemName);
        if (StringUtil.isNullOrEmpty((String)libraryItemName)) {
            throw new IllegalArgumentException(LibraryUtil.getLocalizedString("error.noLibraryItemName"));
        }
        PropertyConstraint libraryItemNameConstraint = QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)LIBRARY_ITEM_NAME_PROP, (Comparator)Comparator.EQUALS, (Object)libraryItemName);
        RelationalConstraint libraryItemLibraryConstraint = QueryUtil.createRelationalConstraint((String)LIBRARY_ITEMS_PROP, (Constraint)QueryUtil.createObjectIdentityConstraint((Object)libraryUri), (Boolean)true, (String)"com.vmware.content.library.Item");
        CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{libraryItemNameConstraint, libraryItemLibraryConstraint}, (Conjoiner)Conjoiner.AND);
        QuerySpec qs = QueryUtil.buildQuerySpec((Constraint)compositeConstraint, (String[])new String[]{LIBRARY_ITEM_NAME_PROP});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)qs);
        if (libraryItemUri == null) {
            isNameUnique = resultSet.items.length == 0;
        } else if (resultSet.items.length > 0) {
            for (ResultItem item : resultSet.items) {
                URI libraryItem = (URI)item.resourceObject;
                if (libraryItem.equals(libraryItemUri)) continue;
                isNameUnique = false;
                break;
            }
        }
        return isNameUnique;
    }
}

