/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.impl;

import com.vmware.content.Library;
import com.vmware.content.library.ItemModel;
import com.vmware.content.library.ItemPath;
import com.vmware.content.library.item.File;
import com.vmware.content.library.item.FileTypes;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vapi.std.errors.Unauthorized;
import com.vmware.vcenter.iso.IsoPath;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.uri.VapiUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.libraryItem.impl.LibraryItemModelWithIsoPath;
import com.vmware.vsphere.client.util.uri.UriSchemeUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryItemPropertyProvider
implements PropertyProviderBean {
    private final File _fileService;
    private final IsoPath _contentLibIsoPathService;
    private final ItemPath _libraryItemPathService;
    private final Library _libraryService;
    private final DataService _dataService;
    private final QueryExecutor _queryExecutor;
    private static final Log _logger = LogFactory.getLog(LibraryItemPropertyProvider.class);
    private static final String CL_PREFIX = "[contentLib]";
    private static final String IS_VAPP_TEMPLATE_PROPERTY = "com.vmware.content.type.ovf.OvfTemplate/isVappTemplate";
    private static final String IS_OVF_TEMPLATE_PROPERTY = "com.vmware.content.library.ItemModel/isOVFTemplate";
    private static final String IS_ISO_TEMPLATE_PROPERTY = "com.vmware.content.library.ItemModel/isIsoImageType";
    private static final String LIBRARY_SERVER_GUID_PROPERTY = "com.vmware.content.LibraryModel/serverGuid";
    private static final String LIBRARYITEM_SERVER_GUID_PROP = "serverGuid";
    private static final String LIBRARY_TYPE_PROPERTY = "com.vmware.content.LibraryModel/type";
    private static final String LIBRARY_TYPE_LOCAL_VALUE = "LOCAL";
    private static final String LIBRARY_RELATION_PROPERTY = "com.vmware.content.LibraryModel/libraryItem";
    private static final String LIBRARY_DATASTORED_IDS = "com.vmware.content.LibraryModel/datastoreIds";
    private static final String IS_STREAM_OPTIMIZED = "isStreamOptimized";
    private static final String PROP_RP_OWNER = "owner";

    public LibraryItemPropertyProvider(File fileService, IsoPath contentLibraryIsoPathService, ItemPath libraryItemPathService, Library libraryService, DataService dataService, QueryExecutor queryExecutor) {
        Validate.notNull((Object)fileService, (String)"fileService null");
        this._fileService = fileService;
        this._contentLibIsoPathService = contentLibraryIsoPathService;
        this._libraryItemPathService = libraryItemPathService;
        this._libraryService = libraryService;
        this._dataService = dataService;
        this._queryExecutor = queryExecutor;
    }

    @type(value="com.vmware.content.library.Item")
    public String[] getFiles(URI libraryItem) {
        Validate.notNull((Object)libraryItem, (String)"target object is null");
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItem);
        ArrayList<String> result = new ArrayList<String>();
        List files = this._fileService.list(libraryItemId);
        for (FileTypes.Info file : files) {
            result.add(file.getName());
        }
        return (String[])ArrayUtil.toArray(result, String.class);
    }

    @type(value="com.vmware.content.library.Item")
    public Boolean getIsParentVCCompatibleForExport(URI libraryItemUri) throws Exception {
        Validate.notNull((Object)libraryItemUri, (String)"libraryItemUri is null during PROP isParentVCCompatibleForExport");
        String serverGuid = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)libraryItemUri, (String)LIBRARYITEM_SERVER_GUID_PROP);
        return VcServiceUtil.is65VcOrLaterByServerGuid((String)serverGuid);
    }

    @type(value="com.vmware.content.library.Item")
    public String getContentLibraryIsoPath(URI libraryItem) {
        Validate.notNull((Object)libraryItem, (String)"target object is null");
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItem);
        String path = null;
        if (libraryItemId != null && StringUtils.isNotEmpty((String)libraryItemId)) {
            path = this._contentLibIsoPathService.getDatastorePath(libraryItemId);
        }
        return path;
    }

    @type(value="com.vmware.content.library.Item")
    public String getContentLibraryFriendlyIsoPath(URI libraryItem, String datastorePath) {
        String friendlyPath = null;
        try {
            if (StringUtils.isNotEmpty((String)datastorePath)) {
                ItemModel itemModel = this._libraryItemPathService.getByDatastorePath(datastorePath);
                String libraryName = this._libraryService.get(itemModel.getLibraryId()).getName();
                if (itemModel != null) {
                    friendlyPath = this.buildFriendlyIsoName(itemModel.getName(), libraryName);
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error fetching friendly Content Library ISO path for " + datastorePath), (Throwable)e);
            return datastorePath;
        }
        return friendlyPath;
    }

    @type(value="com.vmware.content.library.Item")
    public LibraryItemModelWithIsoPath getContentLibraryItemByItemId(URI libraryItem) {
        LibraryItemModelWithIsoPath itemModelWithIsoPath = new LibraryItemModelWithIsoPath();
        try {
            String libraryItemId = UriSchemeUtil.getId((URI)libraryItem);
            if (libraryItemId != null && StringUtils.isNotEmpty((String)libraryItemId)) {
                String datastorePath = this._contentLibIsoPathService.getDatastorePath(libraryItemId);
                ItemModel itemModel = this._libraryItemPathService.getByDatastorePath(datastorePath);
                itemModelWithIsoPath = this.buildLibraryItemWithIsoPath(itemModel);
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error fetching ContentLibraryItemWithIsoPath for library item " + libraryItem), (Throwable)e);
            itemModelWithIsoPath.errorMessages = this.getErrorMessagesFromCLException(e);
        }
        return itemModelWithIsoPath;
    }

    @type(value="com.vmware.content.library.Item")
    public LibraryItemModelWithIsoPath getContentLibraryItemByDatastorePath(URI libraryItem, String datastorePath) {
        LibraryItemModelWithIsoPath itemModelWithIsoPath = new LibraryItemModelWithIsoPath();
        try {
            if (StringUtils.isNotEmpty((String)datastorePath)) {
                ItemModel itemModel = this._libraryItemPathService.getByDatastorePath(datastorePath);
                itemModelWithIsoPath = this.buildLibraryItemWithIsoPath(itemModel);
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error fetching ContentLibraryItemWithIsoPath for datastore path " + datastorePath), (Throwable)e);
            itemModelWithIsoPath.errorMessages = this.getErrorMessagesFromCLException(e);
        }
        return itemModelWithIsoPath;
    }

    @type(value="Folder")
    public Response getLibraryTemplates(ManagedObjectReference rootFolder) throws Exception {
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = "LibraryTemplates_Query";
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = this.buildTemplateConstraint(false, rootFolder.getServerGuid());
        querySpec.resourceSpec.constraint.targetType = "com.vmware.content.library.Item";
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{"com.vmware.content.library.ItemModel/isSubscribed", "com.vmware.content.library.ItemModel/itemType.@formatted", "com.vmware.content.library.ItemModel/libraryName", "isPublished", "com.vmware.content.library.ItemModel/size.@formatted", "primaryIconId", "com.vmware.content.library.ItemModel/name", "com.vmware.content.library.ItemModel/lastModifiedTime", "com.vmware.content.library.ItemModel/isCached.@formatted", "com.vmware.content.type.ovf.OvfTemplate/vmTemplate/osDescription", "com.vmware.content.type.ovf.OvfTemplate/vmTemplate/osType"};
        propertySpec.type = "com.vmware.content.library.Item";
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response data2 = this._dataService.getData(requestSpec);
        return data2;
    }

    @type(value="Folder")
    public List<Object> getLibraryTemplatesForUpdate(ManagedObjectReference rootFolder) throws Exception {
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = "LibraryTemplatesForUpdate_Query";
        querySpec.resourceSpec = new ResourceSpec();
        Constraint libraryCompositeConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{QueryUtil.createPropertyConstraint((String)"com.vmware.content.Library", (String)LIBRARY_SERVER_GUID_PROPERTY, (Comparator)Comparator.EQUALS, (Object)rootFolder.getServerGuid()), QueryUtil.createPropertyConstraint((String)"com.vmware.content.Library", (String)LIBRARY_TYPE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)LIBRARY_TYPE_LOCAL_VALUE)}, (Conjoiner)Conjoiner.AND);
        libraryCompositeConstraint.targetType = "com.vmware.content.library.Item";
        RelationalConstraint libraryRelationalConstraint = QueryUtil.createRelationalConstraint((String)LIBRARY_RELATION_PROPERTY, (Constraint)libraryCompositeConstraint, (Boolean)true, (String)"com.vmware.content.library.Item");
        Constraint libraryItemTemplateTypeCompositeConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)IS_VAPP_TEMPLATE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)false), QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)IS_OVF_TEMPLATE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)true)}, (Conjoiner)Conjoiner.AND);
        libraryItemTemplateTypeCompositeConstraint.targetType = "com.vmware.content.library.Item";
        querySpec.resourceSpec.constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{libraryRelationalConstraint, libraryItemTemplateTypeCompositeConstraint}, (Conjoiner)Conjoiner.AND);
        querySpec.resourceSpec.constraint.targetType = "com.vmware.content.library.Item";
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{"com.vmware.content.library.ItemModel/name", "com.vmware.content.library.ItemModel/description", "com.vmware.content.library.ItemModel/itemType.@formatted", "com.vmware.content.library.ItemModel/lastModifiedTime", "isPublished", "com.vmware.content.library.ItemModel/isSubscribed", "com.vmware.content.library.ItemModel/isCached.@formatted", "com.vmware.content.library.ItemModel/libraryName", "com.vmware.content.library.ItemModel/libraryId", "com.vmware.content.library.ItemModel/size.@formatted", "primaryIconId"};
        propertySpec.type = "com.vmware.content.library.Item";
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response data2 = this._dataService.getData(requestSpec);
        if (data2 != null && data2.resultSet != null && data2.resultSet.length > 0 && data2.resultSet[0].items != null && data2.resultSet[0].items.length > 0) {
            ResultItem[] items = data2.resultSet[0].items;
            ArrayList<Object> libraryItems = new ArrayList<Object>();
            for (ResultItem item : items) {
                Map<String, Object> propertyMap = this.getPropertiesMapFromArray(item.properties);
                propertyMap.put("id", item.resourceObject.toString());
                libraryItems.add(this.getPropertiesMapWithShortNames(propertyMap));
            }
            return libraryItems;
        }
        return null;
    }

    @type(value="ClusterComputeResource,HostSystem,ResourcePool,VirtualApp")
    public Response getLibraryIsos(ManagedObjectReference computeResource) throws Exception {
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)computeResource, ResourcePool.class)) {
            computeResource = (ManagedObjectReference)this._queryExecutor.getProperty((Object)computeResource, PROP_RP_OWNER);
        }
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = "LibraryIso_Query";
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = this.buildIsoConstraint(computeResource);
        if (querySpec.resourceSpec.constraint == null) {
            return null;
        }
        querySpec.resourceSpec.constraint.targetType = "com.vmware.content.Library";
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{"com.vmware.content.library.ItemModel/itemType.@formatted", "com.vmware.content.library.ItemModel/id", "com.vmware.content.library.ItemModel/name", "com.vmware.content.library.ItemModel/libraryName", "com.vmware.content.library.ItemModel/description", "com.vmware.content.library.ItemModel/size.@formatted", "com.vmware.content.library.ItemModel/lastModifiedTime.@formatted", "primaryIconId"};
        propertySpec.type = "com.vmware.content.library.Item";
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response data2 = this._dataService.getData(requestSpec);
        return data2;
    }

    private Constraint buildTemplateConstraint(boolean isVappTemplate, String serverGuid) {
        Constraint ovfTemplateConstraint = this.buildOVFTemplateConstraint(isVappTemplate, serverGuid);
        Constraint streamConstraint = this.buildStreamOptimizedConstraint();
        Constraint finalConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{ovfTemplateConstraint, streamConstraint}, (Conjoiner)Conjoiner.AND);
        finalConstraint.targetType = "com.vmware.content.library.Item";
        return finalConstraint;
    }

    private Constraint buildIsoConstraint(ManagedObjectReference computeResource) {
        Constraint isoImageConstraint = this.buildIsoImageConstraint(computeResource);
        if (isoImageConstraint == null) {
            return null;
        }
        Constraint streamConstraint = this.buildStreamOptimizedConstraint();
        Constraint finalConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{isoImageConstraint, streamConstraint}, (Conjoiner)Conjoiner.AND);
        finalConstraint.targetType = "com.vmware.content.library.Item";
        return finalConstraint;
    }

    private Constraint buildOVFTemplateConstraint(boolean isVappTemplate, String serverGuid) {
        PropertyConstraint vAppTemplateConstraint = QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)IS_VAPP_TEMPLATE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)isVappTemplate);
        PropertyConstraint templateTypeConstraint = QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)IS_OVF_TEMPLATE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)true);
        PropertyConstraint librariesOnServer = QueryUtil.createPropertyConstraint((String)"com.vmware.content.Library", (String)LIBRARY_SERVER_GUID_PROPERTY, (Comparator)Comparator.EQUALS, (Object)serverGuid);
        RelationalConstraint libraryItemRelation = QueryUtil.createRelationalConstraint((String)LIBRARY_RELATION_PROPERTY, (Constraint)librariesOnServer, (Boolean)true, (String)"com.vmware.content.library.Item");
        Constraint templateConstraints = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{vAppTemplateConstraint, templateTypeConstraint}, (Conjoiner)Conjoiner.AND);
        templateConstraints.targetType = "com.vmware.content.library.Item";
        Constraint combinedConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{libraryItemRelation, templateConstraints}, (Conjoiner)Conjoiner.AND);
        combinedConstraint.targetType = "com.vmware.content.library.Item";
        return combinedConstraint;
    }

    private Constraint buildIsoImageConstraint(ManagedObjectReference computeResource) {
        ArrayList<PropertyConstraint> datastoreConstraints = new ArrayList<PropertyConstraint>();
        ManagedObjectReference[] datastores = this.getAccessibleDatastores(computeResource);
        if (datastores == null) {
            return null;
        }
        for (int datastoreIndx = 0; datastoreIndx < datastores.length; ++datastoreIndx) {
            ManagedObjectReference datastore = datastores[datastoreIndx];
            PropertyConstraint dsConstraint = QueryUtil.createPropertyConstraint((String)"com.vmware.content.Library", (String)LIBRARY_DATASTORED_IDS, (Comparator)Comparator.CONTAINS, (Object)this.getDataStoreUri(datastore));
            datastoreConstraints.add(dsConstraint);
        }
        Constraint combinedDatastoreConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])datastoreConstraints.toArray(new Constraint[datastoreConstraints.size()]), (Conjoiner)Conjoiner.OR);
        RelationalConstraint libraryItemRelation = QueryUtil.createRelationalConstraint((String)LIBRARY_RELATION_PROPERTY, (Constraint)combinedDatastoreConstraint, (Boolean)true, (String)"com.vmware.content.library.Item");
        PropertyConstraint isoTypeConstraint = QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)IS_ISO_TEMPLATE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)true);
        CompositeConstraint finalConstraints = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{libraryItemRelation, isoTypeConstraint}, (Conjoiner)Conjoiner.AND);
        return finalConstraints;
    }

    private Constraint buildStreamOptimizedConstraint() {
        PropertyConstraint propConstraint1 = QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)IS_STREAM_OPTIMIZED, (Comparator)Comparator.EQUALS, (Object)false);
        PropertyConstraint propConstraint2 = QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)IS_STREAM_OPTIMIZED, (Comparator)Comparator.EQUALS, (Object)"NULL");
        Constraint streamOptimizedConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{propConstraint1, propConstraint2}, (Conjoiner)Conjoiner.OR);
        streamOptimizedConstraint.targetType = "com.vmware.content.library.Item";
        return streamOptimizedConstraint;
    }

    private LibraryItemModelWithIsoPath buildLibraryItemWithIsoPath(ItemModel itemModel) {
        LibraryItemModelWithIsoPath itemModelWithIsoPath = new LibraryItemModelWithIsoPath();
        String libraryName = this._libraryService.get(itemModel.getLibraryId()).getName();
        itemModelWithIsoPath.id = VapiUriSchemeUtil.createUri((String)"com.vmware.content.library.Item", (String)itemModel.getId().toString());
        itemModelWithIsoPath.name = itemModel.getName();
        itemModelWithIsoPath.isoPath = this._contentLibIsoPathService.getDatastorePath(itemModel.getId());
        itemModelWithIsoPath.friendlyName = this.buildFriendlyIsoName(itemModel.getName(), libraryName);
        return itemModelWithIsoPath;
    }

    private ManagedObjectReference[] getAccessibleDatastores(ManagedObjectReference computeResource) {
        ManagedObjectReference[] datastores = null;
        try {
            datastores = (ManagedObjectReference[])this._queryExecutor.getProperty((Object)computeResource, "datastore");
        }
        catch (Exception e) {
            _logger.error((Object)("Error getting accessible datastores for: " + computeResource.toString()), (Throwable)e);
        }
        return datastores;
    }

    private String buildFriendlyIsoName(String isoName, String libraryName) {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(CL_PREFIX).append(" /");
        pathBuilder.append(libraryName).append("/");
        pathBuilder.append(isoName);
        return pathBuilder.toString();
    }

    private String getDataStoreUri(ManagedObjectReference datastore) {
        return datastore.getValue() + ":" + datastore.getServerGuid();
    }

    private List<String> getErrorMessagesFromCLException(Exception e) {
        List messages;
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (e instanceof InvalidArgument) {
            messages = ((InvalidArgument)e).getMessages();
            for (LocalizableMessage message : messages) {
                errorMessages.add(message.getDefaultMessage());
            }
        }
        if (e instanceof Unauthorized) {
            messages = ((Unauthorized)e).getMessages();
            for (LocalizableMessage message : messages) {
                errorMessages.add(message.getDefaultMessage());
            }
        }
        return errorMessages;
    }

    private Map<String, Object> getPropertiesMapFromArray(PropertyValue[] properties) {
        HashMap<String, Object> resultsMap = new HashMap<String, Object>();
        for (PropertyValue property : properties) {
            resultsMap.put(property.propertyName, property.value);
        }
        return resultsMap;
    }

    private Map<String, Object> getPropertiesMapWithShortNames(Map<String, Object> propertyMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!propertyMap.isEmpty()) {
            resultMap.put("id", propertyMap.get("id"));
            resultMap.put("name", propertyMap.get("com.vmware.content.library.ItemModel/name"));
            resultMap.put("itemType", propertyMap.get("com.vmware.content.library.ItemModel/itemType.@formatted"));
            resultMap.put("lastModifiedTime", propertyMap.get("com.vmware.content.library.ItemModel/lastModifiedTime"));
            resultMap.put("isPublished", propertyMap.get("isPublished"));
            resultMap.put("isSubscribed", propertyMap.get("com.vmware.content.library.ItemModel/isSubscribed"));
            resultMap.put("isCached", propertyMap.get("com.vmware.content.library.ItemModel/isCached.@formatted"));
            resultMap.put("libraryName", propertyMap.get("com.vmware.content.library.ItemModel/libraryName"));
            resultMap.put("libraryId", propertyMap.get("com.vmware.content.library.ItemModel/libraryId"));
            resultMap.put("size", propertyMap.get("com.vmware.content.library.ItemModel/size.@formatted"));
            resultMap.put("description", propertyMap.get("com.vmware.content.library.ItemModel/description"));
        }
        return resultMap;
    }
}

