/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.actionsfw.impl;

import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.ActionSpec;
import com.vmware.vise.actionsfw.EvaluationStatus;
import com.vmware.vise.actionsfw.impl.ActionEvaluationImpl;
import com.vmware.vise.actionsfw.impl.ActionsServiceUtil;
import com.vmware.vise.actionsfw.impl.EvaluationStatusImpl;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.PropertyValueMap;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ActionImpl
implements Action {
    private static final Log _logger = LogFactory.getLog(ActionImpl.class);
    private static final String DEFAULT_BUNDLE = "actionsService";
    private static final String PRIVILAGES_PROPERTY = "grantedPrivileges";
    public static final String DISABLED_OPERATIONS = "disabledOperations";
    static final List<String> MANAGED_BY_ENTITIES = Arrays.asList("VirtualMachine", "VirtualApp");
    static final String MANAGED_BY_KEY_PROP = "config/managedBy/extensionKey";
    private final ActionSpec _spec;
    private final ObjectReferenceService _objRefService;
    private List<String> _applicableTargetTypes;

    ActionImpl(ActionSpec actionSpec, List<String> list, ObjectReferenceService objectReferenceService) {
        String string = null;
        if (actionSpec == null) {
            string = "ActionSpec must not be null";
        } else if (StringUtil.isNullOrWhitespace((String)actionSpec.getUid())) {
            string = "ActionSpec.getUid() must not be null or empty";
        }
        if (string != null) {
            throw new NullPointerException(string);
        }
        this._spec = actionSpec;
        this._objRefService = objectReferenceService;
        this._applicableTargetTypes = list;
        if (this.getLabel() == null && this.getIcon() == null) {
            _logger.warn((Object)("Action " + this.getUid() + " has no visual representation."));
        }
        if (this.getInvoker() == null) {
            _logger.warn((Object)("Action " + this.getUid() + " is a no-op as it does not specify an invoker."));
        }
    }

    public String getUid() {
        return this._spec.getUid();
    }

    public void setUid(String string) {
    }

    @Override
    public String getLabel() {
        return StringUtil.returnNullIfEmpty((String)this._spec.label);
    }

    @Override
    public String getDescription() {
        return StringUtil.returnNullIfEmpty((String)this._spec.description);
    }

    @Override
    public String getIcon() {
        return StringUtil.returnNullIfEmpty((String)this._spec.icon);
    }

    @Override
    public String getConfirmationTitle() {
        return this._spec.confirmationTitle;
    }

    @Override
    public String getConfirmationText() {
        return this._spec.confirmationText;
    }

    @Override
    public String getConfirmationTextNone() {
        return this._spec.confirmationTextNone;
    }

    @Override
    public String getConfirmationTextSome() {
        return this._spec.confirmationTextSome;
    }

    @Override
    public String getConfirmationTextAll() {
        return this._spec.confirmationTextAll;
    }

    @Override
    public List<String> getApplicableTargetTypes() {
        return this._applicableTargetTypes;
    }

    boolean evaluateApplicability(ActionContext actionContext) {
        if (actionContext == null) {
            throw new NullPointerException("context must not be null");
        }
        List<Object> list = actionContext.getTargetObjects();
        if (ArrayUtil.isNullOrEmpty(list)) {
            return this.getApplicableTargetTypes().size() == 0;
        }
        if (list.size() > 1 && !this.acceptsMultipleTargets()) {
            return false;
        }
        String string = null;
        for (Object object : list) {
            String string2 = ActionsServiceUtil.getTargetType(object, this._objRefService);
            if (!(string == null || string.equals(string2) || this.acceptsHeterogeneousTargets() && this.applicableToType(string2))) {
                return false;
            }
            string = string2;
        }
        return this.applicableToType(string);
    }

    ActionEvaluation evaluateAvailability(ActionContext actionContext, PropertyValueMap propertyValueMap) {
        ActionEvaluationImpl actionEvaluationImpl = new ActionEvaluationImpl(this, actionContext);
        actionEvaluationImpl.available = false;
        if (!ArrayUtil.isNullOrEmpty(actionContext.getTargetObjects())) {
            actionEvaluationImpl.evaluationStatusMap = new HashMap<String, EvaluationStatus>();
            for (Object object : actionContext.getTargetObjects()) {
                EvaluationStatus evaluationStatus = this.evaluateAvailability(object, propertyValueMap);
                actionEvaluationImpl.evaluationStatusMap.put(this._objRefService.getUid(object), evaluationStatus);
                if (!evaluationStatus.isAvailable()) continue;
                actionEvaluationImpl.available = true;
                actionEvaluationImpl.additionalProperties = this.getAdditionalProperties(object, propertyValueMap);
            }
        } else {
            actionEvaluationImpl.available = true;
        }
        actionEvaluationImpl.timestamp = new Date();
        actionEvaluationImpl.invoker = this._spec.invoker;
        if (actionEvaluationImpl.isAvailable()) {
            actionEvaluationImpl.additionalData = this._spec.additionalData;
            actionEvaluationImpl.pluginData = this._spec.pluginData;
        }
        return actionEvaluationImpl;
    }

    List<String> getPropsNeededForEvaluation() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.getAvailabilityProperty() != null) {
            hashSet.add(this.getAvailabilityProperty());
        }
        if (this.getRequiredPrivileges() != null) {
            hashSet.add(PRIVILAGES_PROPERTY);
        }
        return new ArrayList<String>(hashSet);
    }

    String[] getOperationIds() {
        if (StringUtil.isNullOrWhitespace((String)this._spec.operationIds)) {
            return null;
        }
        return StringUtil.splitAndTrim((String)this._spec.operationIds, (String)",");
    }

    boolean acceptsMultipleTargets() {
        return this._spec.acceptsMultipleTargets;
    }

    boolean acceptsHeterogeneousTargets() {
        return this._spec.acceptsHeterogeneousTargets;
    }

    boolean isPrivateAction() {
        return this._spec.privateAction;
    }

    private EvaluationStatus evaluateAvailability(Object object, PropertyValueMap propertyValueMap) {
        EvaluationStatusImpl evaluationStatusImpl = new EvaluationStatusImpl();
        evaluationStatusImpl.available = true;
        if (!this.checkPrivileges(object, propertyValueMap)) {
            evaluationStatusImpl.available = false;
            evaluationStatusImpl.messages.add(ResourceUtil.getString((String)DEFAULT_BUNDLE, (String)"actionsService.notAvailable.privilege"));
        }
        if (!this.checkDisabledOperations(object, propertyValueMap)) {
            evaluationStatusImpl.available = false;
            evaluationStatusImpl.messages.add(ResourceUtil.getString((String)DEFAULT_BUNDLE, (String)"actionsService.notAvailable.state"));
        }
        if (!this.checkAvailableProperty(object, propertyValueMap)) {
            evaluationStatusImpl.available = false;
            if (this.getNotAvailableText() != null) {
                evaluationStatusImpl.messages.add(this.getNotAvailableText());
            }
        }
        return evaluationStatusImpl;
    }

    private boolean checkPrivileges(Object object, PropertyValueMap propertyValueMap) {
        if (this.getRequiredPrivileges() == null) {
            return true;
        }
        try {
            String[] stringArray = ActionsServiceUtil.extractStringArrayProperty(object, PRIVILAGES_PROPERTY, this._objRefService, propertyValueMap);
            return ActionsServiceUtil.isPrivilegeGranted(this.getRequiredPrivileges(), stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error evaluating action " + this.getUid()), (Throwable)exception);
            return true;
        }
    }

    private boolean checkDisabledOperations(Object object, PropertyValueMap propertyValueMap) {
        if (this.getOperationIds() == null) {
            return true;
        }
        try {
            String[] stringArray = ActionsServiceUtil.extractStringArrayProperty(object, DISABLED_OPERATIONS, this._objRefService, propertyValueMap);
            return ActionsServiceUtil.isOperationAllowed(this.getOperationIds(), stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error evaluating action " + this.getUid()), (Throwable)exception);
            return true;
        }
    }

    private boolean checkAvailableProperty(Object object, PropertyValueMap propertyValueMap) {
        if (this.getAvailabilityProperty() == null) {
            return true;
        }
        try {
            boolean bl = ActionsServiceUtil.extractBooleanProperty(object, this.getAvailabilityProperty(), this._objRefService, propertyValueMap);
            return bl == !this.isAvailabilityPropertyNegated();
        }
        catch (Exception exception) {
            _logger.error((Object)("Error evaluating action " + this.getUid()), (Throwable)exception);
            return true;
        }
    }

    private String getAvailabilityProperty() {
        String string = StringUtil.returnNullIfEmpty((String)this._spec.availabilityProperty);
        if (string == null) {
            return null;
        }
        if (string.startsWith("!")) {
            string = string.substring(1);
            string = string.trim();
        }
        return string;
    }

    private boolean isAvailabilityPropertyNegated() {
        String string = StringUtil.returnNullIfEmpty((String)this._spec.availabilityProperty);
        return string != null && string.startsWith("!");
    }

    private String getNotAvailableText() {
        return StringUtil.returnNullIfEmpty((String)this._spec.notAvailableText);
    }

    private String[] getRequiredPrivileges() {
        if (StringUtil.isNullOrWhitespace((String)this._spec.requiredPrivileges)) {
            return null;
        }
        return StringUtil.splitAndTrim((String)this._spec.requiredPrivileges, (String)",");
    }

    private boolean applicableToType(String string) {
        boolean bl = this.getApplicableTargetTypes().size() == 0;
        boolean bl2 = bl && !this.isPrivateAction() || this.getApplicableTargetTypes().contains(string);
        return bl2;
    }

    private Map<String, Object> getAdditionalProperties(Object object, PropertyValueMap propertyValueMap) {
        String string;
        PropertyValue propertyValue;
        String string2 = this._objRefService.getResourceObjectType(object);
        if (MANAGED_BY_ENTITIES.contains(string2) && (propertyValue = propertyValueMap.getProperty(string = this._objRefService.getUid(object), MANAGED_BY_KEY_PROP)) != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(MANAGED_BY_KEY_PROP, propertyValue.value);
            return hashMap;
        }
        return null;
    }

    private String getInvoker() {
        return StringUtil.returnNullIfEmpty((String)this._spec.invoker);
    }
}

