/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.actionsfw.impl;

import com.vmware.vise.actionsfw.ActionMenuItem;
import com.vmware.vise.actionsfw.ActionMenuItemSpec;
import com.vmware.vise.actionsfw.ActionMenuItemType;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionMenuItemImpl
implements ActionMenuItem {
    private static final Log _logger = LogFactory.getLog(ActionMenuItemImpl.class);
    private ActionMenuItemSpec _spec;
    String extendedPoint;
    String label;
    String icon;
    String feature;
    List<ActionMenuItem> children;

    public ActionMenuItemImpl(ActionMenuItemSpec actionMenuItemSpec) {
        if (actionMenuItemSpec == null) {
            throw new NullPointerException("ActionMenuItem spec must not be null.");
        }
        this._spec = actionMenuItemSpec;
        this.label = this._spec.label;
        this.icon = this._spec.icon;
        this.feature = this._spec.feature;
    }

    public ActionMenuItemImpl(ActionMenuItemSpec actionMenuItemSpec, String string) {
        this(actionMenuItemSpec);
        this.extendedPoint = string;
    }

    @Override
    public ActionMenuItemType getType() {
        if (this._spec.type.equals("HOSTEDPOINT")) {
            return ActionMenuItemType.MENU;
        }
        try {
            return Enum.valueOf(ActionMenuItemType.class, this._spec.type);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _logger.error((Object)("Unknown action menu item type for item " + this.getId() + ". Setting type to ACTION."), (Throwable)illegalArgumentException);
            return ActionMenuItemType.ACTION;
        }
    }

    @Override
    public String getId() {
        return this._spec.getUid();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public String getFeature() {
        return this.feature;
    }

    @Override
    public List<ActionMenuItem> getChildren() {
        return this.children;
    }

    @Override
    public String getExtendedPoint() {
        return this.extendedPoint;
    }
}

