/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.actionsfw.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.impl.ActionImpl;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.PropertyValueMap;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionsEvaluator {
    private static final Log _logger = LogFactory.getLog(ActionsEvaluator.class);
    private QueryService _queryService;
    private ObjectReferenceService _objectRefService;

    public ActionsEvaluator(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectReferenceService) {
        this._queryService = queryServiceFactory.getQueryService();
        this._objectRefService = objectReferenceService;
    }

    public List<ActionEvaluation> evaluate(List<Action> list, ActionContext actionContext, boolean bl) throws Exception {
        ActionImpl actionImpl;
        Action action;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = false;
        ListIterator<Action> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            action = listIterator.next();
            try {
                actionImpl = (ActionImpl)action;
            }
            catch (ClassCastException classCastException) {
                _logger.error((Object)("ActionsEvaluator asked to evaluate an Action with an unknown implementation: " + action.getUid() + " " + action.getClass()));
                throw classCastException;
            }
            if (bl && !actionImpl.evaluateApplicability(actionContext)) {
                listIterator.remove();
                continue;
            }
            hashSet.addAll(actionImpl.getPropsNeededForEvaluation());
            if (actionImpl.getOperationIds() == null) continue;
            bl2 = true;
        }
        action = this.getDataForEvaluation(actionContext, new ArrayList<String>(hashSet), bl2);
        ArrayList<ActionEvaluation> arrayList = new ArrayList<ActionEvaluation>(list.size());
        listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            actionImpl = (ActionImpl)listIterator.next();
            ActionEvaluation actionEvaluation = actionImpl.evaluateAvailability(actionContext, (PropertyValueMap)action);
            arrayList.add(actionEvaluation);
        }
        return arrayList;
    }

    private PropertyValueMap getDataForEvaluation(ActionContext actionContext, List<String> list, boolean bl) throws Exception {
        List<Object> list2 = actionContext.getTargetObjects();
        if (ArrayUtil.isNullOrEmpty(list2)) {
            return null;
        }
        String string = this._objectRefService.getResourceObjectType(list2.get(0));
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("Unsupported object type. Object: " + list2.get(0));
        }
        if (this.isContextHeterogeneous(list2, string)) {
            throw new UnsupportedOperationException("Cannot evaluate actions for multiple object types!");
        }
        if (bl) {
            list.add("disabledOperations");
        }
        if (ActionImpl.MANAGED_BY_ENTITIES.contains(string)) {
            list.add("config/managedBy/extensionKey");
        }
        if (ArrayUtil.isNullOrEmpty(list)) {
            return null;
        }
        ResultSet resultSet = this._queryService.select(list).from(new String[]{string}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, list2).fetch();
        PropertyValueMap propertyValueMap = this.transformResultSetToMap(resultSet);
        return propertyValueMap;
    }

    private boolean isContextHeterogeneous(List<Object> list, String string) {
        for (Object object : list) {
            if (string.equals(this._objectRefService.getResourceObjectType(object))) continue;
            return true;
        }
        return false;
    }

    private PropertyValueMap transformResultSetToMap(ResultSet resultSet) {
        List list = resultSet.getProperties();
        List list2 = resultSet.getItems();
        PropertyValueMap propertyValueMap = new PropertyValueMap();
        if (!list2.isEmpty()) {
            for (ResourceItem resourceItem : list2) {
                Object object = resourceItem.getKey();
                String string = this._objectRefService.getUid(object);
                for (int i = 0; i < resourceItem.getPropertyValues().size(); ++i) {
                    PropertyValue propertyValue = new PropertyValue();
                    propertyValue.propertyName = (String)list.get(i);
                    propertyValue.value = resourceItem.getPropertyValues().get(i);
                    propertyValueMap.putProperty(string, propertyValue);
                }
            }
        }
        return propertyValueMap;
    }
}

