/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.actionsfw.impl;

import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.ActionMenuItem;
import com.vmware.vise.actionsfw.ActionMenuItemSpec;
import com.vmware.vise.actionsfw.ActionMenuItemType;
import com.vmware.vise.actionsfw.ActionMenusRequestSpec;
import com.vmware.vise.actionsfw.ActionPriorityGroup;
import com.vmware.vise.actionsfw.ActionSpec;
import com.vmware.vise.actionsfw.ActionToolbarRequestSpec;
import com.vmware.vise.actionsfw.ActionsRequestSpec;
import com.vmware.vise.actionsfw.ActionsService;
import com.vmware.vise.actionsfw.RequestPolicy;
import com.vmware.vise.actionsfw.impl.ActionImpl;
import com.vmware.vise.actionsfw.impl.ActionMenuItemImpl;
import com.vmware.vise.actionsfw.impl.ActionsEvaluator;
import com.vmware.vise.actionsfw.impl.ActionsServiceUtil;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.impl.Filterer;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.FeatureUtil;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ActionsServiceImpl
implements ActionsService,
ExtensionListener {
    private final String ACTIONS_EXT_POINT;
    private final List<String> MENU_EXT_POINTS;
    private static final String CONTEXT_OBJECTS_FILTER_PROPERTY = "contextObjects";
    private static final Log _logger = LogFactory.getLog(ActionsServiceImpl.class);
    private final ExtensionService _extensionService;
    private final ActionsEvaluator _actionsEvaluator;
    private final ObjectReferenceService _objRefService;
    private final FeatureStateService _featureStateService;
    private final ServiceRegistry _serviceRegistry;
    private static final String OBJECT_TYPE = "objectType";
    private static final String GLOBAL_LIST_ACTIONS = "vmware.prioritization.listActions";
    private static final String SOLUTION_MENUS_EXTENSION_POINT = "vise.menus.context.solutionMenus";
    private final Map<String, ExtensionInfo> _eiByUid;
    private final Map<String, Set<String>> _actionUidsByType;
    private final Set<String> _globalActionUids;
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._readWriteLock.readLock();
    private final Lock _writeLock = this._readWriteLock.writeLock();

    public ActionsServiceImpl(ExtensionService extensionService, ActionsEvaluator actionsEvaluator, ObjectReferenceService objectReferenceService, FeatureStateService featureStateService, ServiceRegistry serviceRegistry, String string, List<String> list) {
        this.ACTIONS_EXT_POINT = string;
        this.MENU_EXT_POINTS = list;
        this._extensionService = extensionService;
        this._actionsEvaluator = actionsEvaluator;
        this._objRefService = objectReferenceService;
        this._featureStateService = featureStateService;
        this._serviceRegistry = serviceRegistry;
        this._eiByUid = new HashMap<String, ExtensionInfo>();
        this._actionUidsByType = new HashMap<String, Set<String>>();
        this._globalActionUids = new HashSet<String>();
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) {
        this.loadExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Action> getActions(ActionsRequestSpec actionsRequestSpec, boolean bl) throws NullPointerException {
        if (actionsRequestSpec == null) {
            throw new NullPointerException("ActionsRequestSpec must not be null when requesting Actions");
        }
        try {
            Collection<Object> collection;
            List<String> list;
            this._readLock.lock();
            boolean bl2 = false;
            Collection collection2 = this.getCandidateActions(actionsRequestSpec.globalActions);
            if (!ArrayUtil.isNullOrEmpty(actionsRequestSpec.actionUids)) {
                collection2 = CollectionUtil.intersection(collection2, actionsRequestSpec.actionUids);
                bl2 = true;
            }
            if ((list = this.getApplicableTargetTypes(actionsRequestSpec)) != null) {
                collection = this.getActionIdsByTargetType(list);
                if (actionsRequestSpec.globalActions == RequestPolicy.INCLUDE || actionsRequestSpec.globalActions == RequestPolicy.ONLY) {
                    collection.addAll(this._globalActionUids);
                }
                collection2 = CollectionUtil.intersection((Collection)collection2, collection);
            }
            Collection<Object> collection3 = collection = this.getActionsList(collection2, actionsRequestSpec.context, bl2, bl);
            return collection3;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActionEvaluation> getEvaluatedActions(ActionsRequestSpec actionsRequestSpec, boolean bl) throws Exception {
        if (actionsRequestSpec == null) {
            throw new NullPointerException("ActionsRequestSpec must not be null when evaluating Actions.");
        }
        if (actionsRequestSpec.context == null) {
            throw new NullPointerException("ActionContext must not be null when evaluating Actions.");
        }
        try {
            List<ActionEvaluation> list;
            this._readLock.lock();
            List<Action> list2 = this.getActions(actionsRequestSpec, bl);
            if (list2.size() < 1) {
                ArrayList<ActionEvaluation> arrayList = new ArrayList<ActionEvaluation>();
                return arrayList;
            }
            List<ActionEvaluation> list3 = list = this._actionsEvaluator.evaluate(list2, actionsRequestSpec.context, !bl);
            return list3;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActionMenuItem> getMenus(ActionMenusRequestSpec actionMenusRequestSpec) {
        try {
            this._readLock.lock();
            List<ActionMenuItem> list = this.getMenusInternal(actionMenusRequestSpec);
            if (actionMenusRequestSpec.context != null) {
                for (ActionMenuItem actionMenuItem : list) {
                    this.removeNonApplicableActions(actionMenuItem, actionMenusRequestSpec.context);
                }
            }
            this.sanitizeActionsList(list);
            List<ActionMenuItem> list2 = list;
            return list2;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionMenuItem getOrBuildMenu(ActionMenusRequestSpec actionMenusRequestSpec) {
        try {
            this._readLock.lock();
            ActionMenuItem actionMenuItem = null;
            List<ActionMenuItem> list = this.getFirstMenus(actionMenusRequestSpec);
            this.sanitizeActionsList(list);
            int n = list.size();
            if (n > 0) {
                if (n > 1) {
                    _logger.error((Object)"More than one menu available for the selected objects.");
                    for (int i = 1; i < n; ++i) {
                        _logger.error((Object)("Skipping menu with id: " + list.get(i).getId()));
                    }
                }
                actionMenuItem = list.get(0);
            }
            if (actionMenuItem == null) {
                ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
                actionsRequestSpec.globalActions = RequestPolicy.EXCLUDE;
                actionsRequestSpec.context = actionMenusRequestSpec.context;
                List<Action> list2 = this.getActions(actionsRequestSpec, false);
                actionMenuItem = this.buildMenu(list2);
            }
            ActionMenuItem actionMenuItem2 = actionMenuItem = this.removeNonApplicableActions(actionMenuItem, actionMenusRequestSpec.context);
            return actionMenuItem2;
        }
        finally {
            this._readLock.unlock();
        }
    }

    @Override
    public List<ActionMenuItem> getToolbarActions(ActionToolbarRequestSpec actionToolbarRequestSpec) {
        Object object2;
        if (actionToolbarRequestSpec == null) {
            throw new NullPointerException("ActionToolbarRequestSpec should not be null");
        }
        if (actionToolbarRequestSpec.listViewId == null) {
            throw new NullPointerException("listViewId should not be null");
        }
        List list = null;
        try {
            list = this._extensionService.getExtensionObjects(GLOBAL_LIST_ACTIONS, null, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _logger.error((Object)"Malformed list actions request.", (Throwable)illegalArgumentException);
        }
        if (list == null) {
            return new ArrayList<ActionMenuItem>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : list) {
            if (!actionToolbarRequestSpec.listViewId.equals(((ActionPriorityGroup)object2).regionId)) continue;
            arrayList.addAll(((ActionPriorityGroup)object2).prioritizedIds);
        }
        if (arrayList.isEmpty()) {
            return new ArrayList<ActionMenuItem>();
        }
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.globalActions = RequestPolicy.ONLY;
        actionsRequestSpec.context = actionToolbarRequestSpec.context;
        actionsRequestSpec.actionUids = arrayList;
        object2 = this.getActions(actionsRequestSpec, false);
        List<ActionMenuItem> list2 = this.buildMenuItems((List<Action>)object2);
        return list2;
    }

    private List<ActionMenuItem> getFirstMenus(ActionMenusRequestSpec actionMenusRequestSpec) {
        if (actionMenusRequestSpec.menuTypes == null) {
            return this.getMenusInternal(actionMenusRequestSpec);
        }
        ActionMenusRequestSpec actionMenusRequestSpec2 = new ActionMenusRequestSpec();
        actionMenusRequestSpec2.menuIds = actionMenusRequestSpec.menuIds;
        actionMenusRequestSpec2.context = actionMenusRequestSpec.context;
        for (String string : actionMenusRequestSpec.menuTypes) {
            actionMenusRequestSpec2.menuTypes = Collections.singletonList(string);
            List<ActionMenuItem> list = this.getMenusInternal(actionMenusRequestSpec2);
            if (list.isEmpty()) continue;
            return list;
        }
        return Collections.emptyList();
    }

    private ActionMenuItem removeNonApplicableActions(ActionMenuItem actionMenuItem, ActionContext actionContext) {
        List<String> list = ActionsServiceImpl.getActionIdsFromMenu(actionMenuItem);
        List<ActionImpl> list2 = this.getActionsList(list, actionContext, true, false);
        Map<String, ActionImpl> map = ActionsServiceImpl.buildActionsMap(list2);
        ActionsServiceImpl.removeNonApplicableActionsInternal(actionMenuItem, actionContext, map);
        return actionMenuItem;
    }

    private static void removeNonApplicableActionsInternal(ActionMenuItem actionMenuItem, ActionContext actionContext, Map<String, ActionImpl> map) {
        ListIterator<ActionMenuItem> listIterator = actionMenuItem.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ActionMenuItem actionMenuItem2 = listIterator.next();
            switch (actionMenuItem2.getType()) {
                case ACTION: {
                    ActionImpl actionImpl = map.get(actionMenuItem2.getId());
                    if (actionImpl != null && actionImpl.evaluateApplicability(actionContext)) break;
                    listIterator.remove();
                    break;
                }
                case MENU: {
                    ActionsServiceImpl.removeNonApplicableActionsInternal(actionMenuItem2, actionContext, map);
                    if (!actionMenuItem2.getChildren().isEmpty() || ActionsServiceImpl.isPluginMenu(actionMenuItem2)) break;
                    listIterator.remove();
                    break;
                }
            }
        }
        ActionsServiceImpl.removeUnwantedSeparators(actionMenuItem.getChildren());
    }

    private static boolean isPluginMenu(ActionMenuItem actionMenuItem) {
        return SOLUTION_MENUS_EXTENSION_POINT.equals(actionMenuItem.getExtendedPoint());
    }

    private static Map<String, ActionImpl> buildActionsMap(List<ActionImpl> list) {
        HashMap<String, ActionImpl> hashMap = new HashMap<String, ActionImpl>();
        for (Action action : list) {
            hashMap.put(action.getUid(), (ActionImpl)action);
        }
        return hashMap;
    }

    private static List<String> getActionIdsFromMenu(ActionMenuItem actionMenuItem) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ActionMenuItemType.ACTION.equals((Object)actionMenuItem.getType())) {
            arrayList.add(actionMenuItem.getId());
        } else if (ActionMenuItemType.MENU.equals((Object)actionMenuItem.getType())) {
            for (ActionMenuItem actionMenuItem2 : actionMenuItem.getChildren()) {
                arrayList.addAll(ActionsServiceImpl.getActionIdsFromMenu(actionMenuItem2));
            }
        }
        return arrayList;
    }

    private static List<String> getActionIdsFromMenus(List<ActionMenuItem> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ActionMenuItem actionMenuItem : list) {
            arrayList.addAll(ActionsServiceImpl.getActionIdsFromMenu(actionMenuItem));
        }
        return arrayList;
    }

    private ActionMenuItem buildMenu(List<Action> list) {
        ActionMenuItemSpec actionMenuItemSpec = new ActionMenuItemSpec();
        actionMenuItemSpec.type = ActionMenuItemType.MENU.name();
        ActionMenuItemImpl actionMenuItemImpl = new ActionMenuItemImpl(actionMenuItemSpec);
        actionMenuItemImpl.children = this.buildMenuItems(list);
        return actionMenuItemImpl;
    }

    private List<ActionMenuItem> buildMenuItems(List<Action> list) {
        ArrayList<ActionMenuItem> arrayList = new ArrayList<ActionMenuItem>(list.size());
        for (Action action : list) {
            ActionMenuItemSpec actionMenuItemSpec = new ActionMenuItemSpec();
            actionMenuItemSpec.icon = action.getIcon();
            actionMenuItemSpec.label = action.getLabel();
            actionMenuItemSpec.type = ActionMenuItemType.ACTION.name();
            actionMenuItemSpec.setUid(action.getUid());
            arrayList.add(new ActionMenuItemImpl(actionMenuItemSpec));
        }
        return arrayList;
    }

    private List<ActionMenuItem> getMenusInternal(ActionMenusRequestSpec actionMenusRequestSpec) {
        if (actionMenusRequestSpec == null) {
            throw new NullPointerException("ActionMenusRequestSpec must not be null.");
        }
        ArrayList<ActionMenuItem> arrayList = new ArrayList<ActionMenuItem>();
        Map<String, Object> map = this.createFilterContext(actionMenusRequestSpec.context);
        List<String> list = actionMenusRequestSpec.menuTypes != null ? actionMenusRequestSpec.menuTypes : this.MENU_EXT_POINTS;
        for (String string : list) {
            List list2;
            try {
                list2 = this._extensionService.getExtensionObjects(string, map, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                _logger.error((Object)"Malformed menus request.", (Throwable)illegalArgumentException);
                continue;
            }
            for (ActionMenuItemSpec actionMenuItemSpec : list2) {
                if (actionMenusRequestSpec.menuIds != null && !actionMenusRequestSpec.menuIds.contains(actionMenuItemSpec.getUid())) continue;
                arrayList.addAll(this.createMenuItems(actionMenusRequestSpec.context, actionMenuItemSpec, string));
            }
        }
        return arrayList;
    }

    private List<ActionMenuItem> createMenuItems(ActionContext actionContext, ActionMenuItemSpec actionMenuItemSpec, String string) {
        if (actionMenuItemSpec.type.equals("HOSTEDPOINT")) {
            if (this.isItemFilteredOut(actionMenuItemSpec)) {
                return Collections.emptyList();
            }
            if (actionMenuItemSpec.getUid().equals(SOLUTION_MENUS_EXTENSION_POINT)) {
                ExtensionInfo[] extensionInfoArray = this._extensionService.getExtensionInfos(actionMenuItemSpec.getUid());
                if (extensionInfoArray.length == 0) {
                    return Collections.emptyList();
                }
                Filterer filterer = new Filterer(true);
                List list = this._serviceRegistry.getServices(ExtensionObjectFilter.class.getName());
                List list2 = filterer.filter(Arrays.asList(extensionInfoArray), this.createFilterContext(actionContext), list);
                if (list2.isEmpty()) {
                    return Collections.emptyList();
                }
                List list3 = this._extensionService.getExtensionObjects(list2, null, true);
                ArrayList<ActionMenuItem> arrayList = new ArrayList<ActionMenuItem>();
                for (ActionMenuItemSpec actionMenuItemSpec2 : list3) {
                    ActionMenuItemImpl actionMenuItemImpl = new ActionMenuItemImpl(actionMenuItemSpec2, actionMenuItemSpec.getUid());
                    actionMenuItemImpl.children = new ArrayList<ActionMenuItem>();
                    arrayList.add(actionMenuItemImpl);
                }
                return arrayList;
            }
            ActionMenusRequestSpec actionMenusRequestSpec = new ActionMenusRequestSpec();
            actionMenusRequestSpec.context = actionContext;
            actionMenusRequestSpec.menuTypes = ArrayUtil.toArrayList((Object[])new String[]{actionMenuItemSpec.getUid()});
            return this.getMenusInternal(actionMenusRequestSpec);
        }
        ActionMenuItem actionMenuItem = this.createMenuItem(actionMenuItemSpec, string, actionContext);
        if (actionMenuItem == null) {
            return Collections.emptyList();
        }
        ArrayList arrayList = ArrayUtil.toArrayList((Object[])new ActionMenuItem[]{actionMenuItem});
        return arrayList;
    }

    private ActionMenuItem createMenuItem(ActionMenuItemSpec actionMenuItemSpec, String string, ActionContext actionContext) {
        ActionMenuItemImpl actionMenuItemImpl = new ActionMenuItemImpl(actionMenuItemSpec, string);
        if (this.isItemFilteredOut(actionMenuItemImpl)) {
            return null;
        }
        if (actionMenuItemImpl.getType().equals((Object)ActionMenuItemType.ACTION)) {
            if (actionMenuItemImpl.getIcon() == null || actionMenuItemImpl.getLabel() == null) {
                this.populateActionMenuItemFromAction(actionMenuItemImpl);
            }
            return actionMenuItemImpl;
        }
        if (actionMenuItemImpl.getType().equals((Object)ActionMenuItemType.MENU) && !ArrayUtil.isNullOrEmpty(actionMenuItemSpec.children)) {
            ArrayList<ActionMenuItem> arrayList = new ArrayList<ActionMenuItem>();
            for (ActionMenuItemSpec actionMenuItemSpec2 : actionMenuItemSpec.children) {
                arrayList.addAll(this.createMenuItems(actionContext, actionMenuItemSpec2, null));
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            actionMenuItemImpl.children = arrayList;
        }
        return actionMenuItemImpl;
    }

    private boolean isItemFilteredOut(ActionMenuItemImpl actionMenuItemImpl) {
        String string = StringUtil.returnNullIfEmpty((String)actionMenuItemImpl.getFeature());
        boolean bl = FeatureUtil.evaluateFeatureExpression((FeatureStateService)this._featureStateService, (String)string);
        return bl;
    }

    private boolean isItemFilteredOut(ActionMenuItemSpec actionMenuItemSpec) {
        String string = StringUtil.returnNullIfEmpty((String)actionMenuItemSpec.feature);
        boolean bl = FeatureUtil.evaluateFeatureExpression((FeatureStateService)this._featureStateService, (String)string);
        return bl;
    }

    private void sanitizeActionsList(List<ActionMenuItem> list) {
        ListIterator<ActionMenuItem> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ActionMenuItem actionMenuItem = listIterator.next();
            if (!actionMenuItem.getType().equals((Object)ActionMenuItemType.MENU) || ActionsServiceImpl.isPluginMenu(actionMenuItem)) continue;
            this.sanitizeActionsList(actionMenuItem.getChildren());
            if (!actionMenuItem.getChildren().isEmpty()) continue;
            _logger.debug((Object)("Removed from list while sanitizing menu since submenu was empty" + actionMenuItem.getId()));
            listIterator.remove();
        }
        ActionsServiceImpl.removeUnwantedSeparators(list);
    }

    private static void removeUnwantedSeparators(List<ActionMenuItem> list) {
        ListIterator<ActionMenuItem> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ActionMenuItem actionMenuItem;
            int n;
            ActionMenuItem actionMenuItem2 = listIterator.next();
            if (!actionMenuItem2.getType().equals((Object)ActionMenuItemType.SEPARATOR) || !listIterator.hasPrevious() || (n = listIterator.previousIndex() - 1) <= -1 || !(actionMenuItem = list.get(n)).getType().equals((Object)ActionMenuItemType.SEPARATOR)) continue;
            _logger.debug((Object)"Removed consecutive separators");
            listIterator.remove();
        }
        if (list.size() > 0 && list.get(0).getType().equals((Object)ActionMenuItemType.SEPARATOR)) {
            list.remove(0);
        }
        if (list.size() > 0 && list.get(list.size() - 1).getType().equals((Object)ActionMenuItemType.SEPARATOR)) {
            list.remove(list.size() - 1);
        }
    }

    private void populateActionMenuItemFromAction(ActionMenuItemImpl actionMenuItemImpl) {
        ExtensionInfo extensionInfo = this._eiByUid.get(actionMenuItemImpl.getId());
        ActionSpec actionSpec = null;
        if (extensionInfo != null) {
            actionSpec = (ActionSpec)this._extensionService.getExtensionObject(extensionInfo, null, true);
        }
        if (actionSpec == null) {
            _logger.error((Object)("Action not found: " + actionMenuItemImpl.getId()));
        } else {
            if (actionMenuItemImpl.getLabel() == null) {
                actionMenuItemImpl.label = actionSpec.label;
            }
            if (actionMenuItemImpl.getIcon() == null) {
                actionMenuItemImpl.icon = actionSpec.icon;
            }
        }
    }

    private List<String> getTargetTypes(List<Object> list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return new ArrayList<String>();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : list) {
            hashSet.add(ActionsServiceUtil.getTargetType(object, this._objRefService));
        }
        return new ArrayList<String>(hashSet);
    }

    private Collection<String> getCandidateActions(RequestPolicy requestPolicy) {
        Set<String> set = requestPolicy == RequestPolicy.INCLUDE ? this._eiByUid.keySet() : (requestPolicy == RequestPolicy.ONLY ? this._globalActionUids : CollectionUtil.minus(this._eiByUid.keySet(), this._globalActionUids));
        return set;
    }

    private List<String> getApplicableTargetTypes(ActionsRequestSpec actionsRequestSpec) {
        Collection<String> collection = null;
        if (!ArrayUtil.isNullOrEmpty(actionsRequestSpec.targetTypes)) {
            collection = new HashSet<String>(actionsRequestSpec.targetTypes);
        }
        if (actionsRequestSpec.context != null && !ArrayUtil.isNullOrEmpty(actionsRequestSpec.context.getTargetObjects())) {
            List<String> list = this.getTargetTypes(actionsRequestSpec.context.getTargetObjects());
            collection = CollectionUtil.intersection(list, collection);
        }
        return collection == null ? null : new ArrayList<String>(collection);
    }

    private List<ActionImpl> getActionsList(Collection<String> collection, ActionContext actionContext, boolean bl, boolean bl2) {
        Object object;
        if (collection.size() == 0) {
            return new ArrayList<ActionImpl>(0);
        }
        ArrayList<ActionImpl> arrayList = new ArrayList<ActionImpl>(collection.size());
        ArrayList<ExtensionInfo> arrayList2 = new ArrayList<ExtensionInfo>(collection.size());
        for (String object22 : collection) {
            if (object22 == null) {
                throw new NullPointerException("ActionsRequestSpec.actionUids must not contain null");
            }
            object = this._eiByUid.get(object22);
            if (object == null) {
                _logger.error((Object)("No action with uid" + object22 + " registered with the ActionsService"));
                continue;
            }
            arrayList2.add((ExtensionInfo)object);
        }
        Object object3 = null;
        object3 = bl2 ? this._extensionService.getExtensionObjects(arrayList2, null, true) : this._extensionService.getExtensionObjects(arrayList2, this.createFilterContext(actionContext), true);
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object = (ActionSpec)iterator.next();
            if (!bl && object.privateAction) continue;
            arrayList.add(this.createAction((ActionSpec)object));
        }
        return arrayList;
    }

    private Set<String> getActionIdsByTargetType(List<String> list) {
        if (ArrayUtil.isNullOrEmpty(list)) {
            return new HashSet<String>();
        }
        HashSet<String> hashSet = null;
        for (String string : list) {
            if (string == null) {
                throw new NullPointerException("ActionsRequestSpec.targetTypes should not contain null");
            }
            Set<String> set = this._actionUidsByType.get(string);
            if (set == null) {
                if (!this._actionUidsByType.keySet().contains(string)) {
                    _logger.warn((Object)("No Actions registered for target type " + string + "."));
                }
                set = new HashSet<String>();
            }
            if (hashSet == null) {
                hashSet = new HashSet<String>(set);
            } else {
                hashSet.retainAll(set);
            }
            if (hashSet.size() != 0) continue;
            break;
        }
        return hashSet;
    }

    private Map<String, Object> createFilterContext(ActionContext actionContext) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (actionContext != null && !ArrayUtil.isNullOrEmpty(actionContext.getTargetObjects())) {
            hashMap.put(CONTEXT_OBJECTS_FILTER_PROPERTY, actionContext.getTargetObjects().toArray());
        }
        return hashMap;
    }

    private ActionImpl createAction(ActionSpec actionSpec) {
        ExtensionInfo extensionInfo = this._eiByUid.get(actionSpec.getUid());
        List<String> list = this.getApplicableTypes(extensionInfo);
        return new ActionImpl(actionSpec, list, this._objRefService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions() {
        try {
            ExtensionInfo[] extensionInfoArray;
            this._writeLock.lock();
            this._eiByUid.clear();
            this._actionUidsByType.clear();
            this._globalActionUids.clear();
            for (ExtensionInfo extensionInfo : extensionInfoArray = this._extensionService.getAllExtensionInfos(this.ACTIONS_EXT_POINT)) {
                this._eiByUid.put(extensionInfo.getId(), extensionInfo);
                this.addEiToTypesCache(extensionInfo);
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }

    private void addEiToTypesCache(ExtensionInfo extensionInfo) {
        List<String> list = this.getApplicableTypes(extensionInfo);
        if (list.size() == 0) {
            this._globalActionUids.add(extensionInfo.getId());
            return;
        }
        for (String string : list) {
            Set<String> set = this._actionUidsByType.get(string);
            if (set == null) {
                set = new HashSet<String>();
                this._actionUidsByType.put(string, set);
            }
            set.add(extensionInfo.getId());
        }
    }

    private List<String> getApplicableTypes(ExtensionInfo extensionInfo) {
        Map map = extensionInfo.getMetadata();
        Object object = null;
        if (map != null) {
            object = map.get(OBJECT_TYPE);
        }
        if (object == null) {
            return new ArrayList<String>();
        }
        return ArrayUtil.toArrayList((Object[])StringUtil.splitAndTrim((String)object.toString(), (String)","));
    }
}

