/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.is.converter;

import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.is.converter.exception.ConverterException;
import com.vmware.vim.binding.vmodl.Binary;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodName;
import com.vmware.vim.binding.vmodl.PropertyPath;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.vmomi.core.soap.impl.CalendarHelper;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class Converter {
    private static final ObjectConverter DEFAULT_CONVERTER = new ObjectConverter(){

        @Override
        public DataValue convert(Object object) {
            return new StringValue(object.toString());
        }
    };
    private static final ObjectConverter LIST_CONVERTER = new ObjectConverter(){

        @Override
        public DataValue convert(Object object) {
            ListValue listValue = new ListValue();
            for (int i = 0; i < Array.getLength(object); ++i) {
                Object element = Array.get(object, i);
                listValue.add(Converter.convert(element));
            }
            return listValue;
        }
    };
    private static final ObjectConverter DATA_OBJECT_CONVERTER = new ObjectConverter(){

        @Override
        public DataValue convert(Object object) {
            StructValue structure = new StructValue(Converter.generateStructureName(object));
            for (Method method : object.getClass().getMethods()) {
                if (!Converter.isVmodlPropertyGetMethod(method)) continue;
                Object value = null;
                try {
                    value = method.invoke(object, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new ConverterException("Error invoking getter " + method.getName());
                }
                catch (IllegalAccessException e) {
                    throw new ConverterException("Error invoking getter " + method.getName());
                }
                catch (InvocationTargetException e) {
                    throw new ConverterException("Error invoking getter " + method.getName());
                }
                String fieldName = Converter.generateFieldName(method.getName());
                DataValue dataValue = Converter.convert(value);
                structure.setField(fieldName, dataValue);
            }
            return structure;
        }
    };
    private static final ObjectConverter EXCEPTION_CONVERTER = new ObjectConverter(){

        @Override
        public DataValue convert(Object object) {
            ErrorValue error = new ErrorValue(Converter.generateStructureName(object));
            for (Method method : object.getClass().getMethods()) {
                if (method.getReturnType() == Void.TYPE || this.isExceptionMethod(method)) continue;
                Object value = null;
                try {
                    value = method.invoke(object, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new ConverterException("Error invoking getter " + method.getName());
                }
                catch (IllegalAccessException e) {
                    throw new ConverterException("Error invoking getter " + method.getName());
                }
                catch (InvocationTargetException e) {
                    throw new ConverterException("Error invoking getter " + method.getName());
                }
                String fieldName = Converter.generateFieldName(method.getName());
                DataValue dataValue = Converter.convert(value);
                error.setField(fieldName, dataValue);
            }
            return error;
        }

        private boolean isExceptionMethod(Method method) {
            if ("getMessage".equals(method.getName())) {
                return false;
            }
            for (Method exceptionMethod : Exception.class.getMethods()) {
                if (!exceptionMethod.getName().equals(method.getName())) continue;
                return true;
            }
            return false;
        }
    };
    private static final ObjectConverter MO_REF_CONVERTER = new ObjectConverter(){

        @Override
        public DataValue convert(Object object) {
            ManagedObjectReference moRef = (ManagedObjectReference)object;
            StructValue result = new StructValue(Converter.generateStructureName(object));
            if (moRef.getType() != null) {
                result.setField("type", Converter.convert(moRef.getType()));
            }
            if (moRef.getValue() != null) {
                result.setField("value", Converter.convert(moRef.getValue()));
            }
            if (moRef.getServerGuid() != null) {
                result.setField("serverGuid", Converter.convert(moRef.getServerGuid()));
            }
            return result;
        }
    };
    public static final ObjectConverter CALENDAR_CONVERTER = new ObjectConverter(){

        @Override
        public DataValue convert(Object object) {
            return new StringValue(CalendarHelper.formatXsdDateTime((Calendar)((Calendar)object)));
        }
    };
    private static Map<Class<?>, ObjectConverter> CONVERTER_MAP = new HashMap();

    private static String generateStructureName(Object object) {
        String result = object.getClass().getSimpleName();
        if (result.endsWith("Impl")) {
            result = result.substring(0, result.length() - 4);
        }
        return result;
    }

    private static String generateFieldName(String getterName) {
        String result = null;
        result = getterName.startsWith("get") ? getterName.substring(3) : (getterName.startsWith("is") ? getterName.substring(2) : getterName);
        return Character.toLowerCase(result.charAt(0)) + (result.length() > 1 ? result.substring(1) : "");
    }

    private static boolean isVmodlPropertyGetMethod(Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return false;
        }
        if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
            return false;
        }
        for (Method objMethod : Object.class.getMethods()) {
            if (!objMethod.getName().equals(method.getName())) continue;
            return false;
        }
        return true;
    }

    public static DataValue convert(Object object) {
        if (object == null) {
            return new OptionalValue();
        }
        ObjectConverter converter = null;
        converter = object instanceof DataObject ? DATA_OBJECT_CONVERTER : (object instanceof Exception ? EXCEPTION_CONVERTER : (object.getClass().isArray() ? LIST_CONVERTER : (object instanceof Calendar ? CALENDAR_CONVERTER : CONVERTER_MAP.get(object.getClass()))));
        if (converter == null) {
            converter = DEFAULT_CONVERTER;
        }
        return converter.convert(object);
    }

    static {
        CONVERTER_MAP.put(Short.class, new ObjectConverter(){

            @Override
            public DataValue convert(Object object) {
                return new IntegerValue(((Short)object).longValue());
            }
        });
        CONVERTER_MAP.put(Byte.class, new ObjectConverter(){

            @Override
            public DataValue convert(Object object) {
                return new IntegerValue(((Byte)object).longValue());
            }
        });
        CONVERTER_MAP.put(Integer.class, new ObjectConverter(){

            @Override
            public DataValue convert(Object object) {
                return new IntegerValue(((Integer)object).longValue());
            }
        });
        CONVERTER_MAP.put(Long.class, new ObjectConverter(){

            @Override
            public DataValue convert(Object object) {
                return new IntegerValue(((Long)object).longValue());
            }
        });
        CONVERTER_MAP.put(Float.class, new ObjectConverter(){

            @Override
            public DataValue convert(Object object) {
                return new DoubleValue(((Float)object).doubleValue());
            }
        });
        CONVERTER_MAP.put(Double.class, new ObjectConverter(){

            @Override
            public DataValue convert(Object object) {
                return new DoubleValue(((Double)object).doubleValue());
            }
        });
        CONVERTER_MAP.put(Boolean.class, new ObjectConverter(){

            @Override
            public DataValue convert(Object object) {
                if (Boolean.TRUE.equals(object)) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
        });
        CONVERTER_MAP.put(String.class, DEFAULT_CONVERTER);
        CONVERTER_MAP.put(TypeName.class, new ObjectConverter(){

            @Override
            public DataValue convert(Object object) {
                return new StringValue(((TypeName)object).getName());
            }
        });
        CONVERTER_MAP.put(MethodName.class, new ObjectConverter(){

            @Override
            public DataValue convert(Object object) {
                return new StringValue(((MethodName)object).getName());
            }
        });
        CONVERTER_MAP.put(PropertyPath.class, DEFAULT_CONVERTER);
        CONVERTER_MAP.put(URI.class, DEFAULT_CONVERTER);
        CONVERTER_MAP.put(Enum.class, DEFAULT_CONVERTER);
        CONVERTER_MAP.put(Binary.class, new ObjectConverter(){

            @Override
            public DataValue convert(Object object) {
                return new BlobValue(((Binary)object).asArray());
            }
        });
        CONVERTER_MAP.put(ManagedObjectReference.class, MO_REF_CONVERTER);
    }

    private static interface ObjectConverter {
        public DataValue convert(Object var1);
    }
}

