/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.context.support;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class WebsocketHttpSession
implements HttpSession {
    private static final ServletContext _servletContext = WebsocketHttpSession.createDummyServletContext();
    private final String _sessionId;
    private final ConcurrentMap<String, Object> _attributes = new ConcurrentHashMap<String, Object>();

    public WebsocketHttpSession(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The session ID should not be null");
        }
        this._sessionId = string;
    }

    public String getId() {
        return this._sessionId;
    }

    public Object getAttribute(String string) {
        Object v = this._attributes.get(string);
        return v;
    }

    public Object getValue(String string) {
        return this.getAttribute(string);
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration<String> enumeration = this.doGetAttributeNames();
        return enumeration;
    }

    private Enumeration<String> doGetAttributeNames() {
        Set set = this._attributes.keySet();
        final Iterator iterator = set.iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }

    public String[] getValueNames() {
        Enumeration<String> enumeration = this.doGetAttributeNames();
        if (!enumeration.hasMoreElements()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setAttribute(String string, Object object) {
        this._attributes.put(string, object);
    }

    public void putValue(String string, Object object) {
        this.setAttribute(string, object);
    }

    public void removeAttribute(String string) {
        this._attributes.remove(string);
    }

    public void removeValue(String string) {
        this.removeAttribute(string);
    }

    public void invalidate() {
    }

    public ServletContext getServletContext() {
        return _servletContext;
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public long getLastAccessedTime() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public void setMaxInactiveInterval(int n) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public int getMaxInactiveInterval() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public boolean isNew() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    private static ServletContext createDummyServletContext() {
        return new ServletContext(){

            public ServletContext getContext(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public String getContextPath() {
                return "/websocket";
            }

            public int getMajorVersion() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public int getMinorVersion() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public String getMimeType(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public Set<String> getResourcePaths(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public URL getResource(String string) throws MalformedURLException {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public InputStream getResourceAsStream(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public RequestDispatcher getRequestDispatcher(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public RequestDispatcher getNamedDispatcher(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public Servlet getServlet(String string) throws ServletException {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public Enumeration<Servlet> getServlets() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public Enumeration<String> getServletNames() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public void log(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public void log(Exception exception, String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public void log(String string, Throwable throwable) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public String getRealPath(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public String getServerInfo() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public String getInitParameter(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public Enumeration<String> getInitParameterNames() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public Object getAttribute(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public Enumeration<String> getAttributeNames() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public void setAttribute(String string, Object object) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public void removeAttribute(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public String getServletContextName() {
                return "WebSocket";
            }

            public void declareRoles(String ... stringArray) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public FilterRegistration.Dynamic addFilter(String string, String string2) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public FilterRegistration.Dynamic addFilter(String string, Filter filter) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public FilterRegistration.Dynamic addFilter(String string, Class<? extends Filter> clazz) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public void addListener(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public <T extends EventListener> void addListener(T t) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public void addListener(Class<? extends EventListener> clazz) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public ServletRegistration.Dynamic addServlet(String string, String string2) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public ServletRegistration.Dynamic addServlet(String string, Servlet servlet) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public ServletRegistration.Dynamic addServlet(String string, Class<? extends Servlet> clazz) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public ClassLoader getClassLoader() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public int getEffectiveMajorVersion() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public int getEffectiveMinorVersion() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public FilterRegistration getFilterRegistration(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public JspConfigDescriptor getJspConfigDescriptor() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public ServletRegistration getServletRegistration(String string) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public Map<String, ? extends ServletRegistration> getServletRegistrations() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public SessionCookieConfig getSessionCookieConfig() {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public boolean setInitParameter(String string, String string2) {
                throw new UnsupportedOperationException("Unsupported operation");
            }

            public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
                throw new UnsupportedOperationException("Unsupported operation");
            }
        };
    }
}

