/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.websocket;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.messaging.context.support.ClientIdHolder;
import com.vmware.vise.vim.messaging.websocket.BroadcastService;
import com.vmware.vise.vim.messaging.websocket.Controller;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;

public class LiveUpdatesEndpoint
extends Endpoint {
    private static final Log _logger = LogFactory.getLog(LiveUpdatesEndpoint.class);
    private final ObjectFactory<MessageSender> _messageSenderFactory;
    private final Controller _controller;
    private BroadcastService _broadcastService;

    public LiveUpdatesEndpoint(ObjectFactory<MessageSender> objectFactory, Controller controller, BroadcastService broadcastService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectFactory, controller, broadcastService});
        this._messageSenderFactory = objectFactory;
        this._controller = controller;
        this._broadcastService = broadcastService;
    }

    public LiveUpdatesEndpoint(ObjectFactory<MessageSender> objectFactory, Controller controller) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectFactory, controller});
        this._messageSenderFactory = objectFactory;
        this._controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(final Session session, EndpointConfig endpointConfig) {
        Map map = session.getUserProperties();
        map.put("org.apache.tomcat.websocket.BLOCKING_SEND_TIMEOUT", TimeUnit.MINUTES.toMillis(10L));
        final String string = (String)map.get("webClientSessionId");
        if (string == null) {
            _logger.warn((Object)"[LiveRefresh] Trying to open WebSocket connection without a clientId.");
            return;
        }
        if (!SessionUtil.isValidClientId((String)string)) {
            _logger.info((Object)"[LiveRefresh] Trying to open WebSocket connection on already logged out session.");
            return;
        }
        ClientIdHolder.setClientId(string);
        try {
            MessageSender messageSender = (MessageSender)this._messageSenderFactory.getObject();
            messageSender.addSession(session);
            _logger.info((Object)("[LiveRefresh] websocket connection opened: " + session.getId()));
            session.addMessageHandler((MessageHandler)new MessageHandler.Partial<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMessage(String string2, boolean bl) {
                    if (!SessionUtil.isValidClientId((String)string)) {
                        return;
                    }
                    ClientIdHolder.setClientId(string);
                    try {
                        LiveUpdatesEndpoint.this._controller.handleRequest(string2, session);
                    }
                    catch (Exception exception) {
                        _logger.error((Object)("[LiveRefresh] Error responding on subscription request:" + string2), (Throwable)exception);
                    }
                    finally {
                        ClientIdHolder.resetClientId();
                    }
                }
            });
            if (this._broadcastService != null) {
                this._broadcastService.addSender(messageSender);
            }
        }
        finally {
            ClientIdHolder.resetClientId();
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        _logger.info((Object)("[LiveRefresh] onClose: " + session.getId() + " " + closeReason));
        this.cleanUp(session, "[LiveRefresh] onClose:");
    }

    public void onError(Session session, Throwable throwable) {
        super.onError(session, throwable);
        _logger.warn((Object)("[LiveRefresh] onError: " + session.getId() + " WebSocket connection exception: " + session.getId() + " threw " + throwable.getClass().getSimpleName() + " with message: " + throwable.getMessage()));
        this.cleanUp(session, "[LiveRefresh] onError:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(Session session, String string) {
        String string2 = (String)session.getUserProperties().get("webClientSessionId");
        if (string2 == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)(string + " on session with null clientId."));
            }
            return;
        }
        if (!SessionUtil.isValidClientId((String)string2)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)(string + " on already logged out session."));
            }
            return;
        }
        ClientIdHolder.setClientId(string2);
        try {
            MessageSender messageSender = (MessageSender)this._messageSenderFactory.getObject();
            if (this._broadcastService != null) {
                this._broadcastService.removeSender(messageSender);
            }
            messageSender.removeSession(session);
        }
        finally {
            ClientIdHolder.resetClientId();
        }
    }
}

