/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vise.core.model.Message;
import com.vmware.vise.core.model.ModelChangeMessage;
import com.vmware.vise.core.model.ObjectChangeInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.messaging.websocket.MessagingService;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessagingServiceImpl
implements MessagingService {
    private static final Log _logger = LogFactory.getLog(MessagingServiceImpl.class);

    @Override
    public void sendMessage(Message message) {
        ObjectMapper objectMapper = new ObjectMapper();
        String string = null;
        try {
            string = objectMapper.writeValueAsString((Object)message);
        }
        catch (Exception exception) {
            _logger.error((Object)"Exception while converting message to json: ", (Throwable)exception);
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.error((Object)"Empty message will not be sent.");
            return;
        }
        MessagingServiceImpl.sendMessage(string);
    }

    @Override
    public void sendMessage(ObjectChangeInfo objectChangeInfo) {
        if (objectChangeInfo == null || StringUtil.isNullOrEmpty((String)objectChangeInfo.objectId)) {
            return;
        }
        ModelChangeMessage modelChangeMessage = new ModelChangeMessage();
        modelChangeMessage.setObjectChangeInfo(objectChangeInfo);
        this.sendMessage((Message)modelChangeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendMessage(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.error((Object)"Empty message will not be sent.");
            return;
        }
        Set set = (Set)SessionUtil.getData((String)"appwebsocketconnection");
        if (CollectionUtil.isNullOrEmpty((Collection)set)) {
            return;
        }
        Set set2 = set;
        synchronized (set2) {
            for (Session session : set) {
                try {
                    session.getBasicRemote().sendText(string);
                }
                catch (IOException iOException) {
                    _logger.error((Object)"Could not send message on websocket.", (Throwable)iOException);
                }
            }
        }
    }
}

