/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.websocket;

import com.vmware.vise.util.session.SessionUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;

public class SelfRefreshEndpoint
extends Endpoint {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        Map map = session.getUserProperties();
        map.put("org.apache.tomcat.websocket.BLOCKING_SEND_TIMEOUT", TimeUnit.MINUTES.toMillis(10L));
        HttpSession httpSession = (HttpSession)map.get("websockethttpsession");
        SessionUtil.setHttpSession((HttpSession)httpSession);
        try {
            SelfRefreshEndpoint.saveClientMessageSession(session);
        }
        finally {
            SessionUtil.setHttpSession(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        Map map = session.getUserProperties();
        HttpSession httpSession = (HttpSession)map.get("websockethttpsession");
        String string = (String)map.get("webClientSessionId");
        SessionUtil.setHttpSession((HttpSession)httpSession);
        try {
            SelfRefreshEndpoint.removeClientMessageSession(session, string);
        }
        finally {
            SessionUtil.setHttpSession(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Session session, Throwable throwable) {
        super.onError(session, throwable);
        Map map = session.getUserProperties();
        HttpSession httpSession = (HttpSession)map.get("websockethttpsession");
        String string = (String)map.get("webClientSessionId");
        SessionUtil.setHttpSession((HttpSession)httpSession);
        try {
            SelfRefreshEndpoint.removeClientMessageSession(session, string);
        }
        finally {
            SessionUtil.setHttpSession(null);
        }
    }

    private static void saveClientMessageSession(Session session) {
        Set<Session> set = (Set<Session>)SessionUtil.getData((String)"appwebsocketconnection");
        if (set == null) {
            set = Collections.synchronizedSet(new HashSet());
            set.add(session);
            Object object = SessionUtil.setDataIfAbsent((String)"appwebsocketconnection", set);
            if (object != null) {
                ((Set)object).add(session);
            }
        } else {
            set.add(session);
        }
    }

    private static void removeClientMessageSession(Session session, String string) {
        Set set = (Set)SessionUtil.getData((String)"appwebsocketconnection", (String)string);
        if (set == null) {
            return;
        }
        set.remove(session);
        if (set.isEmpty()) {
            SessionUtil.removeData((String)"appwebsocketconnection", (String)string);
        }
    }
}

