/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.websocket;

import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class SpringConfigurator
extends ServerEndpointConfig.Configurator {
    private static Log _logger = LogFactory.getLog(SpringConfigurator.class);

    public void modifyHandshake(ServerEndpointConfig serverEndpointConfig, HandshakeRequest handshakeRequest, HandshakeResponse handshakeResponse) {
        String string;
        List list;
        super.modifyHandshake(serverEndpointConfig, handshakeRequest, handshakeResponse);
        HttpSession httpSession = (HttpSession)handshakeRequest.getHttpSession();
        if (httpSession == null) {
            _logger.info((Object)"httpSession is null.");
        }
        if (!ArrayUtil.isNullOrEmpty((List)(list = (List)handshakeRequest.getParameterMap().get("webClientSessionId")))) {
            string = (String)list.get(0);
        } else {
            List list2 = (List)handshakeRequest.getHeaders().get("webClientSessionId");
            if (!ArrayUtil.isNullOrEmpty((List)list2)) {
                string = (String)list2.get(0);
            } else {
                _logger.info((Object)"Trying to extract the clientId from the http session.");
                string = SessionUtil.getClientId((HttpSession)httpSession);
            }
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.error((Object)"clientId is null or empty.");
        }
        serverEndpointConfig.getUserProperties().put("webClientSessionId", string);
        serverEndpointConfig.getUserProperties().put("websockethttpsession", httpSession);
    }

    public <T> T getEndpointInstance(Class<T> clazz) throws InstantiationException {
        WebApplicationContext webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
        if (webApplicationContext == null) {
            String string = "Failed to find the root WebApplicationContext. Was ContextLoaderListener not used?";
            _logger.error((Object)string);
            throw new IllegalStateException(string);
        }
        String string = ClassUtils.getShortNameAsProperty(clazz);
        if (webApplicationContext.containsBean(string)) {
            Object object = webApplicationContext.getBean(string, clazz);
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)("Using @ServerEndpoint singleton " + object));
            }
            return (T)object;
        }
        throw new InstantiationException("No bean of type " + clazz.getName() + " was found in the WebApplicationContext.");
    }
}

