/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.websocket.webconsole;

import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.messaging.websocket.webconsole.AuthdException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class AuthdClient {
    private String _host;
    private String _vmId;
    private int _port;
    private String _rand;
    private Socket _socket;
    private PrintWriter _out;
    private BufferedReader _in;
    private String _cfgFile;
    private String _thumbprint;
    private boolean _connected = false;
    private String _ticket;
    private Socket _sslSocket;
    private Socket _sslSocket2;
    private static SSLConnectionSocketFactory socketFactory;
    private static final Log _logger;
    private static final int THUMBPRINT_LENGTH = 12;

    public AuthdClient(String string, String string2, int n, String string3, String string4, String string5) {
        TrustManager[] trustManagerArray = new TrustManager[]{new ThumbprintTrustManager()};
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            socketFactory = new SSLConnectionSocketFactory(sSLContext, (HostnameVerifier)new SimpleVerifier());
        }
        catch (Exception exception) {
            throw new AuthdException("Could not initialize the SSL context. " + exception.getMessage());
        }
        System.setProperty("line.separator", "\r\n");
        this._host = string;
        this._vmId = string2;
        this._port = n;
        this._cfgFile = string3;
        this._ticket = string4;
        this._thumbprint = string5;
        _logger.info((Object)("[webconsole] Starting Authd client for vm " + this._vmId));
    }

    public Socket connect() throws IOException {
        this._socket = new Socket(this._host, this._port);
        this._out = new PrintWriter((Writer)new OutputStreamWriter(this._socket.getOutputStream(), StandardCharsets.UTF_8), true);
        this._in = new BufferedReader(new InputStreamReader(this._socket.getInputStream(), StandardCharsets.UTF_8));
        this._rand = this.generateThumbprint();
        this.processAnswer(this._in.readLine(), 220);
        this.processAnswer(this._in.readLine(), 331);
        this.processAnswer(this._in.readLine(), 230);
        this.processAnswer(this._in.readLine(), 200);
        this.processAnswer(this._in.readLine(), 200);
        this._out.write(this._rand);
        this._out.flush();
        return this._sslSocket2;
    }

    public void disconnect() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
        if (this._out != null) {
            this._out.close();
            this._out = null;
        }
        if (this._sslSocket2 != null) {
            this._sslSocket2.close();
            this._sslSocket2 = null;
        }
        if (this._sslSocket != null) {
            this._sslSocket.close();
            this._sslSocket = null;
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        _logger.info((Object)("[webconsole] Authd connection closed for vm " + this._vmId));
    }

    private String generateThumbprint() {
        SecureRandom secureRandom;
        byte[] byArray = new byte[12];
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthdException("Unexpected error has occurred.", noSuchAlgorithmException);
        }
        secureRandom.nextBytes(byArray);
        return new String(Base64.encodeBase64((byte[])byArray));
    }

    private void processAnswer(String string, int n) throws AuthdException {
        if (string == null) {
            throw new AuthdException("Empty Authd answer");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        if (n2 != n) {
            throw new AuthdException(n2 >= 500 ? string : "Unexpected Authd answer");
        }
        switch (n2) {
            case 220: {
                this.wrapSocket();
                this.reply("USER " + this._ticket);
                break;
            }
            case 331: {
                this.reply("PASS " + this._ticket);
                break;
            }
            case 230: {
                this._ticket = null;
                _logger.debug((Object)"authd login with ticket accepted.");
                this.reply("THUMBPRINT " + this._rand);
                break;
            }
            case 200: {
                if (!this._connected) {
                    this.reply("CONNECT " + this._cfgFile + " mks");
                    this._connected = true;
                    break;
                }
                this.wrapSocket();
            }
        }
    }

    private void wrapSocket() {
        try {
            Socket socket = socketFactory.createLayeredSocket(this._socket, this._socket.getInetAddress().getHostAddress(), this._socket.getPort(), null);
            socket.setKeepAlive(true);
            if (this._sslSocket == null) {
                this._sslSocket = socket;
            } else {
                this._sslSocket2 = socket;
            }
            this._out = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8), true);
            this._in = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            throw new AuthdException("Unexpected", exception);
        }
    }

    private void reply(String string) {
        _logger.debug((Object)("< " + string));
        this._out.println(string);
    }

    public static String getThumbPrint(X509Certificate x509Certificate) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = x509Certificate.getEncoded();
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            return AuthdClient.hexify(byArray2);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            throw new AuthdException("Unexpected", generalSecurityException);
        }
    }

    public static String hexify(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append(cArray[(by & 0xF0) >> 4]);
            stringBuilder.append(cArray[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    static {
        _logger = LogFactory.getLog(AuthdClient.class);
    }

    private class ThumbprintTrustManager
    implements X509TrustManager {
        private ThumbprintTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            throw new RuntimeException("Not implemented.");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            if (AuthdClient.this._thumbprint == null) {
                _logger.warn((Object)"No thumbprint checking is performed.");
                return;
            }
            String string2 = this.normalize(AuthdClient.this._thumbprint);
            boolean bl = false;
            String string3 = "";
            for (X509Certificate x509Certificate : x509CertificateArray) {
                String string4;
                if (_logger.isDebugEnabled()) {
                    string3 = string3 + x509Certificate.toString();
                }
                if (!string2.equals(string4 = AuthdClient.getThumbPrint(x509Certificate))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                _logger.debug((Object)("Cannot trust given server certificate: " + string3));
                throw new AuthdException("Cannot trust given server certificate");
            }
        }

        private String normalize(String string) {
            return string.replaceAll(":", "").toLowerCase();
        }
    }

    private static class SimpleVerifier
    implements HostnameVerifier {
        private SimpleVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            Object[] objectArray;
            Object[] objectArray2;
            String string2 = sSLSession.getPeerHost();
            try {
                objectArray2 = InetAddress.getAllByName(string2);
                objectArray = InetAddress.getAllByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
            InetAddress[] inetAddressArray = (InetAddress[])ArrayUtil.retainAll((Object[])objectArray2, (Object[])objectArray);
            return inetAddressArray.length > 0;
        }
    }
}

