/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.websocket.webconsole;

import com.vmware.vise.vim.messaging.websocket.webconsole.AuthdException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteConsoleBinaryMessageHandler
implements MessageHandler.Partial<ByteBuffer> {
    private static final Log _logger = LogFactory.getLog(RemoteConsoleBinaryMessageHandler.class);
    private final OutputStream _outputStream;
    private final Socket _socket;
    private final Session _session;
    private final String _vmId;

    public RemoteConsoleBinaryMessageHandler(Session session, String string, Socket socket, OutputStream outputStream) {
        this._outputStream = outputStream;
        this._session = session;
        this._socket = socket;
        this._vmId = string;
    }

    public void onMessage(ByteBuffer byteBuffer, boolean bl) {
        try {
            if (this._session.isOpen() && this._socket.isConnected() && this._socket.isBound() && !this._socket.isClosed()) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("[webconsole] accessing & operating vm-console " + this._vmId + " and the socket is " + this._socket));
                }
                this._outputStream.write(byteBuffer.array());
                this._outputStream.flush();
            }
        }
        catch (IOException iOException) {
            _logger.error((Object)"[webconsole] Error writing message to the authd socket", (Throwable)iOException);
            throw new AuthdException(iOException.getMessage());
        }
    }
}

