/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data;

import com.vmware.vise.core.model.data;
import com.vmware.vise.core.model.optional;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import java.util.Arrays;

@data(base="Object")
public class PropertySpec
implements Cloneable {
    @optional
    public String type;
    @optional
    public String relation;
    public String[] propertyNames;
    @optional
    public ParameterSpec[] parameters;

    public String toString() {
        return "[type: " + this.type + ", relation: " + this.relation + ", propertyNames: " + Arrays.toString(this.propertyNames) + ", parameters: " + Arrays.toString(this.parameters) + "]";
    }

    public PropertySpec clone() throws CloneNotSupportedException {
        int n;
        PropertySpec propertySpec = (PropertySpec)super.clone();
        propertySpec.type = this.type;
        propertySpec.relation = this.relation;
        if (this.propertyNames != null) {
            propertySpec.propertyNames = new String[this.propertyNames.length];
            for (n = 0; n < this.propertyNames.length; ++n) {
                propertySpec.propertyNames[n] = this.propertyNames[n];
            }
        }
        if (this.parameters != null) {
            propertySpec.parameters = new ParameterSpec[this.parameters.length];
            for (n = 0; n < this.parameters.length; ++n) {
                propertySpec.parameters[n] = this.parameters[n].clone();
            }
        }
        return propertySpec;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PropertySpec)) {
            return false;
        }
        PropertySpec propertySpec = (PropertySpec)object;
        return ObjectUtil.objectsEqual((Object)this.type, (Object)propertySpec.type) && ObjectUtil.objectsEqual((Object)PropertySpec.normalizeRelation(this.relation), (Object)PropertySpec.normalizeRelation(propertySpec.relation)) && ArrayUtil.areEquivalent((Object[])this.propertyNames, (Object[])propertySpec.propertyNames) && ArrayUtil.areEquivalent((Object[])this.parameters, (Object[])propertySpec.parameters);
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + ObjectUtil.getHashCode((Object)this.type);
        n = 31 * n + ObjectUtil.getHashCode((Object)PropertySpec.normalizeRelation(this.relation));
        n = 31 * n + Arrays.hashCode(this.propertyNames);
        n = 31 * n + Arrays.hashCode(this.parameters);
        return n;
    }

    private static String normalizeRelation(String string) {
        if ("".equals(string)) {
            return null;
        }
        return string;
    }
}

