/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.topology.impl;

import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.impl.SimpleTimeBasedCacheImpl;
import com.vmware.license.client.cis.ls.topology.Folder;
import com.vmware.license.client.cis.ls.topology.LookupClient;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.ValidationUtil;
import java.util.concurrent.TimeUnit;

public class CacheLookupClientWrapperImpl
implements LookupClient {
    private static final int CACHE_CAPACITY = 100;
    private static final long CACHE_EXPIRATION_INTERVAL_IN_MS = TimeUnit.MINUTES.toMillis(20L);
    private static final String SERVICE_TYPE_IDENTIFIER_DELIM = "~";
    private final LookupClient _lookupClient;
    private final Cache<String, ServiceRegistration.Info[]> _serviceTypeIdentifierToServiceInfosCache;
    private final Object _serviceTypeIdentifierToServiceInfosCacheLock = new Object();

    public CacheLookupClientWrapperImpl(LookupClient lookupClient) {
        this._lookupClient = lookupClient;
        this._serviceTypeIdentifierToServiceInfosCache = new SimpleTimeBasedCacheImpl(CACHE_EXPIRATION_INTERVAL_IN_MS, 100);
    }

    private static String buildServiceTypeIdentifier(ServiceRegistration.ServiceType serviceType, Folder folder) {
        String string;
        ValidationUtil.paramsNotNull((Object[])new Object[]{serviceType});
        String string2 = string = serviceType.getProduct() + serviceType.getType();
        if (folder != null) {
            string2 = string2 + SERVICE_TYPE_IDENTIFIER_DELIM;
            string2 = string2 + folder.getNodeId();
            string2 = string2 + SERVICE_TYPE_IDENTIFIER_DELIM;
            string2 = string2 + folder.getSiteId();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceRegistration.Info[] searchServiceInfos(ServiceRegistration.ServiceType serviceType, Folder folder) {
        String string = CacheLookupClientWrapperImpl.buildServiceTypeIdentifier(serviceType, folder);
        ServiceRegistration.Info[] infoArray = (ServiceRegistration.Info[])this._serviceTypeIdentifierToServiceInfosCache.get((Object)string);
        if (infoArray == null) {
            Object object = this._serviceTypeIdentifierToServiceInfosCacheLock;
            synchronized (object) {
                infoArray = (ServiceRegistration.Info[])this._serviceTypeIdentifierToServiceInfosCache.get((Object)string);
                if (infoArray == null) {
                    infoArray = this._lookupClient.searchServiceInfos(serviceType, folder);
                    if (infoArray == null) {
                        infoArray = new ServiceRegistration.Info[]{};
                    }
                    this._serviceTypeIdentifierToServiceInfosCache.put((Object)string, (Object)infoArray);
                }
            }
        }
        return infoArray;
    }
}

