/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.topology.impl;

import com.vmware.license.client.cis.ls.topology.Folder;
import com.vmware.license.client.cis.ls.topology.LookupClient;
import com.vmware.license.client.cis.ls.topology.TopologyInfoProvider;
import com.vmware.license.client.cis.ls.topology.TopologyInfoRetrievalException;
import com.vmware.license.client.cis.ls.topology.impl.AfdLocalFolderInfoProviderImpl;
import com.vmware.license.client.cis.ls.topology.impl.DsConfigLocalFolderInfoProviderImpl;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookupTopologyInfoProviderImpl
implements TopologyInfoProvider {
    private static final String AFD_DISABLED = "afd.disabled";
    private static final ServiceRegistration.ServiceType LICENSE_SERVICE_TYPE = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.license");
    private static final ServiceRegistration.ServiceType VC_SERVICE_TYPE = new ServiceRegistration.ServiceType("com.vmware.cis", "vcenterserver");
    private final Log _logger = LogFactory.getLog(LookupTopologyInfoProviderImpl.class);
    private final LookupClient _lookupClient;
    private final ConfigurationService _configurationService;
    private Folder _localFolder;
    private final Object _localFolderLock = new Object();
    private String _storedVcId;
    private final Object _storedVcIdLock = new Object();

    public LookupTopologyInfoProviderImpl(LookupClient lookupClient, ConfigurationService configurationService) {
        this._lookupClient = lookupClient;
        this._configurationService = configurationService;
    }

    @Override
    public int getLicenseServicesCount() throws TopologyInfoRetrievalException {
        ServiceRegistration.Info[] infoArray = this.searchServiceInfos(LICENSE_SERVICE_TYPE);
        return infoArray == null ? 0 : infoArray.length;
    }

    @Override
    public String getLocalVcId() throws TopologyInfoRetrievalException {
        ServiceRegistration.Info info = this.getLocalVcServiceInfo();
        return info.getServiceId();
    }

    @Override
    public Map<String, String> getVcIdToNodeId(List<String> list) throws TopologyInfoRetrievalException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (list == null || list.isEmpty()) {
            return hashMap;
        }
        ServiceRegistration.Info[] infoArray = this.searchServiceInfos(VC_SERVICE_TYPE);
        HashSet<String> hashSet = new HashSet<String>(list);
        for (ServiceRegistration.Info info : infoArray) {
            String string = info.getServiceId();
            if (!hashSet.contains(string)) continue;
            String string2 = this.getNodeId(info);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    @Override
    public Map<String, String> getNodeIdToVcId(List<String> list) throws TopologyInfoRetrievalException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (list == null || list.isEmpty()) {
            return hashMap;
        }
        ServiceRegistration.Info[] infoArray = this.searchServiceInfos(VC_SERVICE_TYPE);
        HashSet<String> hashSet = new HashSet<String>(list);
        for (ServiceRegistration.Info info : infoArray) {
            String string = this.getNodeId(info);
            if (!hashSet.contains(string)) continue;
            String string2 = info.getServiceId();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistration.Info getLocalVcServiceInfo() throws TopologyInfoRetrievalException {
        Folder folder = this.getLocalFolder();
        Object[] objectArray = this.searchServiceInfos(VC_SERVICE_TYPE, folder);
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            throw new TopologyInfoRetrievalException("No VC services found.");
        }
        Object object = objectArray[0];
        if (folder.getNodeId() == null) {
            Object object2 = this._storedVcIdLock;
            synchronized (object2) {
                if (this._storedVcId != null) {
                    for (Object object3 : objectArray) {
                        if (!this._storedVcId.equals(object3.getServiceId())) continue;
                        object = object3;
                        break;
                    }
                }
                this._storedVcId = object.getServiceId();
            }
        }
        return object;
    }

    private ServiceRegistration.Info[] searchServiceInfos(ServiceRegistration.ServiceType serviceType) {
        return this.searchServiceInfos(serviceType, null);
    }

    private ServiceRegistration.Info[] searchServiceInfos(ServiceRegistration.ServiceType serviceType, Folder folder) {
        return this._lookupClient.searchServiceInfos(serviceType, folder);
    }

    private String getNodeId(ServiceRegistration.Info info) {
        return info.getNodeId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Folder getLocalFolder() throws TopologyInfoRetrievalException {
        if (this._localFolder == null) {
            Object object = this._localFolderLock;
            synchronized (object) {
                if (this._localFolder == null) {
                    String string = this.getLocalFolderId();
                    this._localFolder = new Folder(string, null);
                }
            }
        }
        return this._localFolder;
    }

    private String getLocalFolderId() throws TopologyInfoRetrievalException {
        boolean bl = Boolean.parseBoolean(this._configurationService.getProperty(AFD_DISABLED));
        try {
            if (bl) {
                return new DsConfigLocalFolderInfoProviderImpl().getLocalFolderId();
            }
            return new AfdLocalFolderInfoProviderImpl().getLocalFolderId();
        }
        catch (Throwable throwable) {
            if (this._logger.isInfoEnabled()) {
                this._logger.info((Object)("Both the DsConfigLocalFolderInfoProvider and AfdLocalFolderInfoProvider couldn't return localFolderId! Exception: " + throwable.getMessage()));
            }
            return null;
        }
    }
}

