/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetUpdateLicenseSpec;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.ds.results.AddSubscriptionLicensePreviewResult;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.AddSubscriptionLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseCreateSpec;
import com.vmware.license.client.cis.management.ds.specs.LicensePreviewSpec;
import com.vmware.license.client.cis.management.ds.specs.LicenseUpdateSpec;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationVpxManagementEditorWrapperImpl
implements VpxManagementEditor {
    private static final int SERIAL_KEY_MASK_START_INDEX = 6;
    private static final int SERIAL_KEY_MASK_END_INDEX = 22;
    private static final String SERIAL_KEY_MASK_PATTERN = "XXXXX-XXXXX-XXXXX";
    private final VpxManagementEditor _vpxManagementEditor;
    private final AuthorizationManager _authorizationManager;
    private final Log _logger = LogFactory.getLog(AuthorizationVpxManagementEditorWrapperImpl.class);

    public AuthorizationVpxManagementEditorWrapperImpl(VpxManagementEditor vpxManagementEditor, AuthorizationManager authorizationManager) {
        this._vpxManagementEditor = vpxManagementEditor;
        this._authorizationManager = authorizationManager;
    }

    @Override
    public License[] getLicenses(URI[] uRIArray, LicenseScope licenseScope) {
        this.validateLicensingPrivilegeGranted(licenseScope);
        License[] licenseArray = this._vpxManagementEditor.getLicenses(uRIArray, licenseScope);
        return licenseArray;
    }

    @Override
    public License[] getLicenses(LicenseScope licenseScope, LicenseSearchProperties licenseSearchProperties) {
        this.validateLicensingPrivilegeGranted(licenseScope);
        License[] licenseArray = this._vpxManagementEditor.getLicenses(licenseScope, licenseSearchProperties);
        return licenseArray;
    }

    @Override
    public License[] getLicensesForProduct(URI uRI, LicenseSearchProperties licenseSearchProperties) {
        UriUtil.validateProductUri(uRI);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        this.validateLicensingPrivilegeGranted(licenseScope);
        License[] licenseArray = this._vpxManagementEditor.getLicensesForProduct(uRI, licenseSearchProperties);
        return licenseArray;
    }

    @Override
    public ProductAggregation[] getProductAggregations(URI[] uRIArray, LicenseScope licenseScope) {
        this.validateLicensingPrivilegeGranted(licenseScope);
        ProductAggregation[] productAggregationArray = this._vpxManagementEditor.getProductAggregations(uRIArray, licenseScope);
        return productAggregationArray;
    }

    @Override
    public ProductAggregation[] getProductAggregationsForLicense(URI uRI) {
        UriUtil.validateLicenseUri(uRI);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        this.validateLicensingPrivilegeGranted(licenseScope);
        ProductAggregation[] productAggregationArray = this._vpxManagementEditor.getProductAggregationsForLicense(uRI);
        return productAggregationArray;
    }

    @Override
    public Asset[] getAssets(URI[] uRIArray, LicenseScope licenseScope) {
        Asset[] assetArray = this._vpxManagementEditor.getAssets(uRIArray, licenseScope);
        if (!this.isLicensingPrivilegeGranted(licenseScope)) {
            this.maskAssetsSerialKeys(assetArray);
        }
        return assetArray;
    }

    @Override
    public Asset[] getAssetsByMoRefs(ManagedObjectReference[] managedObjectReferenceArray, LicenseScope licenseScope) {
        Asset[] assetArray = this._vpxManagementEditor.getAssetsByMoRefs(managedObjectReferenceArray, licenseScope);
        if (!this.isLicensingPrivilegeGranted(licenseScope)) {
            this.maskAssetsSerialKeys(assetArray);
        }
        return assetArray;
    }

    @Override
    public Asset[] getAssets(LicenseScope licenseScope, AssetSearchProperties assetSearchProperties) {
        Asset[] assetArray = this._vpxManagementEditor.getAssets(licenseScope, assetSearchProperties);
        if (!this.isLicensingPrivilegeGranted(licenseScope)) {
            this.maskAssetsSerialKeys(assetArray);
        }
        return assetArray;
    }

    @Override
    public Asset[] getAssetsForProduct(URI uRI, AssetSearchProperties assetSearchProperties) {
        Asset[] assetArray = this._vpxManagementEditor.getAssetsForProduct(uRI, assetSearchProperties);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        if (!this.isLicensingPrivilegeGranted(licenseScope)) {
            this.maskAssetsSerialKeys(assetArray);
        }
        return assetArray;
    }

    @Override
    public Asset[] getAssetsForLicense(URI uRI, AssetSearchProperties assetSearchProperties) {
        Asset[] assetArray = this._vpxManagementEditor.getAssetsForLicense(uRI, assetSearchProperties);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        if (!this.isLicensingPrivilegeGranted(licenseScope)) {
            this.maskAssetsSerialKeys(assetArray);
        }
        return assetArray;
    }

    @Override
    public URI[] addLicenses(LicenseCreateSpec[] licenseCreateSpecArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseCreateSpecArray)) {
            throw new IllegalArgumentException("createSpecs should not be null.");
        }
        this.validateLicensingPrivilegeGranted(licenseCreateSpecArray[0].scope);
        return this._vpxManagementEditor.addLicenses(licenseCreateSpecArray);
    }

    @Override
    public URI addSubscriptionLicense(AddSubscriptionLicenseSpec addSubscriptionLicenseSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{addSubscriptionLicenseSpec});
        this.validateLicensingPrivilegeGranted(addSubscriptionLicenseSpec.scope);
        return this._vpxManagementEditor.addSubscriptionLicense(addSubscriptionLicenseSpec);
    }

    @Override
    public void updateLicenses(LicenseUpdateSpec[] licenseUpdateSpecArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseUpdateSpecArray)) {
            throw new IllegalArgumentException("updateSpecs should not be null.");
        }
        URI uRI = licenseUpdateSpecArray[0].uri;
        UriUtil.validateLicenseUri(uRI);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        this.validateLicensingPrivilegeGranted(licenseScope);
        this._vpxManagementEditor.updateLicenses(licenseUpdateSpecArray);
    }

    @Override
    public void removeLicenses(URI[] uRIArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
            throw new IllegalArgumentException("licenseUris should not be null.");
        }
        URI uRI = uRIArray[0];
        UriUtil.validateLicenseUri(uRI);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        this.validateLicensingPrivilegeGranted(licenseScope);
        this._vpxManagementEditor.removeLicenses(uRIArray);
    }

    @Override
    public License[] previewLicenses(LicensePreviewSpec[] licensePreviewSpecArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])licensePreviewSpecArray)) {
            throw new IllegalArgumentException("previewSpecs should not be null.");
        }
        this.validateLicensingPrivilegeGranted(licensePreviewSpecArray[0].scope);
        License[] licenseArray = this._vpxManagementEditor.previewLicenses(licensePreviewSpecArray);
        return licenseArray;
    }

    @Override
    public AddSubscriptionLicensePreviewResult previewSubscriptionLicense(AddSubscriptionLicensePreviewSpec addSubscriptionLicensePreviewSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{addSubscriptionLicensePreviewSpec});
        this.validateLicensingPrivilegeGranted(addSubscriptionLicensePreviewSpec.scope);
        AddSubscriptionLicensePreviewResult addSubscriptionLicensePreviewResult = this._vpxManagementEditor.previewSubscriptionLicense(addSubscriptionLicensePreviewSpec);
        return addSubscriptionLicensePreviewResult;
    }

    @Override
    public void updateAssetsLicense(AssetUpdateLicenseSpec[] assetUpdateLicenseSpecArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetUpdateLicenseSpecArray)) {
            throw new IllegalArgumentException("updateSpecs should not be null.");
        }
        URI uRI = assetUpdateLicenseSpecArray[0].getAssetRef();
        UriUtil.validateAssetUri(uRI);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        this.validateLicensingPrivilegeGranted(licenseScope);
        this._vpxManagementEditor.updateAssetsLicense(assetUpdateLicenseSpecArray);
    }

    @Override
    public void unregisterAssets(URI[] uRIArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
            throw new IllegalArgumentException("assetUris should not be null.");
        }
        URI uRI = uRIArray[0];
        UriUtil.validateAssetUri(uRI);
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRI);
        this.validateLicensingPrivilegeGranted(licenseScope);
        this._vpxManagementEditor.unregisterAssets(uRIArray);
    }

    private void validateLicensingPrivilegeGranted(LicenseUiScope licenseUiScope) {
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseUiScope);
        this.validateLicensingPrivilegeGranted(licenseScope);
    }

    private void validateLicensingPrivilegeGranted(LicenseScope licenseScope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseScope});
        boolean bl = this.isLicensingPrivilegeGranted(licenseScope);
        if (!bl) {
            throw new ManagementException(ManagementUtil.getLocalizedString("error.lsPrivilegeNotGranted"), ManagementException.ReasonType.NOT_AUTHORIZED);
        }
    }

    private boolean isLicensingPrivilegeGranted(LicenseScope licenseScope) {
        try {
            return this._authorizationManager.isLicensingAdminPrivilegeGranted(licenseScope);
        }
        catch (Exception exception) {
            this._logger.warn((Object)"Unable to retrieve licensing privileges information. Assuming access is not granted.", (Throwable)exception);
            return false;
        }
    }

    private void maskAssetsSerialKeys(Asset[] assetArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetArray)) {
            return;
        }
        for (Asset asset : assetArray) {
            if (asset == null) continue;
            this.maskLicenseSerialKeys(asset.getLicense());
            this.maskLicenseSerialKeys(asset.getEvaluationLicense());
        }
    }

    private void maskLicenseSerialKeys(License license) {
        if (license == null || ArrayUtil.isNullOrEmpty((Object[])license.getSerialKeys())) {
            return;
        }
        String[] stringArray = license.getSerialKeys();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.maskSerialKey(stringArray[i]);
        }
        license.setSerialKeys(stringArray2);
    }

    private String maskSerialKey(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        if (string.length() > 22) {
            String string3 = string.substring(0, 6);
            String string4 = string.substring(23);
            string2 = string3 + SERIAL_KEY_MASK_PATTERN + string4;
        } else {
            string2 = string;
        }
        return string2;
    }
}

