/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.Feature;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.vise.util.ArrayUtil;
import java.util.ArrayList;

public class FeatureUtil {
    private static final char FEATURE_ID_DELIM = ':';
    private static final char FEATURE_LOCALIZATION_TOKEN_DELIM = '.';
    private static final String VC_FEATURE_LOCALIZATION_KEY_FORMAT = "com.vmware.vim.license.Feature.%s.summary";
    private static final String LS_FEATURE_LOCALIZATION_KEY_FORMAT = "%s";
    private static final String[] FEATURE_LOCALIZATION_KEY_FORMATS = new String[]{"%s", "com.vmware.vim.license.Feature.%s.summary"};

    public static Feature createFeature(String string) {
        Feature feature = new Feature();
        feature.setId(string);
        return feature;
    }

    public static Feature[] createFeatures(com.vmware.vim.binding.cis.license.Feature[] featureArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])featureArray)) {
            return new Feature[0];
        }
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        for (com.vmware.vim.binding.cis.license.Feature feature : featureArray) {
            Feature feature2 = FeatureUtil.createFeature(feature.getId());
            arrayList.add(feature2);
        }
        return arrayList.toArray(new Feature[arrayList.size()]);
    }

    public static String getFeatureFormattedId(String string) {
        if (string == null) {
            return null;
        }
        String string2 = FeatureUtil.getFeatureIdLocalizationToken(string);
        for (String string3 : FEATURE_LOCALIZATION_KEY_FORMATS) {
            String string4 = String.format(string3, string2);
            String string5 = ManagementUtil.getCatalogLocalizedString(string4);
            if (string5 == null) continue;
            return string5;
        }
        return string;
    }

    private static String getFeatureIdLocalizationToken(String string) {
        return string.replace(':', '.');
    }
}

