/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.adapter;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncCommitSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncPreviewSpec;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.cis.util.MutationUtil;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyVMwareSyncMutationProvider
implements MutationProvider {
    private final Log _logger = LogFactory.getLog(MyVMwareSyncMutationProvider.class);
    private final MyVMwareSyncEditor _myVMwareSyncEditor;

    public MyVMwareSyncMutationProvider(MyVMwareSyncEditor myVMwareSyncEditor) {
        this._myVMwareSyncEditor = myVMwareSyncEditor;
    }

    public OperationResult apply(URI uRI, MyVMwareSyncCommitSpec myVMwareSyncCommitSpec) {
        try {
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(myVMwareSyncCommitSpec.scope);
            this._myVMwareSyncEditor.commitSyncFromMyVMware(myVMwareSyncCommitSpec, licenseScope);
            return MutationUtil.createOperationResult(uRI);
        }
        catch (Exception exception) {
            this.logError(exception);
            return MutationUtil.createOperationResult(exception);
        }
    }

    public ValidationResult validate(MyVMwareSyncPreviewSpec myVMwareSyncPreviewSpec) {
        try {
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(myVMwareSyncPreviewSpec.scope);
            MyVMwareSyncPreviewResult myVMwareSyncPreviewResult = this._myVMwareSyncEditor.previewSyncFromMyVMware(myVMwareSyncPreviewSpec, licenseScope);
            return MutationUtil.createValidationResult((Object)myVMwareSyncPreviewResult);
        }
        catch (Exception exception) {
            this.logError(exception);
            return MutationUtil.createValidationResult(exception);
        }
    }

    private void logError(Throwable throwable) {
        if (this._logger.isErrorEnabled()) {
            this._logger.error((Object)"Unable to execute license mutation operation: ", throwable);
        }
    }
}

