/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareOnlineSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareOnlineSyncException;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncCheckReportGenerationStatusResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncCredentialsResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncFoldersResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncInitiateReportGenerationResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncCheckReportGenerationStatusSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncCredentialsSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncFoldersSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncInitiateReportGenerationSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncPreviewSpec;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationMyVMwareOnlineSyncEditorWrapperImpl
implements MyVMwareOnlineSyncEditor {
    private final MyVMwareOnlineSyncEditor _myVMwareOnlineSyncEditor;
    private final AuthorizationManager _authorizationManager;
    private final Log _logger = LogFactory.getLog(AuthorizationMyVMwareOnlineSyncEditorWrapperImpl.class);

    public AuthorizationMyVMwareOnlineSyncEditorWrapperImpl(MyVMwareOnlineSyncEditor myVMwareOnlineSyncEditor, AuthorizationManager authorizationManager) {
        this._myVMwareOnlineSyncEditor = myVMwareOnlineSyncEditor;
        this._authorizationManager = authorizationManager;
    }

    @Override
    public MyVMwareOnlineSyncCredentialsResult getUserEntitlementAccounts(MyVMwareOnlineSyncCredentialsSpec myVMwareOnlineSyncCredentialsSpec) throws MyVMwareOnlineSyncException {
        MyVMwareOnlineSyncCredentialsResult myVMwareOnlineSyncCredentialsResult = this._myVMwareOnlineSyncEditor.getUserEntitlementAccounts(myVMwareOnlineSyncCredentialsSpec);
        return myVMwareOnlineSyncCredentialsResult;
    }

    @Override
    public MyVMwareOnlineSyncFoldersResult getEntitlementAccountFolders(MyVMwareOnlineSyncFoldersSpec myVMwareOnlineSyncFoldersSpec) throws MyVMwareOnlineSyncException {
        MyVMwareOnlineSyncFoldersResult myVMwareOnlineSyncFoldersResult = this._myVMwareOnlineSyncEditor.getEntitlementAccountFolders(myVMwareOnlineSyncFoldersSpec);
        return myVMwareOnlineSyncFoldersResult;
    }

    @Override
    public MyVMwareOnlineSyncInitiateReportGenerationResult initiateReportGeneration(MyVMwareOnlineSyncInitiateReportGenerationSpec myVMwareOnlineSyncInitiateReportGenerationSpec) throws MyVMwareOnlineSyncException {
        MyVMwareOnlineSyncInitiateReportGenerationResult myVMwareOnlineSyncInitiateReportGenerationResult = this._myVMwareOnlineSyncEditor.initiateReportGeneration(myVMwareOnlineSyncInitiateReportGenerationSpec);
        return myVMwareOnlineSyncInitiateReportGenerationResult;
    }

    @Override
    public MyVMwareOnlineSyncCheckReportGenerationStatusResult checkReportGenerationStatus(MyVMwareOnlineSyncCheckReportGenerationStatusSpec myVMwareOnlineSyncCheckReportGenerationStatusSpec) throws MyVMwareOnlineSyncException {
        MyVMwareOnlineSyncCheckReportGenerationStatusResult myVMwareOnlineSyncCheckReportGenerationStatusResult = this._myVMwareOnlineSyncEditor.checkReportGenerationStatus(myVMwareOnlineSyncCheckReportGenerationStatusSpec);
        return myVMwareOnlineSyncCheckReportGenerationStatusResult;
    }

    @Override
    public MyVMwareOnlineSyncPreviewResult previewOnlineSync(MyVMwareOnlineSyncPreviewSpec myVMwareOnlineSyncPreviewSpec) throws MyVMwareOnlineSyncException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{myVMwareOnlineSyncPreviewSpec});
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(myVMwareOnlineSyncPreviewSpec.scope);
        this.validateLicensingPrivilegeGranted(licenseScope);
        MyVMwareOnlineSyncPreviewResult myVMwareOnlineSyncPreviewResult = this._myVMwareOnlineSyncEditor.previewOnlineSync(myVMwareOnlineSyncPreviewSpec);
        return myVMwareOnlineSyncPreviewResult;
    }

    private void validateLicensingPrivilegeGranted(LicenseScope licenseScope) throws MyVMwareOnlineSyncException {
        boolean bl;
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseScope});
        try {
            bl = this._authorizationManager.isLicensingAdminPrivilegeGranted(licenseScope);
        }
        catch (Exception exception) {
            this._logger.warn((Object)"Unable to retrieve licensing privileges information. Assuming access is not granted.", (Throwable)exception);
            bl = false;
        }
        if (!bl) {
            throw new MyVMwareOnlineSyncException(ManagementUtil.getLocalizedString("error.lsPrivilegeNotGranted"));
        }
    }
}

