/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncException;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncCommitSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncPreviewSpec;
import com.vmware.vise.util.ValidationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationMyVMwareSyncEditorWrapperImpl
implements MyVMwareSyncEditor {
    private final MyVMwareSyncEditor _myVMwareSyncEditor;
    private final AuthorizationManager _authorizationManager;
    private final Log _logger = LogFactory.getLog(AuthorizationMyVMwareSyncEditorWrapperImpl.class);

    public AuthorizationMyVMwareSyncEditorWrapperImpl(MyVMwareSyncEditor myVMwareSyncEditor, AuthorizationManager authorizationManager) {
        this._myVMwareSyncEditor = myVMwareSyncEditor;
        this._authorizationManager = authorizationManager;
    }

    @Override
    public MyVMwareSyncPreviewResult previewSyncFromMyVMware(MyVMwareSyncPreviewSpec myVMwareSyncPreviewSpec, LicenseScope licenseScope) {
        this.validateLicensingPrivilegeGranted(licenseScope);
        MyVMwareSyncPreviewResult myVMwareSyncPreviewResult = this._myVMwareSyncEditor.previewSyncFromMyVMware(myVMwareSyncPreviewSpec, licenseScope);
        return myVMwareSyncPreviewResult;
    }

    @Override
    public void commitSyncFromMyVMware(MyVMwareSyncCommitSpec myVMwareSyncCommitSpec, LicenseScope licenseScope) {
        this.validateLicensingPrivilegeGranted(licenseScope);
        this._myVMwareSyncEditor.commitSyncFromMyVMware(myVMwareSyncCommitSpec, licenseScope);
    }

    @Override
    public MyVMwareSyncInfo getSyncInfo(LicenseScope licenseScope) throws MyVMwareSyncException {
        this.validateLicensingPrivilegeGranted(licenseScope);
        return this._myVMwareSyncEditor.getSyncInfo(licenseScope);
    }

    private void validateLicensingPrivilegeGranted(LicenseScope licenseScope) {
        boolean bl;
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseScope});
        try {
            bl = this._authorizationManager.isLicensingAdminPrivilegeGranted(licenseScope);
        }
        catch (Exception exception) {
            this._logger.warn((Object)"Unable to retrieve licensing privileges information. Assuming access is not granted.", (Throwable)exception);
            bl = false;
        }
        if (!bl) {
            throw new MyVMwareSyncException(ManagementUtil.getLocalizedString("error.lsPrivilegeNotGranted"));
        }
    }
}

