/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncException;
import com.vmware.license.client.cis.myvmwaresync.ds.EntitlementAccountToFoldersIds;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareLicenseInfo;
import com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSerialKeyInfo;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareLicenseCreateSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareLicenseUpdateSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncCommitSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncPreviewSpec;
import com.vmware.license.client.cis.myvmwaresync.util.MyVMwareSyncUtil;
import com.vmware.license.myvmware.client.sync.MyVMwareUtil;
import com.vmware.vim.binding.cis.license.MyVMwareLicenseDetails;
import com.vmware.vim.binding.cis.license.fault.MyVMwareSyncFault;
import com.vmware.vim.binding.cis.license.management.InactiveLicensesReport;
import com.vmware.vim.binding.cis.license.management.LicenseAddSpec;
import com.vmware.vim.binding.cis.license.management.LicenseUpdateSpec;
import com.vmware.vim.binding.cis.license.management.MyVMwareEntitlementAccountFolders;
import com.vmware.vim.binding.cis.license.management.MyVMwareLicenseReport;
import com.vmware.vim.binding.cis.license.management.MyVMwareSyncContext;
import com.vmware.vim.binding.cis.license.management.MyVMwareSyncInfo;
import com.vmware.vim.binding.cis.license.management.MyVMwareSyncSpec;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareEntitlementAccountFoldersImpl;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareSerialKeyLicenseAddSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareSerialKeyLicenseUpdateSpecImpl;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareSyncContextImpl;
import com.vmware.vim.binding.impl.cis.license.management.MyVMwareSyncSpecImpl;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyVMwareSyncEditorImpl
implements MyVMwareSyncEditor {
    private final LicenseClientProvider _licenseClientProvider;
    private final Log _logger = LogFactory.getLog(MyVMwareSyncEditorImpl.class);

    private static LicenseUpdateSpec[] buildServiceLicenseUpdateSpecs(MyVMwareLicenseUpdateSpec[] myVMwareLicenseUpdateSpecArray) {
        LicenseUpdateSpec[] licenseUpdateSpecArray = new LicenseUpdateSpec[myVMwareLicenseUpdateSpecArray.length];
        for (int i = 0; i < licenseUpdateSpecArray.length; ++i) {
            MyVMwareLicenseUpdateSpec myVMwareLicenseUpdateSpec = myVMwareLicenseUpdateSpecArray[i];
            URI uRI = UriUtil.extractObjectIdAsUri(myVMwareLicenseUpdateSpec.uri);
            MyVMwareLicenseDetails[] myVMwareLicenseDetailsArray = MyVMwareSyncEditorImpl.buildServiceMyVMwareLicenseDetails(myVMwareLicenseUpdateSpec.myVMwareLicenseInfo);
            MyVMwareSerialKeyLicenseUpdateSpecImpl myVMwareSerialKeyLicenseUpdateSpecImpl = new MyVMwareSerialKeyLicenseUpdateSpecImpl();
            myVMwareSerialKeyLicenseUpdateSpecImpl.setLicenseId(uRI);
            myVMwareSerialKeyLicenseUpdateSpecImpl.setSerialKeys(myVMwareLicenseUpdateSpec.serialKeys);
            myVMwareSerialKeyLicenseUpdateSpecImpl.setLicenseDetails(myVMwareLicenseDetailsArray);
            licenseUpdateSpecArray[i] = myVMwareSerialKeyLicenseUpdateSpecImpl;
        }
        return licenseUpdateSpecArray;
    }

    private static LicenseAddSpec[] buildServiceLicenseAddSpecs(MyVMwareLicenseCreateSpec[] myVMwareLicenseCreateSpecArray) {
        LicenseAddSpec[] licenseAddSpecArray = new LicenseAddSpec[myVMwareLicenseCreateSpecArray.length];
        for (int i = 0; i < licenseAddSpecArray.length; ++i) {
            MyVMwareLicenseCreateSpec myVMwareLicenseCreateSpec = myVMwareLicenseCreateSpecArray[i];
            MyVMwareLicenseDetails[] myVMwareLicenseDetailsArray = MyVMwareSyncEditorImpl.buildServiceMyVMwareLicenseDetails(myVMwareLicenseCreateSpec.myVMwareLicenseInfo);
            MyVMwareSerialKeyLicenseAddSpecImpl myVMwareSerialKeyLicenseAddSpecImpl = new MyVMwareSerialKeyLicenseAddSpecImpl();
            myVMwareSerialKeyLicenseAddSpecImpl.setName(myVMwareLicenseCreateSpec.name);
            myVMwareSerialKeyLicenseAddSpecImpl.setSerialKeys(myVMwareLicenseCreateSpec.serialKeys);
            myVMwareSerialKeyLicenseAddSpecImpl.setLicenseDetails(myVMwareLicenseDetailsArray);
            licenseAddSpecArray[i] = myVMwareSerialKeyLicenseAddSpecImpl;
        }
        return licenseAddSpecArray;
    }

    private static MyVMwareLicenseDetails[] buildServiceMyVMwareLicenseDetails(MyVMwareLicenseInfo myVMwareLicenseInfo) {
        if (myVMwareLicenseInfo == null || myVMwareLicenseInfo.getSerialKeysInfo() == null) {
            return new MyVMwareLicenseDetails[0];
        }
        MyVMwareSerialKeyInfo[] myVMwareSerialKeyInfoArray = myVMwareLicenseInfo.getSerialKeysInfo();
        MyVMwareLicenseDetails[] myVMwareLicenseDetailsArray = new MyVMwareLicenseDetails[myVMwareSerialKeyInfoArray.length];
        for (int i = 0; i < myVMwareSerialKeyInfoArray.length; ++i) {
            myVMwareLicenseDetailsArray[i] = MyVMwareSyncUtil.buildServiceMyVMwareLicenseDetails(myVMwareSerialKeyInfoArray[i]);
        }
        return myVMwareLicenseDetailsArray;
    }

    private static void updateDefaultNewLicensesNames(License[] licenseArray, int n) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseArray)) {
            return;
        }
        String[] stringArray = LicenseUtil.getNewLicensesNames(licenseArray.length, n);
        for (int i = 0; i < licenseArray.length; ++i) {
            licenseArray[i].setName(stringArray[i]);
        }
    }

    private static com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo buildUiMyVMwareSyncInfo(MyVMwareSyncInfo myVMwareSyncInfo) {
        if (myVMwareSyncInfo == null) {
            return null;
        }
        com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo myVMwareSyncInfo2 = new com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo();
        myVMwareSyncInfo2.setSyncTime(myVMwareSyncInfo.getInventorySyncTimestamp());
        myVMwareSyncInfo2.setUpdatedKeysCount(myVMwareSyncInfo.getLicensesUpdatedTotal());
        myVMwareSyncInfo2.setAddedKeysCount(myVMwareSyncInfo.getLicensesAddedTotal());
        myVMwareSyncInfo2.setRemovedKeysCount(myVMwareSyncInfo.getLicensesRemovedTotal());
        MyVMwareSyncContext myVMwareSyncContext = myVMwareSyncInfo.getMyVMwareSyncContext();
        if (myVMwareSyncContext != null) {
            com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncContext myVMwareSyncContext2 = MyVMwareSyncEditorImpl.buildUiMyVMwareSyncContext(myVMwareSyncContext);
            myVMwareSyncInfo2.setMyVMwareSyncContext(myVMwareSyncContext2);
        }
        return myVMwareSyncInfo2;
    }

    private static com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncContext buildUiMyVMwareSyncContext(MyVMwareSyncContext myVMwareSyncContext) {
        Calendar calendar;
        com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncContext myVMwareSyncContext2 = new com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncContext();
        myVMwareSyncContext2.setMyVMwareUsername(myVMwareSyncContext.getUsername());
        EntitlementAccountToFoldersIds[] entitlementAccountToFoldersIdsArray = MyVMwareSyncEditorImpl.buildUiEntitlementAccountToFolderIds(myVMwareSyncContext.getEntitlementAccountFolders());
        myVMwareSyncContext2.setEntitlementAccountsToFoldersIds(entitlementAccountToFoldersIdsArray);
        Calendar calendar2 = myVMwareSyncContext.getSyncFromDate();
        if (calendar2 != null) {
            myVMwareSyncContext2.setFromDate(calendar2.getTime());
        }
        if ((calendar = myVMwareSyncContext.getSyncToDate()) != null) {
            myVMwareSyncContext2.setToDate(calendar.getTime());
        }
        return myVMwareSyncContext2;
    }

    private static EntitlementAccountToFoldersIds[] buildUiEntitlementAccountToFolderIds(MyVMwareEntitlementAccountFolders[] myVMwareEntitlementAccountFoldersArray) {
        if (myVMwareEntitlementAccountFoldersArray == null) {
            return null;
        }
        EntitlementAccountToFoldersIds[] entitlementAccountToFoldersIdsArray = new EntitlementAccountToFoldersIds[myVMwareEntitlementAccountFoldersArray.length];
        for (int i = 0; i < myVMwareEntitlementAccountFoldersArray.length; ++i) {
            MyVMwareEntitlementAccountFolders myVMwareEntitlementAccountFolders = myVMwareEntitlementAccountFoldersArray[i];
            EntitlementAccountToFoldersIds entitlementAccountToFoldersIds = new EntitlementAccountToFoldersIds();
            entitlementAccountToFoldersIds.setEntitlementAccountId(myVMwareEntitlementAccountFolders.getEaNumber());
            entitlementAccountToFoldersIds.setEntitlementAccountName(myVMwareEntitlementAccountFolders.getEaName());
            entitlementAccountToFoldersIds.setFolderIds(myVMwareEntitlementAccountFolders.getFolderIds());
            entitlementAccountToFoldersIdsArray[i] = entitlementAccountToFoldersIds;
        }
        return entitlementAccountToFoldersIdsArray;
    }

    private static MyVMwareSyncContext buildServiceSyncContext(com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncContext myVMwareSyncContext) {
        if (myVMwareSyncContext == null) {
            return null;
        }
        MyVMwareSyncContextImpl myVMwareSyncContextImpl = new MyVMwareSyncContextImpl();
        myVMwareSyncContextImpl.setUsername(myVMwareSyncContext.getMyVMwareUsername());
        MyVMwareEntitlementAccountFolders[] myVMwareEntitlementAccountFoldersArray = MyVMwareSyncEditorImpl.buildServiceEntitlementAccountsFolders(myVMwareSyncContext.getEntitlementAccountsToFoldersIds());
        myVMwareSyncContextImpl.setEntitlementAccountFolders(myVMwareEntitlementAccountFoldersArray);
        Calendar calendar = null;
        if (myVMwareSyncContext.getFromDate() != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(myVMwareSyncContext.getFromDate());
        }
        myVMwareSyncContextImpl.setSyncFromDate(calendar);
        Calendar calendar2 = null;
        if (myVMwareSyncContext.getToDate() != null) {
            calendar2 = Calendar.getInstance();
            calendar2.setTime(myVMwareSyncContext.getToDate());
        }
        myVMwareSyncContextImpl.setSyncToDate(calendar2);
        return myVMwareSyncContextImpl;
    }

    private static MyVMwareEntitlementAccountFolders[] buildServiceEntitlementAccountsFolders(EntitlementAccountToFoldersIds[] entitlementAccountToFoldersIdsArray) {
        if (entitlementAccountToFoldersIdsArray == null) {
            return null;
        }
        MyVMwareEntitlementAccountFolders[] myVMwareEntitlementAccountFoldersArray = new MyVMwareEntitlementAccountFolders[entitlementAccountToFoldersIdsArray.length];
        for (int i = 0; i < entitlementAccountToFoldersIdsArray.length; ++i) {
            MyVMwareEntitlementAccountFoldersImpl myVMwareEntitlementAccountFoldersImpl = new MyVMwareEntitlementAccountFoldersImpl();
            EntitlementAccountToFoldersIds entitlementAccountToFoldersIds = entitlementAccountToFoldersIdsArray[i];
            myVMwareEntitlementAccountFoldersImpl.setEaNumber(entitlementAccountToFoldersIds.getEntitlementAccountId());
            myVMwareEntitlementAccountFoldersImpl.setEaName(entitlementAccountToFoldersIds.getEntitlementAccountName());
            myVMwareEntitlementAccountFoldersImpl.setFolderIds(entitlementAccountToFoldersIds.getFolderIds());
            myVMwareEntitlementAccountFoldersArray[i] = myVMwareEntitlementAccountFoldersImpl;
        }
        return myVMwareEntitlementAccountFoldersArray;
    }

    private static MyVMwareSyncSpec buildServiceMyVMwareSyncSpec(MyVMwareSyncCommitSpec myVMwareSyncCommitSpec) {
        MyVMwareSyncSpecImpl myVMwareSyncSpecImpl = new MyVMwareSyncSpecImpl();
        LicenseUpdateSpec[] licenseUpdateSpecArray = MyVMwareSyncEditorImpl.buildServiceLicenseUpdateSpecs(myVMwareSyncCommitSpec.myVMwareLicenseUpdateSpecs);
        myVMwareSyncSpecImpl.setLicensesToUpdate(licenseUpdateSpecArray);
        LicenseAddSpec[] licenseAddSpecArray = MyVMwareSyncEditorImpl.buildServiceLicenseAddSpecs(myVMwareSyncCommitSpec.myVMwareLicenseCreateSpecs);
        myVMwareSyncSpecImpl.setLicensesToAdd(licenseAddSpecArray);
        URI[] uRIArray = UriUtil.extractObjectIdsAsUris(myVMwareSyncCommitSpec.licenseUrisForRemoval);
        myVMwareSyncSpecImpl.setLicensesToRemove(uRIArray);
        MyVMwareSyncContext myVMwareSyncContext = MyVMwareSyncEditorImpl.buildServiceSyncContext(myVMwareSyncCommitSpec.myVMwareSyncContext);
        myVMwareSyncSpecImpl.setMyVMwareSyncContext(myVMwareSyncContext);
        return myVMwareSyncSpecImpl;
    }

    public MyVMwareSyncEditorImpl(LicenseClientProvider licenseClientProvider) {
        this._licenseClientProvider = licenseClientProvider;
    }

    @Override
    public MyVMwareSyncPreviewResult previewSyncFromMyVMware(MyVMwareSyncPreviewSpec myVMwareSyncPreviewSpec, LicenseScope licenseScope) {
        MyVMwareLicenseReport myVMwareLicenseReport;
        ValidationUtil.paramsNotNull((Object[])new Object[]{myVMwareSyncPreviewSpec, licenseScope});
        ValidationUtil.paramsNotNull((Object[])new Object[]{myVMwareSyncPreviewSpec.myVMwareFileContent});
        try {
            myVMwareLicenseReport = MyVMwareUtil.buildMyVMwareLicenseReport((byte[])myVMwareSyncPreviewSpec.myVMwareFileContent);
        }
        catch (IOException iOException) {
            throw new MyVMwareSyncException(iOException);
        }
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        try {
            com.vmware.vim.binding.cis.license.management.MyVMwareSyncPreviewResult myVMwareSyncPreviewResult = systemManagementService.previewMyVMwareSync(myVMwareLicenseReport);
            return this.buildUiSyncPreviewResult(myVMwareSyncPreviewResult, licenseScope);
        }
        catch (MethodFault methodFault) {
            throw new MyVMwareSyncException(methodFault);
        }
    }

    @Override
    public void commitSyncFromMyVMware(MyVMwareSyncCommitSpec myVMwareSyncCommitSpec, LicenseScope licenseScope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{myVMwareSyncCommitSpec, licenseScope});
        SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
        MyVMwareSyncSpec myVMwareSyncSpec = MyVMwareSyncEditorImpl.buildServiceMyVMwareSyncSpec(myVMwareSyncCommitSpec);
        this._logger.info((Object)"Attempting to perform sync with My VMware...");
        try {
            systemManagementService.performMyVMwareSync(myVMwareSyncSpec);
        }
        catch (MyVMwareSyncFault myVMwareSyncFault) {
            this._logger.warn((Object)myVMwareSyncFault.getLocalizedMessage(), (Throwable)myVMwareSyncFault);
            throw new MyVMwareSyncException(myVMwareSyncFault);
        }
    }

    @Override
    public com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo getSyncInfo(LicenseScope licenseScope) throws MyVMwareSyncException {
        try {
            SystemManagementService systemManagementService = this.getSystemManagementService(licenseScope);
            MyVMwareSyncInfo myVMwareSyncInfo = systemManagementService.queryLastMyVMwareSyncInfo();
            com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo myVMwareSyncInfo2 = MyVMwareSyncEditorImpl.buildUiMyVMwareSyncInfo(myVMwareSyncInfo);
            return myVMwareSyncInfo2;
        }
        catch (Exception exception) {
            throw new MyVMwareSyncException(exception);
        }
    }

    private SystemManagementService getSystemManagementService(LicenseScope licenseScope) {
        LicenseClient licenseClient = this.getLicenseClient(licenseScope);
        return licenseClient.getSystemManagementService();
    }

    private LicenseClient getLicenseClient(LicenseScope licenseScope) {
        try {
            return this._licenseClientProvider.getLicenseClient(licenseScope);
        }
        catch (Exception exception) {
            throw new MyVMwareSyncException(exception);
        }
    }

    private MyVMwareSyncPreviewResult buildUiSyncPreviewResult(com.vmware.vim.binding.cis.license.management.MyVMwareSyncPreviewResult myVMwareSyncPreviewResult, LicenseScope licenseScope) {
        MyVMwareSyncPreviewResult myVMwareSyncPreviewResult2 = new MyVMwareSyncPreviewResult();
        myVMwareSyncPreviewResult2.licensesForMyVMwareInfoUpdate = LicenseUtil.createLicenses(myVMwareSyncPreviewResult.getMatchedLicenses(), licenseScope);
        License[] licenseArray = LicenseUtil.createLicenses(myVMwareSyncPreviewResult.getNewLicenses(), licenseScope);
        MyVMwareSyncEditorImpl.updateDefaultNewLicensesNames(licenseArray, myVMwareSyncPreviewResult.getInventoryLicensesTotal());
        myVMwareSyncPreviewResult2.licensesForAdd = licenseArray;
        myVMwareSyncPreviewResult2.isMyVMwareFileInCorrectFormat = ArrayUtil.isNullOrEmpty((Object[])myVMwareSyncPreviewResult.getMyVMwareReportErrors());
        myVMwareSyncPreviewResult2.inactiveLicensesReport = this.buildUiInactiveLicensesReport(myVMwareSyncPreviewResult.getInactiveLicensesReport());
        myVMwareSyncPreviewResult2.upgradedLicensesReport = this.buildUiInactiveLicensesReport(myVMwareSyncPreviewResult.getUpgradedLicensesReport());
        License[] licenseArray2 = LicenseUtil.createLicenses(myVMwareSyncPreviewResult.getInactiveUnassignedLicenses(), licenseScope);
        this.setLicensesUsageTo0(licenseArray2);
        myVMwareSyncPreviewResult2.licensesForRemoval = licenseArray2;
        return myVMwareSyncPreviewResult2;
    }

    private com.vmware.license.client.cis.management.ds.InactiveLicensesReport buildUiInactiveLicensesReport(InactiveLicensesReport inactiveLicensesReport) {
        if (inactiveLicensesReport == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = MyVMwareUtil.getInactiveLicensesReportContent((InactiveLicensesReport)inactiveLicensesReport);
        }
        catch (IOException iOException) {
            this._logger.warn((Object)"Unable to get inactive licenses report content: ", (Throwable)iOException);
        }
        if (byArray == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.InactiveLicensesReport inactiveLicensesReport2 = new com.vmware.license.client.cis.management.ds.InactiveLicensesReport();
        inactiveLicensesReport2.setContent(byArray);
        inactiveLicensesReport2.setLicensesCount(inactiveLicensesReport.getInactiveLicensesTotal());
        return inactiveLicensesReport2;
    }

    private void setLicensesUsageTo0(License[] licenseArray) {
        for (License license : licenseArray) {
            ProductRestriction[] productRestrictionArray;
            for (ProductRestriction productRestriction : productRestrictionArray = license.getProductRestrictions()) {
                CostUnit[] costUnitArray;
                for (CostUnit costUnit : costUnitArray = productRestriction.getProduct().getCostUnits()) {
                    costUnit.setUsage(0.0);
                }
            }
        }
    }
}

