/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.license.client.cis.reports.ReportEditor;
import com.vmware.license.client.cis.reports.ReportException;
import com.vmware.license.client.cis.reports.ds.AssetReport;
import com.vmware.license.client.cis.reports.ds.LicenseReport;
import com.vmware.license.client.cis.reports.ds.LicensingDataDumpReport;
import com.vmware.license.client.cis.reports.ds.ProductReport;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationReportEditorWrapperImpl
implements ReportEditor {
    private final ReportEditor _reportEditor;
    private final AuthorizationManager _authorizationManager;
    private final Log _logger = LogFactory.getLog(AuthorizationReportEditorWrapperImpl.class);

    public AuthorizationReportEditorWrapperImpl(ReportEditor reportEditor, AuthorizationManager authorizationManager) {
        this._reportEditor = reportEditor;
        this._authorizationManager = authorizationManager;
    }

    @Override
    public ProductReport[] getProductReports(URI[] uRIArray, LicenseReportScope licenseReportScope) {
        this.validateLicensingPrivilegeGranted(licenseReportScope);
        ProductReport[] productReportArray = this._reportEditor.getProductReports(uRIArray, licenseReportScope);
        return productReportArray;
    }

    @Override
    public LicenseReport[] getLicenseReportsForProduct(URI uRI) {
        UriUtil.validateProductReportUri(uRI);
        LicenseReportScope licenseReportScope = LicenseScopeUtil.getLicenseReportScopeByUiObjectUri(uRI);
        this.validateLicensingPrivilegeGranted(licenseReportScope);
        LicenseReport[] licenseReportArray = this._reportEditor.getLicenseReportsForProduct(uRI);
        return licenseReportArray;
    }

    @Override
    public AssetReport[] getAssetReports(URI uRI, URI uRI2, String string) {
        UriUtil.validateProductReportUri(uRI);
        LicenseReportScope licenseReportScope = LicenseScopeUtil.getLicenseReportScopeByUiObjectUri(uRI);
        this.validateLicensingPrivilegeGranted(licenseReportScope);
        AssetReport[] assetReportArray = this._reportEditor.getAssetReports(uRI, uRI2, string);
        return assetReportArray;
    }

    @Override
    public LicensingDataDumpReport[] getLicensingDataDumpReports(LicenseReportScope licenseReportScope) {
        this.validateLicensingPrivilegeGranted(licenseReportScope);
        LicensingDataDumpReport[] licensingDataDumpReportArray = this._reportEditor.getLicensingDataDumpReports(licenseReportScope);
        return licensingDataDumpReportArray;
    }

    private void validateLicensingPrivilegeGranted(LicenseReportScope licenseReportScope) {
        boolean bl;
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseReportScope});
        LicenseScope licenseScope = licenseReportScope.getLicenseScope();
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseScope});
        try {
            bl = this._authorizationManager.isLicensingAdminPrivilegeGranted(licenseScope);
        }
        catch (Exception exception) {
            this._logger.warn((Object)"Unable to retrieve licensing privileges information. Assuming access is not granted.", (Throwable)exception);
            bl = false;
        }
        if (!bl) {
            throw new ReportException(ManagementUtil.getLocalizedString("error.lsPrivilegeNotGranted"));
        }
    }
}

