/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.impl;

import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.CostUnitUsage;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;

public class CostUnitReportFactory
extends CostUnitFactory {
    public static CostUnitReportFactory INSTANCE = new CostUnitReportFactory();

    @Override
    public CostUnit[] createCostUnits(CostUnitUsage[] costUnitUsageArray, CostUnitLimit[] costUnitLimitArray) {
        CostUnitUsage[] costUnitUsageArray2 = this.getCostUnitUsagesWithValidIds(costUnitUsageArray);
        CostUnitLimit[] costUnitLimitArray2 = this.getCostUnitLimitsWithValidIds(costUnitLimitArray);
        return super.createCostUnits(costUnitUsageArray2, costUnitLimitArray2);
    }

    private CostUnitUsage[] getCostUnitUsagesWithValidIds(CostUnitUsage[] costUnitUsageArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitUsageArray)) {
            return costUnitUsageArray;
        }
        ArrayList<CostUnitUsage> arrayList = new ArrayList<CostUnitUsage>();
        for (CostUnitUsage costUnitUsage : costUnitUsageArray) {
            com.vmware.vim.binding.cis.license.CostUnit costUnit = costUnitUsage.getUnit();
            if (costUnit == null || StringUtil.isNullOrEmpty((String)costUnit.getId())) continue;
            arrayList.add(costUnitUsage);
        }
        return arrayList.toArray(new CostUnitUsage[arrayList.size()]);
    }

    private CostUnitLimit[] getCostUnitLimitsWithValidIds(CostUnitLimit[] costUnitLimitArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitLimitArray)) {
            return costUnitLimitArray;
        }
        ArrayList<CostUnitLimit> arrayList = new ArrayList<CostUnitLimit>();
        for (CostUnitLimit costUnitLimit : costUnitLimitArray) {
            com.vmware.vim.binding.cis.license.CostUnit costUnit = costUnitLimit.getUnit();
            if (costUnit == null || StringUtil.isNullOrEmpty((String)costUnit.getId())) continue;
            arrayList.add(costUnitLimit);
        }
        return arrayList.toArray(new CostUnitLimit[arrayList.size()]);
    }
}

