/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.impl;

import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.license.client.cis.reports.ds.AssetReport;
import com.vmware.license.client.cis.reports.ds.BaseReport;
import com.vmware.license.client.cis.reports.ds.LicenseReport;
import com.vmware.license.client.cis.reports.ds.LicensingDataDumpReport;
import com.vmware.license.client.cis.reports.ds.ProductReport;
import com.vmware.license.client.cis.reports.impl.CostUnitReportFactory;
import com.vmware.vim.binding.cis.license.report.ReportAssetUtilization;
import com.vmware.vim.binding.cis.license.report.ReportLicenseInfo;
import com.vmware.vim.binding.cis.license.report.ReportLicenseUtilization;
import com.vmware.vim.binding.cis.license.report.ReportProduct;
import com.vmware.vim.binding.cis.license.report.ReportProductUtilization;
import com.vmware.vim.binding.cis.license.report.SerialKeyReportLicenseInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.net.URI;

public class ReportUtil {
    private static final CostUnitFactory COST_UNIT_FACTORY = CostUnitReportFactory.INSTANCE;

    public static ProductReport[] createProductReports(ReportProductUtilization[] reportProductUtilizationArray, LicenseReportScope licenseReportScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])reportProductUtilizationArray)) {
            return new ProductReport[0];
        }
        ProductReport[] productReportArray = new ProductReport[reportProductUtilizationArray.length];
        for (int i = 0; i < reportProductUtilizationArray.length; ++i) {
            productReportArray[i] = ReportUtil.createProductReport(reportProductUtilizationArray[i], licenseReportScope);
        }
        return productReportArray;
    }

    public static LicenseReport[] createLicenseReports(ReportLicenseUtilization[] reportLicenseUtilizationArray, LicenseReportScope licenseReportScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])reportLicenseUtilizationArray)) {
            return new LicenseReport[0];
        }
        LicenseReport[] licenseReportArray = new LicenseReport[reportLicenseUtilizationArray.length];
        for (int i = 0; i < reportLicenseUtilizationArray.length; ++i) {
            licenseReportArray[i] = ReportUtil.createLicenseReport(reportLicenseUtilizationArray[i], licenseReportScope);
        }
        return licenseReportArray;
    }

    public static AssetReport[] createAssetReports(ReportAssetUtilization[] reportAssetUtilizationArray, LicenseReportScope licenseReportScope) {
        if (ArrayUtil.isNullOrEmpty((Object[])reportAssetUtilizationArray)) {
            return new AssetReport[0];
        }
        AssetReport[] assetReportArray = new AssetReport[reportAssetUtilizationArray.length];
        for (int i = 0; i < reportAssetUtilizationArray.length; ++i) {
            assetReportArray[i] = ReportUtil.createAssetReport(reportAssetUtilizationArray[i], licenseReportScope);
        }
        return assetReportArray;
    }

    public static LicensingDataDumpReport createLicensingDataDumpReport(byte[] byArray, LicenseReportScope licenseReportScope) {
        LicensingDataDumpReport licensingDataDumpReport = new LicensingDataDumpReport();
        licensingDataDumpReport.setLicenseUsageDump(byArray);
        URI uRI = UriUtil.buildLicensingDataDumpReportUri(licenseReportScope);
        ReportUtil.populateReportProperties(licensingDataDumpReport, uRI, null);
        return licensingDataDumpReport;
    }

    private static ProductReport createProductReport(ReportProductUtilization reportProductUtilization, LicenseReportScope licenseReportScope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reportProductUtilization});
        ProductReport productReport = new ProductReport();
        CostUnit[] costUnitArray = COST_UNIT_FACTORY.createCostUnits(reportProductUtilization.getAggregatedCostUnitsUsage(), reportProductUtilization.getAggregatedCostUnitsLimit());
        productReport.setCostUnits(costUnitArray);
        productReport.setTreatZeroLimitAsNoCapacity(reportProductUtilization.getTreatZeroLimitAsNoCapacity());
        ReportProduct reportProduct = reportProductUtilization.getProduct();
        URI uRI = UriUtil.buildProductReportUri(reportProduct.getId(), licenseReportScope);
        ReportUtil.populateReportProperties(productReport, uRI, reportProduct.getName());
        return productReport;
    }

    private static void populateReportProperties(BaseReport baseReport, URI uRI, String string) {
        baseReport.setUri(uRI);
        baseReport.setName(string);
    }

    private static LicenseReport createLicenseReport(ReportLicenseUtilization reportLicenseUtilization, LicenseReportScope licenseReportScope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reportLicenseUtilization});
        LicenseReport licenseReport = new LicenseReport();
        ProductReport[] productReportArray = ReportUtil.createProductReports(reportLicenseUtilization.getAggregatedProductsUtilization(), licenseReportScope);
        licenseReport.setProductReports(productReportArray);
        ReportLicenseInfo reportLicenseInfo = reportLicenseUtilization.getLicense().getInfo();
        if (reportLicenseInfo instanceof SerialKeyReportLicenseInfo) {
            licenseReport.setSerialKeys(((SerialKeyReportLicenseInfo)reportLicenseInfo).getSerialKeys());
        }
        URI uRI = UriUtil.buildLicenseReportUri(reportLicenseUtilization.getLicense().getId(), licenseReportScope);
        ReportUtil.populateReportProperties(licenseReport, uRI, reportLicenseInfo.getName());
        return licenseReport;
    }

    private static AssetReport createAssetReport(ReportAssetUtilization reportAssetUtilization, LicenseReportScope licenseReportScope) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reportAssetUtilization});
        AssetReport assetReport = new AssetReport();
        CostUnit[] costUnitArray = COST_UNIT_FACTORY.createCostUnits(reportAssetUtilization.getAggregatedCostUnitsUsage(), null);
        assetReport.setCostUnitUsage(costUnitArray);
        URI uRI = UriUtil.buildAssetReportUri(reportAssetUtilization.getAsset().getId(), licenseReportScope);
        ReportUtil.populateReportProperties(assetReport, uRI, reportAssetUtilization.getAsset().getAssetInfo().getName());
        return assetReport;
    }
}

