/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.util;

import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.util.LicensingMethodFault;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vise.util.ArrayUtil;

public class ExceptionUtil {
    public static Exception createLocalizedException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = ExceptionUtil.getMostInnerCause(throwable);
        String string = ExceptionUtil.getLocalizedMessage(throwable2);
        return new LicensingMethodFault(throwable2, string);
    }

    public static Throwable getMostInnerCause(Throwable throwable) {
        if (throwable == null || throwable.getCause() == null) {
            return throwable;
        }
        return ExceptionUtil.getMostInnerCause(throwable.getCause());
    }

    private static String getLocalizedMessage(Throwable throwable) {
        LocalizableMessage[] localizableMessageArray = ExceptionUtil.getLocalizableMessages(throwable);
        String string = ExceptionUtil.getLocalizedMessage(localizableMessageArray);
        return string != null ? string : throwable.getLocalizedMessage();
    }

    private static LocalizableMessage[] getLocalizableMessages(Throwable throwable) {
        if (throwable instanceof RuntimeFault) {
            RuntimeFault runtimeFault = (RuntimeFault)throwable;
            return runtimeFault.getFaultMessage();
        }
        if (throwable instanceof MethodFault) {
            MethodFault methodFault = (MethodFault)throwable;
            return methodFault.getFaultMessage();
        }
        return null;
    }

    private static String getLocalizedMessage(LocalizableMessage[] localizableMessageArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])localizableMessageArray)) {
            return null;
        }
        LocalizableMessage localizableMessage = localizableMessageArray[0];
        if (localizableMessage == null) {
            return null;
        }
        String string = localizableMessage.getKey();
        String string2 = ManagementUtil.getCatalogLocalizedString(string, localizableMessage.getArg());
        if (string2 == null) {
            string2 = localizableMessage.getMessage();
        }
        return string2;
    }
}

