/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cluster.adapter;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.util.ExceptionUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vim.binding.cis.license.fault.NotFoundFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterLicensingPropertyProviderAdapterImpl
implements PropertyProviderAdapter {
    private static final String PROPERTY_NAME_IS_LICENSED = "isLicensed";
    private static final String MO_TYPE_CLUSTER = "ClusterComputeResource";
    private final DataServiceExtensionRegistry _dsExtensionRegistry;
    private final VpxManagementEditor _vpxManagementEditor;
    private final Log _logger = LogFactory.getLog(ClusterLicensingPropertyProviderAdapterImpl.class);

    public ClusterLicensingPropertyProviderAdapterImpl(DataServiceExtensionRegistry dataServiceExtensionRegistry, VpxManagementEditor vpxManagementEditor) {
        this._dsExtensionRegistry = dataServiceExtensionRegistry;
        this._vpxManagementEditor = vpxManagementEditor;
    }

    public void init() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = MO_TYPE_CLUSTER;
        typeInfo.properties = new String[]{PROPERTY_NAME_IS_LICENSED};
        TypeInfo[] typeInfoArray = new TypeInfo[]{typeInfo};
        this._dsExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, typeInfoArray);
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        PropertyValue propertyValue;
        LicenseScope licenseScope;
        PropertyValue propertyValue2;
        ManagedObjectReference managedObjectReference;
        ResultSet resultSet;
        block6: {
            ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
            resultSet = new ResultSet();
            Object[] objectArray = propertyRequestSpec.objects;
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || objectArray.length != 1) {
                int n = objectArray == null ? 0 : objectArray.length;
                this._logger.warn((Object)("Unable to provide isLicensed property. Requested objects refs length: " + n));
                return resultSet;
            }
            Object object = objectArray[0];
            if (!(object instanceof ManagedObjectReference) || !MO_TYPE_CLUSTER.equals(((ManagedObjectReference)object).getType())) {
                this._logger.warn((Object)("Unable to provide isLicensed property. The request is for non-cluster object: " + object));
                return resultSet;
            }
            Set<String> set = ClusterLicensingPropertyProviderAdapterImpl.getPropertyNames(propertyRequestSpec.properties);
            if (!set.contains(PROPERTY_NAME_IS_LICENSED)) {
                this._logger.warn((Object)"Unable to provide isLicensed property. The property is not requested");
                return resultSet;
            }
            managedObjectReference = (ManagedObjectReference)object;
            propertyValue2 = null;
            try {
                licenseScope = LicenseScopeUtil.getLicenseScopeByMoRef(managedObjectReference);
                propertyValue = this._vpxManagementEditor.getAssetsByMoRefs(new ManagedObjectReference[]{managedObjectReference}, licenseScope);
                if (ArrayUtil.isNullOrEmpty((Object[])propertyValue)) {
                    throw new IllegalStateException("Null or 0 assets returned for a single managed object reference.");
                }
                propertyValue2 = propertyValue[0];
            }
            catch (ManagementException managementException) {
                if (managementException.getCause() instanceof NotFoundFault) break block6;
                this._logger.error((Object)"Unable to provide isLicensed property. LS call failed.", (Throwable)managementException);
                resultSet.error = ExceptionUtil.createLocalizedException(managementException);
            }
        }
        licenseScope = new ResultItem();
        ((ResultItem)licenseScope).resourceObject = managedObjectReference;
        propertyValue = new PropertyValue();
        propertyValue.resourceObject = managedObjectReference;
        propertyValue.propertyName = PROPERTY_NAME_IS_LICENSED;
        propertyValue.value = ClusterLicensingPropertyProviderAdapterImpl.isAssetLicensed((Asset)propertyValue2);
        ((ResultItem)licenseScope).properties = new PropertyValue[]{propertyValue};
        resultSet.items = new ResultItem[]{licenseScope};
        return resultSet;
    }

    private static Set<String> getPropertyNames(PropertySpec[] propertySpecArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])propertySpecArray)) {
            return hashSet;
        }
        for (PropertySpec propertySpec : propertySpecArray) {
            Object[] objectArray;
            if (propertySpec == null || ArrayUtil.isNullOrEmpty((Object[])(objectArray = propertySpec.propertyNames))) continue;
            for (Object object : objectArray) {
                hashSet.add((String)object);
            }
        }
        return hashSet;
    }

    private static boolean isAssetLicensed(Asset asset) {
        return asset != null && AssetLicenseState.LICENSED.equals((Object)asset.getLicenseState());
    }
}

