/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup;

import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.VimServicesUtil;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import com.vmware.vise.vim.lookup.impl.LookupServiceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.Scanner;

public class LookupServiceConfigurationTool {
    private static final int SUCCESS_EXIT_CODE = 0;
    private static final int ERROR_EXIT_CODE = 1;
    private static final String LS_URL_KEY = "ls.url";
    private static final String LS_THUMBPRINT_KEY = "ls.thumbprint";
    private static final String SAVE_THUMBPRINT = "save";
    private static boolean _vmodlContextInitialized = false;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println(VimServicesUtil.getLocalizedString("LookupServiceConfigurationTool.noArgument", new String[0]));
            LookupServiceConfigurationTool.printUsage();
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray.length > 2 ? stringArray[2] : null;
        int n = LookupServiceConfigurationTool.processRequest(string, string2, string3);
        System.exit(n);
    }

    private static int processRequest(String string, String string2, String string3) throws Exception {
        try {
            SharedHttpConfigPool sharedHttpConfigPool = new SharedHttpConfigPool.Builder().maxConnections(500).connectionTimeoutInMillis(20000).timeoutInMillis(120000).build();
            URI uRI = new URI(string2);
            LookupServiceImpl.createLookupService(uRI, string3, (HttpConfigurationProvider)sharedHttpConfigPool);
            LookupServiceConfigurationTool.saveClientConfig(string, uRI, string3);
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof CertificateValidationException) {
                CertificateValidationException certificateValidationException = (CertificateValidationException)exception.getCause();
                if (!LookupServiceConfigurationTool.handleSslError(string2, string3, certificateValidationException.getThumbprint())) {
                    return 0;
                }
                return LookupServiceConfigurationTool.processRequest(string, string2, certificateValidationException.getThumbprint());
            }
            throw exception;
        }
        System.out.println(VimServicesUtil.getLocalizedString("LookupServiceConfigurationTool.configure.success", new String[0]));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handleSslError(String string, String string2, String string3) {
        if (SAVE_THUMBPRINT.equalsIgnoreCase(string2)) {
            return true;
        }
        String string4 = String.format(VimServicesUtil.getLocalizedString("LookupServiceConfigurationTool.sslError", new String[0]), string, string3);
        System.out.println(string4);
        try (Scanner scanner = new Scanner(System.in);){
            String string5 = scanner.nextLine().toLowerCase();
            if (string5.equals("a")) {
                boolean bl = true;
                return bl;
            }
        }
        System.out.println(String.format(VimServicesUtil.getLocalizedString("LookupServiceConfigurationTool.certificateRejectError", new String[0]), string));
        return false;
    }

    private static void printUsage() {
        System.out.println(VimServicesUtil.getLocalizedString("LookupServiceConfigurationTool.usage", new String[0]));
    }

    private static synchronized void initializeVmodlContextOnce() {
        if (_vmodlContextInitialized) {
            return;
        }
        VmodlContext.initContext((String[])new String[]{"com.vmware.vim.binding.lookup"});
        _vmodlContextInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getClientConfig(String string) throws IOException {
        Properties properties = new Properties();
        File file = new File(string);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveClientConfig(String string, URI uRI, String string2) throws IOException {
        Properties properties = LookupServiceConfigurationTool.getClientConfig(string);
        properties.setProperty(LS_URL_KEY, uRI.toString());
        if (StringUtil.isNullOrEmpty((String)string2) || SAVE_THUMBPRINT.equals(string2)) {
            properties.remove(LS_THUMBPRINT_KEY);
        } else {
            properties.setProperty(LS_THUMBPRINT_KEY, string2);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, null);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    static {
        LookupServiceConfigurationTool.initializeVmodlContextOnce();
    }
}

