/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cloudvm.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenEx;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.xmlrpc.XmlRpcClient;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcHttpTransportException;

public class CloudVmXmlRpcClient
extends XmlRpcClient {
    private static final String SAML_QUERY_PARAM = "SAMLResponse";
    private static final String AUTH_COOKIE_NAME = "PRE_AUTHENTICATED";
    private String _authCookieValue = null;
    private boolean _authenticationFailed = false;
    private static final Log _logger = LogFactory.getLog(CloudVmXmlRpcClient.class);
    private SsoService _ssoService;

    public CloudVmXmlRpcClient(SsoService ssoService, KeyStore keyStore, URL uRL, boolean bl) {
        super(keyStore, uRL, bl);
        this._ssoService = ssoService;
    }

    public synchronized Object execute(String string, Object[] objectArray) throws XmlRpcException {
        Object object;
        if (this._authCookieValue == null || this._authenticationFailed) {
            object = this.executeWithLogin(string, objectArray);
        } else {
            try {
                this.setLoginCookie(this._authCookieValue);
                object = super.execute(string, objectArray);
            }
            catch (XmlRpcHttpTransportException xmlRpcHttpTransportException) {
                if (xmlRpcHttpTransportException.getStatusCode() == 401) {
                    this._authCookieValue = null;
                    this.setLoginCookie(null);
                    object = this.executeWithLogin(string, objectArray);
                }
                throw xmlRpcHttpTransportException;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeWithLogin(String string, Object[] objectArray) throws XmlRpcException {
        Object object;
        boolean bl = this._authCookieValue != null;
        XmlRpcClientConfigImpl xmlRpcClientConfigImpl = (XmlRpcClientConfigImpl)this.getConfig();
        URL uRL = xmlRpcClientConfigImpl.getServerURL();
        if (!bl) {
            object = this.getLoginUrl(uRL);
            xmlRpcClientConfigImpl.setServerURL((URL)object);
        }
        object = null;
        XmlRpcException xmlRpcException = null;
        try {
            object = super.execute(string, objectArray);
        }
        catch (XmlRpcHttpTransportException xmlRpcHttpTransportException) {
            if (xmlRpcHttpTransportException.getStatusCode() == 401) {
                _logger.error((Object)"Authentication to the appliance manager failed", (Throwable)xmlRpcException);
                this._authCookieValue = null;
                this.setLoginCookie(null);
                this._authenticationFailed = true;
            }
            throw xmlRpcHttpTransportException;
        }
        catch (XmlRpcException xmlRpcException2) {
            xmlRpcException = xmlRpcException2;
        }
        finally {
            if (!bl) {
                xmlRpcClientConfigImpl.setServerURL(uRL);
            }
        }
        Map map = this.getLastTransactionResponseHeaders();
        String string2 = this.getAuthCookieValueFromHeaders(map);
        if (string2 == null) {
            _logger.error((Object)"Authenticated to the appliance management, but no cookie returned.");
        }
        this._authCookieValue = string2;
        this._authenticationFailed = false;
        if (xmlRpcException != null) {
            throw xmlRpcException;
        }
        return object;
    }

    private SamlToken getBearerToken() {
        SsoDomain ssoDomain = SsoDomain.getLocal();
        TokenEx tokenEx = AuthSessionUtil.getSsoTokenEx((SsoDomain)ssoDomain);
        if (tokenEx == null) {
            throw new IllegalStateException("Can't find a token for domain " + ssoDomain);
        }
        SamlToken samlToken = tokenEx.getToken();
        SsoDomain ssoDomain2 = tokenEx.getIssuerSsoDomain();
        Date date = new Date();
        long l = samlToken.getExpirationTime().getTime() - date.getTime();
        long l2 = l / 1000L;
        TokenSpec.Builder builder = new TokenSpec.Builder(l2);
        TokenSpec.DelegationSpec delegationSpec = new TokenSpec.DelegationSpec(samlToken.isDelegable());
        TokenSpec tokenSpec = builder.delegationSpec(delegationSpec).renewable(samlToken.isRenewable()).confirmation(TokenSpec.Confirmation.NONE).audienceRestriction(samlToken.getAudience()).advice(samlToken.getAdvice()).createTokenSpec();
        SamlToken samlToken2 = null;
        try {
            samlToken2 = this._ssoService.acquireTokenByToken(ssoDomain, ssoDomain2, samlToken, tokenSpec);
        }
        catch (SsoServiceException ssoServiceException) {
            _logger.error((Object)"Could not construct bearer token", (Throwable)ssoServiceException);
        }
        return samlToken2;
    }

    private URL getLoginUrl(URL uRL) {
        SamlToken samlToken = this.getBearerToken();
        String string = CloudVmXmlRpcClient.getAuthorizationParameter(samlToken);
        String string2 = String.format("%s=%s", SAML_QUERY_PARAM, string);
        String string3 = StringUtil.isNullOrEmpty((String)uRL.getQuery()) ? "?" : "&";
        String string4 = uRL.toString();
        String string5 = String.format("%s%s%s", string4, string3, string2);
        URL uRL2 = null;
        try {
            uRL2 = new URL(string5);
        }
        catch (MalformedURLException malformedURLException) {
            _logger.error((Object)"Malformed URL while trying to authenticate to applmgmt", (Throwable)malformedURLException);
            uRL2 = uRL;
        }
        return uRL2;
    }

    private static String getAuthorizationParameter(SamlToken samlToken) {
        String string;
        if (samlToken == null) {
            return null;
        }
        String string2 = samlToken.toXml();
        String string3 = string = new String(Base64.encodeBase64((byte[])string2.getBytes()));
        try {
            string3 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            _logger.error((Object)"UTF-8 is not supported", (Throwable)unsupportedEncodingException);
        }
        return string3;
    }

    private String getAuthCookieValueFromHeaders(Map<String, List<String>> map) {
        List<String> list = map.get("Set-Cookie");
        if (list == null) {
            return null;
        }
        for (String string : list) {
            List<HttpCookie> list2 = HttpCookie.parse(string);
            for (HttpCookie httpCookie : list2) {
                if (!AUTH_COOKIE_NAME.equals(httpCookie.getName())) continue;
                return httpCookie.getValue();
            }
        }
        return null;
    }

    private void setLoginCookie(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            hashMap.put("Cookie", String.format("%s=%s", AUTH_COOKIE_NAME, this._authCookieValue));
        }
        this.setCustomHeaders(hashMap);
    }
}

