/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm;

import com.vmware.cis.cm.common.jaxb.healthstatus.HealthMessage;
import com.vmware.cis.cm.common.jaxb.healthstatus.HealthStatus;
import com.vmware.cis.services.common.util.JaxbUtil;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.cm.HealthStatusCode;
import com.vmware.vise.vim.cm.healthstatus.WebClientHealthStatus;
import com.vmware.vise.vim.cm.healthstatus.WebClientHealthStatusService;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.HttpRequestHandler;

public class HealthStatusRequestHandler
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final long REQUEST_PROCESSING_TIME_THRESHOLD_NANOS = TimeUnit.SECONDS.toNanos(5L);
    @Nonnull
    private final WebClientHealthStatusService _healthStatusService;
    @Nonnull
    private final ScheduledExecutorService _execService;
    @Nonnegative
    private final long _statusPollingPeriod;
    @Nonnull
    private final TimeUnit _statusPollingTimeUnit;
    @Nonnull
    private final ScheduledFuture<?> _healthStatusScheduledFuture;
    @Nonnull
    private final AtomicReference<WebClientHealthStatus> _healthStatusRef;
    @Nonnull
    private static final JAXBContext HEALTH_STATUS_JAXB_CONTEXT;

    public HealthStatusRequestHandler(@Nonnull WebClientHealthStatusService webClientHealthStatusService, @Nonnull @WillNotClose ScheduledExecutorService scheduledExecutorService, @Nonnegative long l, @Nonnull TimeUnit timeUnit) {
        Validate.notNull((Object)webClientHealthStatusService);
        Validate.notNull((Object)scheduledExecutorService);
        Validate.isTrue((l >= 0L ? 1 : 0) != 0);
        Validate.notNull((Object)((Object)timeUnit));
        this._healthStatusService = webClientHealthStatusService;
        this._execService = scheduledExecutorService;
        this._statusPollingPeriod = l;
        this._statusPollingTimeUnit = timeUnit;
        WebClientHealthStatus webClientHealthStatus = new WebClientHealthStatus(HealthStatusCode.GREEN, null);
        this._healthStatusRef = new AtomicReference<WebClientHealthStatus>(webClientHealthStatus);
        HealthStatusCollectorTask healthStatusCollectorTask = new HealthStatusCollectorTask(this._healthStatusService, this._healthStatusRef);
        this._healthStatusScheduledFuture = this._execService.scheduleAtFixedRate(healthStatusCollectorTask, 0L, this._statusPollingPeriod, this._statusPollingTimeUnit);
    }

    public void destroy() {
        this._healthStatusScheduledFuture.cancel(true);
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        long l = System.nanoTime();
        _logger.info((Object)"Received a health status request");
        WebClientHealthStatus webClientHealthStatus = this._healthStatusRef.get();
        Exception exception = null;
        try (ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)servletOutputStream, StringUtil.CHARSET_UTF8);
             BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);){
            HealthStatusCode healthStatusCode = webClientHealthStatus.getStatusCode();
            HealthStatus healthStatus = new HealthStatus();
            healthStatus.setStatus(healthStatusCode.toString());
            List<LocalizableMessage> list = webClientHealthStatus.getMessages();
            if (list != null && list.size() > 0) {
                List list2 = healthStatus.getMessage();
                for (LocalizableMessage localizableMessage : list) {
                    HealthMessage healthMessage = new HealthMessage();
                    healthMessage.setMessageKey(localizableMessage.getKey());
                    healthMessage.setDefaultMessage(localizableMessage.getMessage());
                    list2.add(healthMessage);
                }
            }
            httpServletResponse.setHeader("Content-Type", "application/xml; charset=utf-8");
            JaxbUtil.marshal((Writer)bufferedWriter, (Object)healthStatus, null);
        }
        catch (Exception exception2) {
            exception = exception2;
            throw new IOException("Failed to convert the health status to XML", exception2);
        }
        finally {
            long l2 = System.nanoTime() - l;
            if (exception == null) {
                _logger.info((Object)("Done processing health status request: " + webClientHealthStatus));
            } else {
                _logger.error((Object)"Health status request processing failed: ", (Throwable)exception);
            }
            if (l2 > REQUEST_PROCESSING_TIME_THRESHOLD_NANOS) {
                _logger.warn((Object)("Health status request processing took too long: " + TimeUnit.NANOSECONDS.toMillis(l2)));
            }
        }
    }

    static {
        try {
            HEALTH_STATUS_JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{HealthStatus.class});
        }
        catch (JAXBException jAXBException) {
            throw new ExceptionInInitializerError(jAXBException);
        }
    }

    private static class HealthStatusCollectorTask
    implements Runnable {
        private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
        @Nonnull
        private final WebClientHealthStatusService _healthStatusService;
        @Nonnull
        private final AtomicReference<WebClientHealthStatus> _healthStatusRef;

        public HealthStatusCollectorTask(@Nonnull WebClientHealthStatusService webClientHealthStatusService, @Nonnull AtomicReference<WebClientHealthStatus> atomicReference) {
            this._healthStatusService = webClientHealthStatusService;
            this._healthStatusRef = atomicReference;
        }

        @Override
        public void run() {
            long l = System.nanoTime();
            try {
                _logger.debug((Object)"Determining health status...");
                WebClientHealthStatus webClientHealthStatus = this._healthStatusService.getStatus();
                if (webClientHealthStatus == null) {
                    throw new IllegalStateException("The health status service returned null");
                }
                this._healthStatusRef.set(webClientHealthStatus);
                long l2 = System.nanoTime() - l;
                _logger.info((Object)("Determined health status '" + webClientHealthStatus + "' in " + TimeUnit.NANOSECONDS.toMillis(l2) + " ms"));
            }
            catch (Exception exception) {
                WebClientHealthStatus webClientHealthStatus = new WebClientHealthStatus(HealthStatusCode.YELLOW, null, exception);
                this._healthStatusRef.set(webClientHealthStatus);
                long l3 = System.nanoTime() - l;
                _logger.error((Object)("Health status computation failed in " + TimeUnit.NANOSECONDS.toMillis(l3) + " ms"), (Throwable)exception);
            }
        }
    }
}

