/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm.healthstatus;

import com.vmware.vim.binding.impl.vmodl.LocalizableMessageImpl;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.cm.HealthStatusCode;
import com.vmware.vise.vim.cm.healthstatus.WebClientHealthStatus;
import com.vmware.vise.vim.cm.healthstatus.WebClientHealthStatusService;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppServerHealthService
implements WebClientHealthStatusService {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private double _memoryThreshold = 0.9;

    @Override
    public WebClientHealthStatus getStatus() {
        WebClientHealthStatus webClientHealthStatus = this.getMemoryStatus();
        return webClientHealthStatus;
    }

    private WebClientHealthStatus getMemoryStatus() {
        Object object;
        HealthStatusCode healthStatusCode = null;
        List<LocalizableMessageImpl> list = null;
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        long l = memoryUsage.getUsed();
        long l2 = memoryUsage.getMax();
        double d = (double)l / (double)l2;
        DecimalFormat decimalFormat = StringUtil.getGroupByThreeDecimalFormat();
        String string = "Memory usage: used=" + decimalFormat.format(l) + "; max=" + decimalFormat.format(l2) + "; percentage=" + d * 100.0 + "%. Status: ";
        if (d > this._memoryThreshold) {
            healthStatusCode = HealthStatusCode.YELLOW;
            object = new LocalizableMessageImpl();
            object.setKey("webclient.memory.lowheap");
            object.setMessage("The server is running low on heap memory (>90% utilized.)");
            list = Collections.singletonList(object);
            _logger.warn((Object)(string + (Object)((Object)healthStatusCode)));
        } else {
            healthStatusCode = HealthStatusCode.GREEN;
            _logger.info((Object)(string + (Object)((Object)healthStatusCode)));
        }
        object = new WebClientHealthStatus(healthStatusCode, list, null);
        return object;
    }
}

