/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.cm.healthstatus;

import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vise.vim.cm.HealthStatusCode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;

public class WebClientHealthStatus {
    private final HealthStatusCode _statusCode;
    private final List<LocalizableMessage> _messages;
    private final Exception _exception;

    public WebClientHealthStatus(@Nonnull HealthStatusCode healthStatusCode, @Nullable List<LocalizableMessage> list) {
        this(healthStatusCode, list, null);
    }

    public WebClientHealthStatus(@Nonnull HealthStatusCode healthStatusCode, @Nullable List<LocalizableMessage> list, @Nullable Exception exception) {
        Validate.notNull((Object)((Object)healthStatusCode));
        this._statusCode = healthStatusCode;
        this._messages = list;
        this._exception = exception;
    }

    public HealthStatusCode getStatusCode() {
        return this._statusCode;
    }

    public List<LocalizableMessage> getMessages() {
        return this._messages;
    }

    public Exception getException() {
        return this._exception;
    }

    public String toString() {
        if (this._exception == null && (this._messages == null || this._messages.isEmpty())) {
            return this._statusCode.toString();
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this._statusCode.toString()).append(": ");
        if (this._messages != null && this._messages.size() > 0) {
            stringBuilder.append(this._messages.toString());
        }
        if (this._exception != null) {
            stringBuilder.append('\n').append(this._exception.toString());
        }
        return stringBuilder.toString();
    }
}

