/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.connections;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vise.vim.vmafd.VmAfDataProvider;
import com.vmware.vise.vim.vmafd.impl.VmAfClientBasedVmAfDataProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiteAffinityServerEndpointProvider
implements ServerEndpointProvider {
    private static final Log _logger = LogFactory.getLog(SiteAffinityServerEndpointProvider.class);
    private static final long EXECUTION_TIME_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(500L);
    @Nonnull
    private final VmAfDataProvider _vmAfDataProvider;
    @Nullable
    private final SsoDomain _ssoDomain;
    @Nullable
    private final URI _serverUri;

    public SiteAffinityServerEndpointProvider(@Nullable URI uRI) {
        this(SsoDomain.getLocal(), uRI);
    }

    public SiteAffinityServerEndpointProvider(@Nullable SsoDomain ssoDomain, @Nullable URI uRI) {
        this(new VmAfClientBasedVmAfDataProvider(), ssoDomain, uRI);
    }

    public SiteAffinityServerEndpointProvider(@Nonnull VmAfDataProvider vmAfDataProvider, @Nullable SsoDomain ssoDomain, @Nullable URI uRI) {
        Validate.notNull((Object)vmAfDataProvider);
        this._vmAfDataProvider = vmAfDataProvider;
        this._ssoDomain = ssoDomain;
        this._serverUri = uRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getServerEndpoint() {
        _logger.debug((Object)"Running getServerEndpoint()");
        long l = System.nanoTime();
        long l2 = -1L;
        URI uRI = null;
        try {
            uRI = this.getAffinitizedUri();
            l2 = System.nanoTime();
            URI uRI2 = uRI;
            return uRI2;
        }
        finally {
            long l3 = l2 - l;
            if (l3 > EXECUTION_TIME_THRESHOLD_NANOS) {
                _logger.warn((Object)("getServerEndpoint() took too long: " + l3 + " ms"));
            } else if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("getServerEndpoint() done: " + uRI));
            }
        }
    }

    private URI getAffinitizedUri() {
        String string = this._vmAfDataProvider.getDomainController("localhost", this._ssoDomain);
        if (string == null) {
            _logger.trace((Object)"DomainController data not available. Will not modify URI.");
            return this._serverUri;
        }
        try {
            URI uRI = new URI(this._serverUri.getScheme(), this._serverUri.getUserInfo(), string, this._serverUri.getPort(), this._serverUri.getPath(), this._serverUri.getQuery(), this._serverUri.getFragment());
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Failed to create affinitized URL", uRISyntaxException);
        }
    }
}

