/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.directory.extensions;

import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.PluginPackageSource;
import com.vmware.vise.extensionfw.PluginSignatureService;
import com.vmware.vise.extensionfw.signing.PluginSignatureException;
import com.vmware.vise.extensionfw.signing.PluginSignatureGeneralException;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.Timeout;
import com.vmware.vise.util.ZipUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.common.Environment;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.directory.extensions.DirectoryExtensionManagerProvider;
import com.vmware.vise.vim.extension.util.VcExtensionUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectoryExtensionManager
implements ExtensionListener,
PluginPackageSource {
    private static final Log _logger = LogFactory.getLog(DirectoryExtensionManager.class);
    protected static final String INCOMPLETE_STATUS_FILE_NAME = ".incomplete";
    private final DirectoryExtensionManagerProvider _provider;
    private final ExtensionService _extensionService;
    private final ExecutorService _downloadExecutor;
    private final ConfigurationService _configurationService;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    protected final String _packageBaseFolderName;
    private final Timeout _socketConnectionTimeout;
    private final Timeout _socketReadTimeout;
    private final Set<IdVersionPair> _registeredPackageRefs = new HashSet<IdVersionPair>();
    private final ConcurrentMap<File, Object> _lockByPackageDir = new ConcurrentHashMap<File, Object>();
    private final PluginSignatureService _pluginSignatureService;

    public DirectoryExtensionManager(DirectoryExtensionManagerProvider directoryExtensionManagerProvider, ExtensionService extensionService, ExecutorService executorService, ConfigurationService configurationService, SSLConfigurationProvider sSLConfigurationProvider, String string, Timeout timeout, Timeout timeout2, @Nullable PluginSignatureService pluginSignatureService) {
        Validate.notNull((Object)directoryExtensionManagerProvider);
        Validate.notNull((Object)extensionService);
        Validate.notNull((Object)executorService);
        Validate.notNull((Object)configurationService);
        Validate.notNull((Object)sSLConfigurationProvider);
        Validate.notNull((Object)string);
        Validate.notNull((Object)timeout);
        Validate.notNull((Object)timeout2);
        this._provider = directoryExtensionManagerProvider;
        this._extensionService = extensionService;
        this._downloadExecutor = executorService;
        this._configurationService = configurationService;
        this._sslConfigurationProvider = sSLConfigurationProvider;
        this._packageBaseFolderName = string;
        this._socketConnectionTimeout = timeout;
        this._socketReadTimeout = timeout2;
        this._pluginSignatureService = pluginSignatureService;
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        if (!pluginPackageEvent.getType().equals("pluginPackageUndeployed")) {
            return;
        }
        for (PluginPackageInfo pluginPackageInfo : pluginPackageEvent.getPluginPackageInfos()) {
            this.packageUndeployed(pluginPackageInfo.getPackageRef());
        }
    }

    public Set<IdVersionPair> deployNewPackages() {
        Collection<DirectoryExtensionManagerProvider.DirectoryPackageInfo> collection = this.discoverPackages();
        return this.deployPackages(collection);
    }

    private Collection<DirectoryExtensionManagerProvider.DirectoryPackageInfo> discoverPackages() {
        Collection<DirectoryExtensionManagerProvider.DirectoryPackageInfo> collection;
        try {
            collection = this._provider.discoverPackages();
        }
        catch (RuntimeException runtimeException) {
            _logger.error((Object)"Directory service provider failed while discovering new plugin packages.", (Throwable)runtimeException);
            collection = Collections.emptySet();
        }
        return collection;
    }

    protected String getPackageDirName(IdVersionPair idVersionPair) {
        return idVersionPair.getId() + "-" + idVersionPair.getVersion();
    }

    protected File getPackageDir(String string) {
        Path path = Paths.get(Environment.clientAppDataFolder(), this._packageBaseFolderName, string);
        return path.toFile();
    }

    private Object getPackageDirLock(File file) {
        Object object;
        Object object2 = this._lockByPackageDir.get(file);
        if (object2 == null && (object = this._lockByPackageDir.putIfAbsent(file, object2 = new Object())) != null) {
            object2 = object;
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packageUndeployed(IdVersionPair idVersionPair) {
        Object object;
        Object object2 = this._registeredPackageRefs;
        synchronized (object2) {
            this._registeredPackageRefs.remove(idVersionPair);
        }
        object2 = this.getPackageDir(this.getPackageDirName(idVersionPair));
        Object object3 = object = this.getPackageDirLock((File)object2);
        synchronized (object3) {
            try {
                if (((File)object2).exists()) {
                    _logger.info((Object)("Delete package directory '" + object2 + "' because the package is undeployed."));
                    FileUtil.deleteDir((File)object2);
                }
            }
            finally {
                this.removePackageDirLock((File)object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IdVersionPair> deployPackages(Collection<DirectoryExtensionManagerProvider.DirectoryPackageInfo> collection) {
        Object object2;
        ArrayList<Future<IdVersionPair>> arrayList = new ArrayList<Future<IdVersionPair>>();
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        for (final Object object2 : collection) {
            IdVersionPair idVersionPair = object2.getPackageRef();
            try {
                boolean bl;
                final SessionUtil.ThreadContext threadContext = this._registeredPackageRefs;
                synchronized (threadContext) {
                    bl = this._registeredPackageRefs.contains(idVersionPair);
                    if (!bl) {
                        bl = this._extensionService.getPluginPackageInfo(idVersionPair) != null;
                    }
                }
                if (bl) {
                    hashSet.add(idVersionPair);
                    continue;
                }
                threadContext = SessionUtil.getThreadContext((boolean)true);
                Callable<IdVersionPair> callable = new Callable<IdVersionPair>(){

                    @Override
                    public IdVersionPair call() {
                        SessionUtil.ThreadContext threadContext2 = SessionUtil.getThreadContext((boolean)false);
                        SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext);
                        try {
                            IdVersionPair idVersionPair = DirectoryExtensionManager.this.downloadAndDeployPackage(object2);
                            return idVersionPair;
                        }
                        finally {
                            SessionUtil.setThreadContext((SessionUtil.ThreadContext)threadContext2);
                        }
                    }
                };
                Future<IdVersionPair> future = this._downloadExecutor.submit(callable);
                arrayList.add(future);
            }
            catch (Exception exception) {
                _logger.error((Object)("Failed deploying extension: " + idVersionPair), (Throwable)exception);
            }
        }
        Set<IdVersionPair> set = this.waitForPackagesToDeploy(arrayList);
        hashSet.addAll(set);
        this.updatePackagesMetadata(hashSet, collection);
        object2 = this._registeredPackageRefs;
        synchronized (object2) {
            this._registeredPackageRefs.addAll(hashSet);
        }
        return hashSet;
    }

    private Set<IdVersionPair> waitForPackagesToDeploy(Iterable<Future<IdVersionPair>> iterable) {
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        for (Future<IdVersionPair> future : iterable) {
            try {
                IdVersionPair idVersionPair = future.get();
                if (idVersionPair == null) continue;
                hashSet.add(idVersionPair);
            }
            catch (Exception exception) {
                _logger.error((Object)"Error while waiting for plugin package to deploy.", (Throwable)exception);
            }
        }
        return hashSet;
    }

    private void updatePackagesMetadata(Set<IdVersionPair> set, Collection<DirectoryExtensionManagerProvider.DirectoryPackageInfo> collection) {
        for (IdVersionPair idVersionPair : set) {
            PluginPackageInfo pluginPackageInfo = this.getDeployedPluginPackage(idVersionPair);
            if (pluginPackageInfo == null) continue;
            this.updatePackageMetadata(pluginPackageInfo, collection);
        }
    }

    private void updatePackageMetadata(PluginPackageInfo pluginPackageInfo, Collection<DirectoryExtensionManagerProvider.DirectoryPackageInfo> collection) {
        ConcurrentMap concurrentMap = pluginPackageInfo.getMetadata();
        for (DirectoryExtensionManagerProvider.DirectoryPackageInfo directoryPackageInfo : collection) {
            String string;
            if (!directoryPackageInfo.getPackageRef().equals((Object)pluginPackageInfo.getPackageRef())) continue;
            String string2 = directoryPackageInfo.serviceInstance;
            try {
                string = DirectoryExtensionManager.extractBaseUrl(directoryPackageInfo.url);
            }
            catch (MalformedURLException malformedURLException) {
                _logger.warn((Object)String.format("Could not determine the base URL for the instance of %s provided by service %s.", pluginPackageInfo.getPackageRef(), string2));
                continue;
            }
            ConcurrentHashMap<String, String> concurrentHashMap = (ConcurrentHashMap<String, String>)concurrentMap.get("pluginRegistrationUrlByServer");
            if (concurrentHashMap == null) {
                concurrentHashMap = new ConcurrentHashMap<String, String>();
                concurrentMap.putIfAbsent("pluginRegistrationUrlByServer", concurrentHashMap);
            }
            concurrentHashMap.put(string2, string);
        }
    }

    private PluginPackageInfo getDeployedPluginPackage(IdVersionPair idVersionPair) {
        try {
            return this._extensionService.getPluginPackageInfo(idVersionPair);
        }
        catch (Exception exception) {
            _logger.error((Object)("ExtensionService.getPluginPackageInfo for " + idVersionPair + " failed"), (Throwable)exception);
            return null;
        }
    }

    public static String extractBaseUrl(String string) throws MalformedURLException {
        URL uRL = new URL(string);
        String string2 = uRL.getPath();
        int n = string2.lastIndexOf(47);
        String string3 = n == -1 ? string2 : string2.substring(0, n);
        return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string3).toString();
    }

    private Object removePackageDirLock(File file) {
        return this._lockByPackageDir.remove(file);
    }

    protected IdVersionPair downloadAndDeployPackage(DirectoryExtensionManagerProvider.DirectoryPackageInfo directoryPackageInfo) {
        File file = this.downloadPackage(directoryPackageInfo);
        if (file == null) {
            return null;
        }
        directoryPackageInfo.setDirectory(file);
        IdVersionPair idVersionPair = null;
        try {
            Set set = this._extensionService.addPluginPackages(new PluginPackageInfo[]{directoryPackageInfo});
            if (set != null && set.size() == 1) {
                idVersionPair = (IdVersionPair)set.iterator().next();
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Deploying extension " + directoryPackageInfo.getPackageRef() + " failed"), (Throwable)exception);
        }
        return idVersionPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadPackage(DirectoryExtensionManagerProvider.DirectoryPackageInfo directoryPackageInfo) {
        String string = this.getPackageDirName(directoryPackageInfo.getPackageRef());
        File file = this.getPackageDir(string);
        Object object = this.getPackageDirLock(file);
        File file2 = new File(file, INCOMPLETE_STATUS_FILE_NAME);
        Object object2 = object;
        synchronized (object2) {
            File file3;
            Object object3;
            if (FileUtil.isNonEmptyDirectory((File)file)) {
                if (!directoryPackageInfo.isRemotePlugin()) {
                    object3 = string + ".zip";
                    this.performPluginSignatureCheckIfNecessary(directoryPackageInfo, new File(file, (String)object3));
                }
                if (file2.exists()) {
                    _logger.info((Object)"Found invalid cached plugin package. Will retry the download.");
                    FileUtil.cleanupDir((File)file);
                } else {
                    return file;
                }
            }
            if ((object3 = this.downloadTempFile(directoryPackageInfo, file)) == null) {
                return null;
            }
            try {
                FileUtil.writeTextFile((File)file2, (String)"");
            }
            catch (IOException iOException) {
                _logger.warn((Object)("Failed to create the plugin download status file" + file2.getPath()));
            }
            try {
                if (directoryPackageInfo.isRemotePlugin()) {
                    this.processRemotePlugin(directoryPackageInfo, file, (File)object3);
                } else {
                    this.processLocalPlugin(directoryPackageInfo, file, (File)object3);
                }
                file2.delete();
                file3 = file;
            }
            catch (IOException | RuntimeException exception) {
                File file4;
                try {
                    _logger.error((Object)String.format("Package %s was not installed.", directoryPackageInfo.getPackageRef()), (Throwable)exception);
                    FileUtil.deleteDir((File)file);
                    file4 = null;
                    ((File)object3).delete();
                }
                catch (Throwable throwable) {
                    ((File)object3).delete();
                    throw throwable;
                }
                return file4;
            }
            ((File)object3).delete();
            return file3;
        }
    }

    protected File downloadTempFile(DirectoryExtensionManagerProvider.DirectoryPackageInfo directoryPackageInfo, File file) {
        File file2 = null;
        try {
            file2 = File.createTempFile("vmw-pckg", ".tmp");
            this.writePackageToFile(directoryPackageInfo, file2);
            return file2;
        }
        catch (Exception exception) {
            String string = String.format("Could not download bundle %s from %s.", directoryPackageInfo.getId(), directoryPackageInfo.url);
            if (_logger.isDebugEnabled()) {
                _logger.warn((Object)string, (Throwable)exception);
            } else {
                _logger.warn((Object)string);
            }
            FileUtil.deleteDir((File)file);
            if (file2 != null && !file2.delete()) {
                _logger.error((Object)("Could not delete tempfile: " + file2));
            }
            return null;
        }
    }

    private void processRemotePlugin(DirectoryExtensionManagerProvider.DirectoryPackageInfo directoryPackageInfo, File file, File file2) throws IOException {
        Path path = Paths.get(file.getAbsolutePath(), "plugin.xml");
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Moving %s to %s.", file2, path));
        }
        Files.move(file2.toPath(), path, new CopyOption[0]);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("%s moved to %s.", file2, path));
        }
    }

    private void processLocalPlugin(DirectoryExtensionManagerProvider.DirectoryPackageInfo directoryPackageInfo, File file, File file2) throws IOException {
        this.performPluginSignatureCheckIfNecessary(directoryPackageInfo, file2);
        this.copyZipLocally(file2, file, directoryPackageInfo.getPackageRef());
        try (ZipFile zipFile = new ZipFile(file2);){
            ZipUtil.unzip((ZipFile)zipFile, (File)file);
        }
    }

    private void performPluginSignatureCheckIfNecessary(DirectoryExtensionManagerProvider.DirectoryPackageInfo directoryPackageInfo, File file) {
        if (this._pluginSignatureService == null) {
            return;
        }
        boolean bl = PropertyUtil.getBooleanProperty((ConfigurationService)this._configurationService, (String)"plugin.signature.check.enabled", (boolean)true);
        if (!bl) {
            _logger.debug((Object)("The plugin signature for " + directoryPackageInfo.getPackageRef() + " will not be verified since the plugin signature service is disabled"));
            return;
        }
        try (JarFile jarFile = new JarFile(file);){
            try {
                this._pluginSignatureService.verifySignature(jarFile);
                directoryPackageInfo.setSigningState(PluginPackageInfo.PluginPackageSigningState.SIGNED);
            }
            catch (PluginSignatureException pluginSignatureException) {
                _logger.warn((Object)("Detected an invalid signature for plugin: " + directoryPackageInfo.getPackageRef() + " - " + pluginSignatureException.toString()));
                directoryPackageInfo.setSigningState(PluginPackageInfo.PluginPackageSigningState.UNSIGNED);
            }
            catch (PluginSignatureGeneralException pluginSignatureGeneralException) {
                _logger.error((Object)("Unable to verify the signature for plugin: " + directoryPackageInfo.getPackageRef()), (Throwable)pluginSignatureGeneralException);
                directoryPackageInfo.setSigningState(PluginPackageInfo.PluginPackageSigningState.UNKNOWN);
            }
        }
        catch (IOException iOException) {
            _logger.error((Object)("Couldn't open plugin zip file when trying to verifythe signature of plugin " + directoryPackageInfo.getPackageRef()), (Throwable)iOException);
            directoryPackageInfo.setSigningState(PluginPackageInfo.PluginPackageSigningState.UNKNOWN);
        }
    }

    private void copyZipLocally(File file, File file2, IdVersionPair idVersionPair) {
        Path path = file.toPath();
        Path path2 = file2.toPath();
        String string = this.getPackageDirName(idVersionPair) + ".zip";
        Path path3 = Paths.get(path2.toString(), string);
        try {
            Files.copy(path, path3, new CopyOption[0]);
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to create a local copy of the zip for plugin " + idVersionPair.toString() + ". The plugin signing state of this plugin may be incorrect."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackageToFile(DirectoryExtensionManagerProvider.DirectoryPackageInfo directoryPackageInfo, File file) throws IOException, GeneralSecurityException {
        InputStream inputStream;
        block6: {
            inputStream = null;
            try {
                String string = new URL(directoryPackageInfo.url).getProtocol();
                if ("https".equals(string) && !StringUtil.isNullOrEmpty((String)directoryPackageInfo.certificate)) {
                    SSLBuilder sSLBuilder = new SSLBuilder();
                    sSLBuilder.sslConfigurationProvider(this._sslConfigurationProvider);
                    sSLBuilder.socketReadTimeout(this._socketReadTimeout.toIntMillis());
                    sSLBuilder.socketConnectionTimeout(this._socketConnectionTimeout.toIntMillis());
                    Object[] objectArray = directoryPackageInfo.getSslThumbprints();
                    if (!ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                        sSLBuilder.thumbprints((String[])objectArray);
                    }
                    HttpClient httpClient = sSLBuilder.buildHttpClientIgnoreErrors();
                    inputStream = httpClient.executeMethodResponseAsStream(directoryPackageInfo.url, null, null);
                    break block6;
                }
                Boolean bl = VcExtensionUtil.isHttpDownloadAllowed(this._configurationService);
                if (bl.booleanValue()) {
                    inputStream = new URL(directoryPackageInfo.url).openStream();
                    break block6;
                }
                _logger.error((Object)String.format("The plugin package %s download was blocked because the URL is not secure. To allow http URLs add allowHttp=true to webclient.properties.", directoryPackageInfo.getPackageRef()));
                inputStream = null;
            }
            catch (Throwable throwable) {
                StreamUtil.close(inputStream);
                throw throwable;
            }
            StreamUtil.close((Closeable)inputStream);
            return;
        }
        FileUtil.writeFile((InputStream)inputStream, (File)file);
        StreamUtil.close((Closeable)inputStream);
    }
}

