/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.lookup;

import com.vmware.sso.tokenmgmt.SsoDomainFinder;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.Optional;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import java.lang.invoke.MethodHandles;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookupServiceSsoDomainFinder
implements SsoDomainFinder {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final LookupService _lookupService;

    public LookupServiceSsoDomainFinder(@Nonnull LookupService lookupService) {
        Validate.notNull((Object)lookupService);
        this._lookupService = lookupService;
    }

    public Optional<SsoDomainFinder.SsoDomainData> findLocalDomain() {
        try {
            String string = LookupUtil.getLocalHostLduGuid(this._lookupService);
            ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
            if (BuildProperties.isH5Client()) {
                filter.setServiceType(LookupUtil.H5C);
            } else {
                filter.setServiceType(LookupUtil.NGC);
            }
            filter.setNodeId(string);
            filter.setSearchAllSsoDomains(Boolean.valueOf(true));
            ServiceRegistration.Info[] infoArray = this._lookupService.getServiceRegistrationInfos(filter);
            if (infoArray == null || infoArray.length == 0) {
                throw new IllegalStateException("Couldn't find a local " + (BuildProperties.isH5Client() ? "H5C" : "NGC") + " for node " + string);
            }
            ServiceRegistration.Info info = infoArray[0];
            Optional<SsoDomainFinder.SsoDomainData> optional = LookupUtil.getSsoDomainData(info);
            return optional;
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to retrieve the local SSO domain ID", (Throwable)exception);
            throw exception;
        }
    }
}

