/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.lookup;

import com.google.common.base.Preconditions;
import com.vmware.cis.services.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestRequest;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.http.Request;
import com.vmware.vise.util.http.CustomizedDefaultHttpRequestRetryHandler;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.internal.Config;
import java.net.URI;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public class LsLocalizationUtil {
    private static final Log _logger = LogFactory.getLog(LsLocalizationUtil.class);
    private static final int HEADER_CHUNK_SIZE = 1024;
    public static final long CM_CONNECTION_KEEP_ALIVE_PERIOD = 45000L;
    private static final ConnectionKeepAliveStrategy _keepAliveStrategy = new ConnectionKeepAliveStrategy(){

        public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
            return 45000L;
        }
    };
    private static final HttpRequestRetryHandler _retryHandler = new CustomizedDefaultHttpRequestRetryHandler(3);
    private static final RequestConfig _requestConfig = RequestConfig.custom().setExpectContinueEnabled(false).setSocketTimeout(Config.CM_CATALOG_MANAGER_SOCKET_TIMEOUT).setConnectTimeout(Config.CM_CATALOG_MANAGER_SOCKET_CONNECTION_TIMEOUT).setConnectionRequestTimeout(Config.CM_CATALOG_MANAGER_CONNECTION_REQUEST_TIMEOUT).setStaleConnectionCheckEnabled(true).build();

    static CloseableHttpClient createHttpClient(SSLConfigurationProvider sSLConfigurationProvider, KeyStore keyStore, char[] cArray, KeyStore keyStore2) {
        SSLContext sSLContext;
        SSLBuilder sSLBuilder;
        try {
            sSLBuilder = new SSLBuilder();
            if (sSLConfigurationProvider != null) {
                sSLBuilder.sslConfigurationProvider(sSLConfigurationProvider);
            }
            if (keyStore2 != null) {
                sSLBuilder.addTrustStore(keyStore2);
            }
            if (keyStore != null) {
                sSLBuilder.keyStore(keyStore, cArray);
            }
            sSLContext = sSLBuilder.buildSSLContext().getSslContext();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create SSLContext", exception);
        }
        sSLBuilder = HttpClients.custom().setSslcontext(sSLContext).setHostnameVerifier(SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER).setKeepAliveStrategy(_keepAliveStrategy).setRetryHandler(_retryHandler).setDefaultRequestConfig(_requestConfig).setMaxConnTotal(200).setMaxConnPerRoute(100).build();
        return sSLBuilder;
    }

    static HttpResponse executeRequest(HttpClient httpClient, URI uRI, SamlToken samlToken, PrivateKey privateKey) throws Exception {
        HttpResponse httpResponse;
        Preconditions.checkArgument((httpClient != null ? 1 : 0) != 0, (Object)"httpClient is null");
        Preconditions.checkArgument((!(samlToken != null ^ privateKey != null) ? 1 : 0) != 0, (Object)"Arguments authToken and privKey must be both null or not null.");
        HttpGet httpGet = new HttpGet(uRI);
        Request.Method method = Request.Method.GET;
        if (samlToken != null) {
            httpResponse = new SsoOverRestRequest(method, httpGet.getURI().toURL(), null);
            Map map = SsoOverRestHelper.calcAuthHeader((com.vmware.cis.common.sso.SsoOverRestRequest)httpResponse, (PrivateKey)privateKey, (SamlToken)samlToken, (int)1024);
            for (Map.Entry entry : map.entrySet()) {
                httpGet.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Sending request to URI: " + httpGet.getURI()));
            }
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Received response: " + httpResponse.getStatusLine()));
            }
            return httpResponse;
        }
        catch (Throwable throwable) {
            _logger.debug((Object)"HTTP request failed", throwable);
            throw throwable;
        }
    }
}

