/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.lookup.impl;

import com.vmware.af.VmAfClient;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.lookup.impl.LookupServiceSource;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AfdLSSource
extends LookupServiceSource {
    private static final Log _logger = LogFactory.getLog(AfdLSSource.class);
    private URI _serviceUri;
    private String _lduGuid;
    private String _hostId;
    private VmAfClient _vmAfClient;

    public AfdLSSource(KeystoreService keystoreService) {
        super(keystoreService);
    }

    @Override
    public synchronized URI getServiceUri() {
        if (this._serviceUri == null) {
            this._serviceUri = this.getLSUrl();
        }
        return this._serviceUri;
    }

    @Override
    public synchronized String getLocalHostLduGuid() {
        if (this._lduGuid == null) {
            this._lduGuid = this.getLDU();
        }
        return this._lduGuid;
    }

    @Override
    public synchronized String getLocalHostId() {
        if (this._hostId == null) {
            this._hostId = this.getHostGuid();
        }
        return this._hostId;
    }

    public static LookupServiceSource tryCreate(ConfigurationService configurationService, KeystoreService keystoreService) {
        AfdLSSource afdLSSource = null;
        boolean bl = PropertyUtil.getBooleanProperty((ConfigurationService)configurationService, (String)"afd.disabled", (boolean)false);
        if (!bl) {
            afdLSSource = new AfdLSSource(keystoreService);
        }
        return afdLSSource;
    }

    private URI getLSUrl() {
        String string = null;
        try {
            VmAfClient vmAfClient = this.getVmAfClient();
            string = vmAfClient.getLSLocation();
            _logger.info((Object)("LS location from afd: " + string));
            URI uRI = AfdLSSource.toServiceUri(string.trim());
            return uRI;
        }
        catch (Error error) {
            _logger.error((Object)"Error when talking to afd client", (Throwable)error);
            return null;
        }
    }

    private String getLDU() {
        String string = null;
        try {
            VmAfClient vmAfClient = this.getVmAfClient();
            string = vmAfClient.getLDU();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("LDU guid from afd: " + string));
            }
            return string;
        }
        catch (Error error) {
            _logger.error((Object)"Error when talking to afd client", (Throwable)error);
            return null;
        }
    }

    private String getHostGuid() {
        String string = null;
        try {
            VmAfClient vmAfClient = this.getVmAfClient();
            string = vmAfClient.getMachineID();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("host/machine guid from afd: " + string));
            }
            return string;
        }
        catch (Error error) {
            _logger.error((Object)"Error when talking to afd client", (Throwable)error);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VmAfClient getVmAfClient() {
        VmAfClient vmAfClient = this._vmAfClient;
        if (vmAfClient == null) {
            AfdLSSource afdLSSource = this;
            synchronized (afdLSSource) {
                vmAfClient = this._vmAfClient;
                if (vmAfClient == null) {
                    try {
                        String string = "localhost";
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("Creating vm afd client at " + string));
                        }
                        this._vmAfClient = vmAfClient = new VmAfClient(string);
                    }
                    catch (Error error) {
                        throw new RuntimeException("Error when creating VmAfClient.", error);
                    }
                }
            }
        }
        return vmAfClient;
    }
}

