/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.lookup.impl;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceContent;
import com.vmware.vim.binding.lookup.ServiceInstance;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.ServiceRegistrationForm;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.binding.lookup.fault.UnsupportedSiteFault;
import com.vmware.vim.binding.lookup.version.version2;
import com.vmware.vim.binding.lookup.version.version4_0;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.InvalidRequest;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.vim.ServiceNotResponding;
import com.vmware.vise.vim.VimServicesUtil;
import com.vmware.vise.vim.commons.vmomi.ClientWithSharedHttpConfig;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.commons.vmomi.OpIdAwareClientFactory;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.internal.Config;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupServiceConnectionException;
import com.vmware.vise.vim.lookup.impl.LookupServiceLocator;
import com.vmware.vise.vim.security.sso.impl.NgcSolutionUser;
import java.net.URI;
import java.security.KeyStore;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookupServiceImpl
implements LookupService {
    private LookupServiceHolder _lsHolder;
    @Nonnull
    private LookupServiceLocator _locator;
    private static final Log _logger = LogFactory.getLog(LookupServiceImpl.class);
    private static final Class<?> LS_VMODL_VERSION_CLASS = BuildProperties.isH5Client() || LookupServiceImpl.isEnforcedLookupServiceV1_5() ? version4_0.class : version2.class;
    private static final String POOL_NAME = "lookup-service-pool";
    private static final ExecutorService EXECUTOR = ThreadPoolFactory.newQueingCachedThreadPool((int)10, (ThreadFactory)new WorkerThreadFactory("lookup-service-pool"), (long)10L, (TimeUnit)TimeUnit.SECONDS, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);
    private static final AtomicReference<SharedHttpConfigPool> _legacyHttpConfigPoolRef = new AtomicReference();
    @Nonnull
    private final HttpConfigurationProvider _httpConfigProvider;

    @Deprecated
    public LookupServiceImpl(LookupServiceLocator lookupServiceLocator) {
        this(lookupServiceLocator, (HttpConfigurationProvider)LookupServiceImpl.getLegacyHttpConfigPool());
    }

    public LookupServiceImpl(LookupServiceLocator lookupServiceLocator, HttpConfigurationProvider httpConfigurationProvider) {
        Validate.notNull((Object)lookupServiceLocator);
        Validate.notNull((Object)httpConfigurationProvider);
        this._locator = lookupServiceLocator;
        this._httpConfigProvider = httpConfigurationProvider;
    }

    private static boolean isEnforcedLookupServiceV1_5() {
        boolean bl = PropertyUtil.getBooleanProperty((Properties)null, (String)"enforceLSv1.5", (boolean)false);
        return bl;
    }

    @VisibleForTesting
    static void setHttpConfigPool(@Nullable SharedHttpConfigPool sharedHttpConfigPool) {
        _legacyHttpConfigPoolRef.set(sharedHttpConfigPool);
    }

    public static SharedHttpConfigPool getLegacyHttpConfigPool() {
        SharedHttpConfigPool sharedHttpConfigPool;
        boolean bl;
        do {
            if ((sharedHttpConfigPool = _legacyHttpConfigPoolRef.get()) == null) continue;
            return sharedHttpConfigPool;
        } while (!(bl = _legacyHttpConfigPoolRef.compareAndSet(null, sharedHttpConfigPool = SharedHttpConfigPool.builder().maxConnections(Config.VMOMI_HTTP_CONNECTION_POOL_SIZE_LS).timeoutInMillis(Config.VMOMI_HTTP_SOCKET_TIMEOUT_LS).connectionTimeoutInMillis(Config.VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_LS).build())));
        return sharedHttpConfigPool;
    }

    @Override
    public String getServiceUrl() {
        URI uRI = this._locator.getServiceUri();
        if (uRI == null) {
            throw new NullPointerException(VimServicesUtil.getLocalizedString("ls.invalidServiceUrl", new String[0]));
        }
        return uRI.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ServiceRegistrationForm serviceRegistrationForm, SignInfo signInfo) throws UnsupportedSiteFault, ServiceFault, InvalidArgument, SecurityError {
        RequestContextImpl requestContextImpl;
        LookupServiceHolder lookupServiceHolder = LookupServiceImpl.createLookupService(this._locator, this._httpConfigProvider);
        com.vmware.vim.binding.lookup.LookupService lookupService = lookupServiceHolder.getLookupService();
        try {
            requestContextImpl = new RequestContextImpl();
            requestContextImpl.setSignInfo(signInfo);
            ((Stub)lookupService)._setRequestContext((RequestContext)requestContextImpl);
            lookupService.registerService(serviceRegistrationForm);
        }
        finally {
            requestContextImpl = lookupServiceHolder.getClient();
            try {
                requestContextImpl.shutdown();
            }
            catch (Exception exception) {
                _logger.error((Object)"Failed to shut down the client", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(String string, SignInfo signInfo) throws UnsupportedSiteFault, EntryNotFoundFault, ServiceFault, InvalidArgument, SecurityError {
        RequestContextImpl requestContextImpl;
        LookupServiceHolder lookupServiceHolder = LookupServiceImpl.createLookupService(this._locator, this._httpConfigProvider);
        com.vmware.vim.binding.lookup.LookupService lookupService = lookupServiceHolder.getLookupService();
        try {
            requestContextImpl = new RequestContextImpl();
            requestContextImpl.setSignInfo(signInfo);
            ((Stub)lookupService)._setRequestContext((RequestContext)requestContextImpl);
            lookupService.unregisterService(string);
        }
        finally {
            requestContextImpl = lookupServiceHolder.getClient();
            try {
                requestContextImpl.shutdown();
            }
            catch (Exception exception) {
                _logger.error((Object)"Failed to shut down the client", (Throwable)exception);
            }
        }
    }

    @Override
    public ServiceRegistration.Info[] getServiceRegistrationInfos(ServiceRegistration.Filter filter) {
        LookupServiceHolder lookupServiceHolder = this.getLookupServiceHolder();
        ServiceRegistration serviceRegistration = lookupServiceHolder.getServiceRegistration();
        ServiceRegistration.Info[] infoArray = serviceRegistration.list(filter);
        return infoArray;
    }

    @Override
    public Service[] find(SearchCriteria searchCriteria) throws ServiceFault, InvalidArgument, SecurityError, ServiceNotResponding {
        return this.find(searchCriteria, false);
    }

    @Override
    public Service findService(String string) throws ServiceFault, InvalidArgument, SecurityError, ServiceNotResponding {
        return this.getLookupServiceHolder().getLookupService().findService(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrustAnchor(ServiceRegistration.Filter filter, String[] stringArray) {
        SsoDomain ssoDomain;
        RequestContextImpl requestContextImpl = new RequestContextImpl();
        LookupServiceHolder lookupServiceHolder = LookupServiceImpl.createLookupService(this._locator, this._httpConfigProvider);
        ServiceRegistration serviceRegistration = lookupServiceHolder.getServiceRegistration();
        try {
            ssoDomain = SsoDomain.getLocal();
            NgcSolutionUser ngcSolutionUser = NgcSolutionUser.instance();
            SignInfoImpl signInfoImpl = new SignInfoImpl(ngcSolutionUser.getPrivateKey(), ngcSolutionUser.getLoggedInToken(ssoDomain));
            requestContextImpl.setSignInfo((SignInfo)signInfoImpl);
            ((Stub)serviceRegistration)._setRequestContext((RequestContext)requestContextImpl);
            int n = serviceRegistration.setTrustAnchor(filter, stringArray);
            _logger.info((Object)(n + " endpoints updated."));
        }
        finally {
            ssoDomain = lookupServiceHolder.getClient();
            try {
                ssoDomain.shutdown();
            }
            catch (Exception exception) {
                _logger.error((Object)"Failed to shut down the client", (Throwable)exception);
            }
        }
    }

    private Service[] find(SearchCriteria searchCriteria, boolean bl) throws ServiceFault, InvalidArgument, SecurityError, ServiceNotResponding {
        try {
            return this.getLookupServiceHolder().getLookupService().find(searchCriteria);
        }
        catch (TransportProtocolException transportProtocolException) {
            if (!bl) {
                _logger.warn((Object)"TransportProtocolException detected, we will retry the call.", (Throwable)transportProtocolException);
                return this.find(searchCriteria, true);
            }
            throw new ServiceNotResponding(this.getServiceUrl());
        }
    }

    @Deprecated
    public static com.vmware.vim.binding.lookup.LookupService createLookupService(URI uRI, String string) {
        return LookupServiceImpl.createLookupService(uRI, null, string, (HttpConfigurationProvider)LookupServiceImpl.getLegacyHttpConfigPool()).getLookupService();
    }

    public static com.vmware.vim.binding.lookup.LookupService createLookupService(URI uRI, String string, HttpConfigurationProvider httpConfigurationProvider) {
        return LookupServiceImpl.createLookupService(uRI, null, string, httpConfigurationProvider).getLookupService();
    }

    @Override
    public ServiceRegistration.Info find(String string) throws EntryNotFoundFault {
        return this.getLookupServiceHolder().getServiceRegistration().get(string);
    }

    @Override
    public LookupServiceLocator getLocator() {
        return this._locator;
    }

    private synchronized LookupServiceHolder getLookupServiceHolder() {
        if (this.isLookupServiceCreationRequired()) {
            this.cleanup();
            this._lsHolder = LookupServiceImpl.createLookupService(this._locator, this._httpConfigProvider);
        }
        return this._lsHolder;
    }

    void cleanup() {
        if (this._lsHolder == null) {
            return;
        }
        Client client = this._lsHolder.getClient();
        if (client != null) {
            client.shutdown();
        }
        this._lsHolder = null;
    }

    private static LookupServiceHolder createLookupService(LookupServiceLocator lookupServiceLocator, HttpConfigurationProvider httpConfigurationProvider) {
        return LookupServiceImpl.createLookupService(lookupServiceLocator.getServiceUri(), lookupServiceLocator.getKeyStore(), lookupServiceLocator.getThumbprint(), httpConfigurationProvider);
    }

    private static LookupServiceHolder createLookupService(URI uRI, KeyStore keyStore, String string, HttpConfigurationProvider httpConfigurationProvider) {
        if (uRI == null) {
            throw new LookupServiceConnectionException(VimServicesUtil.getLocalizedString("ls.notConfigured", new String[0]));
        }
        ClassLoader classLoader = LookupServiceImpl.class.getClassLoader();
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        LookupServiceHolder lookupServiceHolder = null;
        try {
            String string2;
            ServiceContent serviceContent;
            Thread.currentThread().setContextClassLoader(classLoader);
            ManagedObjectReference managedObjectReference = LookupServiceImpl.createMoRef(ServiceInstance.class, ServiceInstance.class.getSimpleName());
            ManagedObjectReference managedObjectReference2 = LookupServiceImpl.createMoRef(ServiceRegistration.class, ServiceRegistration.class.getSimpleName());
            String string3 = uRI.toString();
            HttpConfiguration httpConfiguration = httpConfigurationProvider.getHttpConfig(string3, keyStore, string);
            HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
            httpClientConfiguration.setExecutor((Executor)EXECUTOR);
            httpClientConfiguration.setHttpConfiguration(httpConfiguration);
            Client client = OpIdAwareClientFactory.createClient((URI)uRI, LS_VMODL_VERSION_CLASS, (ClientConfiguration)httpClientConfiguration);
            client = new ClientWithSharedHttpConfig(client, httpConfigurationProvider);
            ServiceInstance serviceInstance = (ServiceInstance)VmomiClientHelper.createStub((Client)client, ServiceInstance.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)LookupServiceImpl.class.getClassLoader());
            try {
                serviceContent = serviceInstance.retrieveServiceContent();
            }
            catch (InvalidRequest invalidRequest) {
                string2 = invalidRequest.getMessage();
                if (string2 != null && string2.contains("version")) {
                    String string4 = VmomiClientHelper.getVersionIdOfVmodlVersion(LS_VMODL_VERSION_CLASS);
                    Class<version2> clazz = version2.class;
                    if (string2.contains(string4) && !LS_VMODL_VERSION_CLASS.equals(clazz)) {
                        _logger.error((Object)("Failed to retrieve the LS service content through version " + LS_VMODL_VERSION_CLASS + " with ID " + string4 + ". Will retry with version " + clazz.getName() + " with ID " + VmomiClientHelper.getVersionIdOfVmodlVersion(clazz)));
                        try {
                            client.shutdown();
                        }
                        catch (Exception exception) {
                            _logger.error((Object)"Failed to shut down the original client", (Throwable)exception);
                        }
                        client = OpIdAwareClientFactory.createClient((URI)uRI, clazz, (ClientConfiguration)httpClientConfiguration);
                        client = new ClientWithSharedHttpConfig(client, httpConfigurationProvider);
                        serviceInstance = (ServiceInstance)VmomiClientHelper.createStub((Client)client, ServiceInstance.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)LookupServiceImpl.class.getClassLoader());
                        serviceContent = serviceInstance.retrieveServiceContent();
                    }
                    throw invalidRequest;
                }
                throw invalidRequest;
            }
            com.vmware.vim.binding.lookup.LookupService lookupService = (com.vmware.vim.binding.lookup.LookupService)VmomiClientHelper.createStub((Client)client, com.vmware.vim.binding.lookup.LookupService.class, (ManagedObjectReference)serviceContent.getLookupService(), (ClassLoader)LookupServiceImpl.class.getClassLoader());
            string2 = (ServiceRegistration)VmomiClientHelper.createStub((Client)client, ServiceRegistration.class, (ManagedObjectReference)managedObjectReference2, (ClassLoader)LookupServiceImpl.class.getClassLoader());
            lookupServiceHolder = new LookupServiceHolder(uRI, client, lookupService, (ServiceRegistration)string2);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (exception instanceof SslException || exception instanceof InternalException) {
                throwable = exception.getCause();
            }
            _logger.error((Object)"Error when creating lookup service", throwable);
            String string5 = String.format(LookupServiceConnectionException.CONNECTION_ERROR, uRI.toString());
            if (throwable instanceof UnmarshallException) {
                string5 = String.format(LookupServiceConnectionException.VMODL_MISMATCH_ERROR, uRI.toString());
            } else if (throwable instanceof CertificateValidationException) {
                string5 = String.format(LookupServiceConnectionException.SSL_ERROR, uRI.toString());
            }
            throw new LookupServiceConnectionException(string5, throwable);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        return lookupServiceHolder;
    }

    private static ManagedObjectReference createMoRef(Class<?> clazz, String string) {
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(clazz);
        String string2 = vmodlType.getWsdlName();
        ManagedObjectReference managedObjectReference = new ManagedObjectReference(string2, string);
        return managedObjectReference;
    }

    private boolean isLookupServiceCreationRequired() {
        return this._lsHolder == null || !this._lsHolder.getLSUri().equals(this._locator.getServiceUri());
    }

    private static class LookupServiceHolder {
        private final Client _client;
        private final URI _lsUri;
        private final com.vmware.vim.binding.lookup.LookupService _lookupService;
        private final ServiceRegistration _serviceRegistration;

        public LookupServiceHolder(URI uRI, Client client, com.vmware.vim.binding.lookup.LookupService lookupService, ServiceRegistration serviceRegistration) {
            this._client = client;
            this._lsUri = uRI;
            this._lookupService = lookupService;
            this._serviceRegistration = serviceRegistration;
        }

        public Client getClient() {
            return this._client;
        }

        public URI getLSUri() {
            return this._lsUri;
        }

        public com.vmware.vim.binding.lookup.LookupService getLookupService() {
            return this._lookupService;
        }

        public ServiceRegistration getServiceRegistration() {
            return this._serviceRegistration;
        }
    }
}

