/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.lookup.impl;

import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LsFactory;
import com.vmware.vise.vim.lookup.impl.LookupServiceImpl;
import com.vmware.vise.vim.lookup.impl.LookupServiceLocator;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LsFactoryImpl
implements LsFactory,
UserSessionListener {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final LookupServiceLocator _lsLocator;
    @Nullable
    private final HttpConfigurationProvider _httpConfigProvider;
    private static final String LS_SESSION_KEY = "LookupService";
    private static final String LS_SYNC_OBJECT = "LsSyncObject";

    @Deprecated
    public LsFactoryImpl(LookupServiceLocator lookupServiceLocator) {
        this(false, (LookupServiceLocator)ValidationUtil.notNull((Object)lookupServiceLocator, (String)"lsLocator is null"), null);
    }

    public LsFactoryImpl(@Nonnull LookupServiceLocator lookupServiceLocator, @Nonnull HttpConfigurationProvider httpConfigurationProvider) {
        this(true, (LookupServiceLocator)ValidationUtil.notNull((Object)lookupServiceLocator, (String)"lsLocator is null"), (HttpConfigurationProvider)ValidationUtil.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null"));
    }

    private LsFactoryImpl(boolean bl, LookupServiceLocator lookupServiceLocator, HttpConfigurationProvider httpConfigurationProvider) {
        this._lsLocator = lookupServiceLocator;
        this._httpConfigProvider = httpConfigurationProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupService getLookupService() {
        Object object;
        LookupService lookupService = (LookupService)SessionUtil.getData((String)LS_SESSION_KEY);
        if (lookupService != null) {
            return lookupService;
        }
        HttpSession httpSession = SessionUtil.getHttpSession((boolean)false);
        if (httpSession == null) {
            _logger.warn((Object)"There's no HTTP session. Creating an instance on the fly");
            return this.createLookupServiceImpl();
        }
        Object object2 = object = SessionUtil.getSyncObject((String)LS_SYNC_OBJECT, (HttpSession)httpSession);
        synchronized (object2) {
            lookupService = (LookupService)SessionUtil.getData((String)LS_SESSION_KEY);
            if (lookupService != null) {
                return lookupService;
            }
            lookupService = this.createLookupServiceImpl();
            SessionUtil.setData((String)LS_SESSION_KEY, (Object)lookupService);
            _logger.info((Object)("Stored a " + lookupService.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(lookupService)) + " into the session"));
            return lookupService;
        }
    }

    private LookupServiceImpl createLookupServiceImpl() {
        if (this._httpConfigProvider != null) {
            return new LookupServiceImpl(this._lsLocator, this._httpConfigProvider);
        }
        return new LookupServiceImpl(this._lsLocator);
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        LookupServiceImpl lookupServiceImpl = (LookupServiceImpl)SessionUtil.getData((String)LS_SESSION_KEY, (HttpSession)httpSessionEvent.getSession());
        if (lookupServiceImpl != null) {
            lookupServiceImpl.cleanup();
        }
    }
}

