/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenAcquisitionCallback;
import com.vmware.sso.tokenmgmt.TokenAcquisitionResult;
import com.vmware.sso.tokenmgmt.TokenEx;
import com.vmware.sso.tokenmgmt.TokenException;
import com.vmware.sso.tokenmgmt.TokenFutureAndIssuerDomain;
import com.vmware.sso.tokenmgmt.TokenManager;
import com.vmware.vim.sso.client.ConfirmationType;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.Timeout;
import com.vmware.vise.util.annotations.VisibleForTesting;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.util.concurrent.CountDownLatchEx;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.internal.Config;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncTokenManager
implements TokenManager {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final long TOKEN_LIFETIME_CLOCK_TOLERANCE = TimeUnit.MINUTES.toMillis(1L);
    private static final long TOKEN_ACQUISITION_THRESHOLD_NANOS = TimeUnit.SECONDS.toNanos(5L);
    @Nonnull
    private final SsoService _ssoService;
    @Nonnull
    private final ListeningExecutorService _executor;
    private final ReadWriteLock _tokenAccessLock = new ReentrantReadWriteLock();
    @Nonnull
    private final ConcurrentMap<SsoDomain, TokenFutureAndIssuerDomain> _tokenFuturesBySsoDomain = new ConcurrentHashMap<SsoDomain, TokenFutureAndIssuerDomain>();

    public AsyncTokenManager(@Nonnull SsoService ssoService, @Nonnull ExecutorService executorService) {
        Validate.notNull((Object)ssoService);
        Validate.notNull((Object)executorService);
        this._ssoService = ssoService;
        ListeningExecutorService listeningExecutorService = executorService instanceof ListeningExecutorService ? (ListeningExecutorService)executorService : MoreExecutors.listeningDecorator((ExecutorService)executorService);
        this._executor = listeningExecutorService;
    }

    public TokenEx getTokenForSsoDomain(@Nonnull SsoDomain ssoDomain) throws TokenException {
        Validate.notNull((Object)ssoDomain);
        Future future = (Future)this._tokenFuturesBySsoDomain.get(ssoDomain);
        SsoServerInfo ssoServerInfo = null;
        try {
            TokenEx tokenEx;
            if (future == null) {
                Map<SsoDomain, SsoServerInfo> map;
                if (!ssoDomain.isLocal() && !(ssoServerInfo = SsoUtil.getSsoServerInfo(map = this._ssoService.getServerInfos(), ssoDomain)).stsHasVcTrustsCapability()) {
                    return this.getTokenForSsoDomain(SsoDomain.getLocal());
                }
                throw new TokenException("There's no available token for domain " + ssoDomain);
            }
            if (Config.DEFAULT_TOKEN_PROVIDER_TOKEN_ACQUISITION_TIMEOUT == Timeout.INFINITE) {
                tokenEx = (TokenEx)future.get();
            } else {
                long l = Config.DEFAULT_TOKEN_PROVIDER_TOKEN_ACQUISITION_TIMEOUT.toMillis();
                tokenEx = (TokenEx)future.get(l, TimeUnit.MILLISECONDS);
            }
            return tokenEx;
        }
        catch (Exception exception) {
            Throwable throwable = ExceptionUtil.unwrap((Throwable)exception);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to retrieve token for SSO domain ").append(ssoDomain);
            if (ssoServerInfo != null) {
                stringBuilder.append(" from STS server ").append(ssoServerInfo.getStsUrl());
            }
            throw new TokenException(stringBuilder.toString(), throwable);
        }
    }

    @Nonnull
    public Collection<TokenAcquisitionResult> getAllTokens() {
        HashMap<SsoDomain, TokenFutureAndIssuerDomain> hashMap;
        this._tokenAccessLock.readLock().lock();
        try {
            hashMap = new HashMap<SsoDomain, TokenFutureAndIssuerDomain>(this._tokenFuturesBySsoDomain);
        }
        finally {
            this._tokenAccessLock.readLock().unlock();
        }
        Timeout timeout = Config.DEFAULT_TOKEN_PROVIDER_TOKEN_ACQUISITION_TIMEOUT;
        long l = timeout != Timeout.INFINITE ? timeout.toMillis() : -1L;
        try {
            Map map = BlockingUtil.get(hashMap, (long)l, (TimeUnit)TimeUnit.MILLISECONDS);
            ArrayList<TokenAcquisitionResult> arrayList = new ArrayList<TokenAcquisitionResult>();
            for (Map.Entry entry : map.entrySet()) {
                SsoDomain ssoDomain = (SsoDomain)entry.getKey();
                BlockingUtil.FutureResult futureResult = (BlockingUtil.FutureResult)entry.getValue();
                TokenEx tokenEx = (TokenEx)futureResult.getResult().orElse(null);
                Exception exception = (Exception)futureResult.getException().orElse(null);
                Throwable throwable = ExceptionUtil.unwrap((Throwable)exception);
                if (throwable != null && !(throwable instanceof TokenException)) {
                    throwable = new TokenException(throwable);
                }
                arrayList.add(new TokenAcquisitionResult(ssoDomain, tokenEx, throwable));
            }
            if (arrayList.isEmpty()) {
                return Collections.emptyList();
            }
            return arrayList;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while getting tokens", interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireAllTokensByToken(@Nonnull SsoDomain ssoDomain, @Nonnull SamlToken samlToken, @Nonnull TokenSpec tokenSpec, @Nullable SsoDomain ssoDomain2, @Nullable TokenAcquisitionCallback tokenAcquisitionCallback, @Nullable Executor executor) throws TokenException {
        Map<SsoDomain, SsoServerInfo> map;
        SamlToken samlToken2;
        Validate.notNull((Object)ssoDomain);
        Validate.notNull((Object)samlToken);
        Validate.notNull((Object)tokenSpec);
        TokenSpec.DelegationSpec delegationSpec = tokenSpec.getDelegationSpec();
        SamlToken samlToken3 = samlToken2 = delegationSpec != null ? delegationSpec.getActAsToken() : null;
        if (samlToken2 != null && ssoDomain2 == null) {
            throw new IllegalArgumentException("When the tokenSpec contains an Act-As token, the ssoDomainOfActAsToken argument should have a non-null value");
        }
        if (tokenAcquisitionCallback != null && executor == null) {
            throw new IllegalArgumentException("When the callback is not null, an executor must be specified");
        }
        try {
            map = this._ssoService.getServerInfos();
        }
        catch (Exception exception) {
            throw new TokenException("Failed to retrieve SSO server infos", (Throwable)exception);
        }
        if (map.isEmpty()) {
            throw new TokenException("Couldn't find any SSO servers");
        }
        int n = map.size();
        CountDownLatchEx countDownLatchEx = new CountDownLatchEx(new CountDownLatch(n));
        this._tokenAccessLock.writeLock().lock();
        try {
            ListenableFuture listenableFuture;
            Callable<SamlToken> callable;
            long l;
            long l2;
            long l3;
            this.cancelAndRemoveAllTokenAcquisitionTasks();
            SsoDomain ssoDomain3 = SsoDomain.getLocal();
            SsoServerInfo ssoServerInfo = map.get(ssoDomain3);
            if (ssoServerInfo == null) {
                throw new TokenException("Couldn't find any local SSO servers");
            }
            boolean bl = true;
            if (samlToken2 != null && ssoDomain2.isLocal() && samlToken2.getConfirmationType() == ConfirmationType.HOLDER_OF_KEY && samlToken2.getSubject().equals((Object)samlToken.getSubject()) && (l3 = (l2 = samlToken2.getExpirationTime().getTime()) - System.currentTimeMillis()) >= (l = TimeUnit.SECONDS.toMillis(tokenSpec.getTokenLifetime())) - TOKEN_LIFETIME_CLOCK_TOLERANCE) {
                bl = false;
            }
            if (bl) {
                callable = new TokenAcquisitionTask(this._ssoService, ssoServerInfo, ssoDomain, samlToken, tokenSpec);
            } else {
                _logger.info((Object)"The given Act-As token is good enough and we don't need to acquire another local token. We'll reuse the Act-As token.");
                callable = new DummyTokenAcquisitionTask(samlToken2);
            }
            SessionUtil.ThreadContext threadContext = SessionUtil.getThreadContext((boolean)true);
            callable = new ExecutorUtil.ThreadContextPropagatingTask((Callable)callable, threadContext);
            try {
                listenableFuture = this._executor.submit((Callable)callable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                throw new TokenException("Failed to submit a task to acquire a local token", (Throwable)rejectedExecutionException);
            }
            this._tokenFuturesBySsoDomain.put(ssoDomain3, new TokenFutureAndIssuerDomain(ssoDomain3, (Future)listenableFuture));
            if (tokenAcquisitionCallback != null) {
                TokenAcquisitionListener tokenAcquisitionListener = new TokenAcquisitionListener((Future<SamlToken>)listenableFuture, ssoServerInfo, ssoDomain3, countDownLatchEx, tokenAcquisitionCallback);
                listenableFuture.addListener((Runnable)tokenAcquisitionListener, executor);
            }
            for (Map.Entry<SsoDomain, SsoServerInfo> entry : map.entrySet()) {
                SsoServerInfo ssoServerInfo2;
                SsoDomain ssoDomain4;
                ListenableFuture listenableFuture2;
                SsoDomain ssoDomain5 = entry.getKey();
                if (ssoDomain5.isLocal()) continue;
                SsoDomain ssoDomain6 = ssoDomain5;
                SsoServerInfo ssoServerInfo3 = entry.getValue();
                if (ssoServerInfo3.stsHasVcTrustsCapability()) {
                    listenableFuture2 = Futures.transform((ListenableFuture)listenableFuture, (Function)new DerivedTokenAcquisitionHandler(this._ssoService, ssoServerInfo3, ssoDomain3, tokenSpec, threadContext), (Executor)this._executor);
                    ssoDomain4 = ssoServerInfo3.getSsoDomain();
                    ssoServerInfo2 = ssoServerInfo3;
                } else {
                    listenableFuture2 = listenableFuture;
                    ssoDomain4 = ssoDomain3;
                    ssoServerInfo2 = ssoServerInfo;
                    _logger.warn((Object)("SSO domain " + ssoDomain6 + " doesn't have the '" + "VC-trusts" + "' capability, so the local token will be used for this domain"));
                }
                this._tokenFuturesBySsoDomain.put(ssoDomain6, new TokenFutureAndIssuerDomain(ssoDomain4, (Future)listenableFuture2));
                if (tokenAcquisitionCallback == null) continue;
                TokenAcquisitionListener tokenAcquisitionListener = new TokenAcquisitionListener((Future<SamlToken>)listenableFuture2, ssoServerInfo2, ssoDomain5, countDownLatchEx, tokenAcquisitionCallback);
                listenableFuture2.addListener((Runnable)tokenAcquisitionListener, executor);
            }
        }
        finally {
            this._tokenAccessLock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    boolean isTokenAcquisitionDoneFor(SsoDomain ssoDomain) {
        Future future = (Future)this._tokenFuturesBySsoDomain.get(ssoDomain);
        return future != null && future.isDone();
    }

    @GuardedBy(value="_acquireAllTokensLock.writeLock()")
    private void cancelAndRemoveAllTokenAcquisitionTasks() {
        for (Map.Entry entry : this._tokenFuturesBySsoDomain.entrySet()) {
            Future future = (Future)entry.getValue();
            future.cancel(true);
        }
        this._tokenFuturesBySsoDomain.clear();
    }

    public void setTokenForSsoDomain(@Nonnull SsoDomain ssoDomain, @Nonnull SsoDomain ssoDomain2, @Nonnull SamlToken samlToken) {
        Validate.notNull((Object)ssoDomain);
        Validate.notNull((Object)ssoDomain2);
        Validate.notNull((Object)samlToken);
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)samlToken);
        this.setTokenForSsoDomain(ssoDomain, ssoDomain2, (Future<SamlToken>)listenableFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTokenForSsoDomain(@Nonnull SsoDomain ssoDomain, @Nonnull SsoDomain ssoDomain2, @Nonnull Future<SamlToken> future) {
        Validate.notNull((Object)ssoDomain);
        Validate.notNull((Object)ssoDomain2);
        Validate.notNull(future);
        this._tokenAccessLock.writeLock().lock();
        try {
            StringBuilder stringBuilder;
            TokenFutureAndIssuerDomain tokenFutureAndIssuerDomain = (TokenFutureAndIssuerDomain)this._tokenFuturesBySsoDomain.get(ssoDomain);
            SsoDomain ssoDomain3 = null;
            if (tokenFutureAndIssuerDomain != null) {
                ssoDomain3 = tokenFutureAndIssuerDomain.getIssuerDomain();
            }
            this._tokenFuturesBySsoDomain.put(ssoDomain, new TokenFutureAndIssuerDomain(ssoDomain2, future));
            HashSet<SsoDomain> hashSet = null;
            if (ssoDomain.equals((Object)ssoDomain3) && ssoDomain.equals((Object)ssoDomain2)) {
                stringBuilder = null;
                for (Map.Entry entry : this._tokenFuturesBySsoDomain.entrySet()) {
                    TokenFutureAndIssuerDomain tokenFutureAndIssuerDomain2 = (TokenFutureAndIssuerDomain)entry.getValue();
                    if (tokenFutureAndIssuerDomain2 == null) continue;
                    SsoDomain ssoDomain4 = (SsoDomain)entry.getKey();
                    SsoDomain ssoDomain5 = tokenFutureAndIssuerDomain2.getIssuerDomain();
                    if (ssoDomain4.equals((Object)ssoDomain) || !ssoDomain5.equals((Object)ssoDomain2)) continue;
                    if (stringBuilder == null) {
                        stringBuilder = new TokenFutureAndIssuerDomain(ssoDomain5, future);
                    }
                    this._tokenFuturesBySsoDomain.put(ssoDomain4, (TokenFutureAndIssuerDomain)stringBuilder);
                    if (hashSet == null) {
                        hashSet = new HashSet<SsoDomain>();
                    }
                    hashSet.add(ssoDomain4);
                }
            }
            stringBuilder = new StringBuilder(100);
            stringBuilder.append("Updated the token of domain ").append(ssoDomain);
            if (hashSet != null) {
                stringBuilder.append(". Other domains, which used the previous token, were also updated: ").append(hashSet);
            }
            if (future.isDone()) {
                try {
                    SamlToken samlToken = future.get();
                    stringBuilder.append(". Token's expiration time: ").append(samlToken.getExpirationTime());
                }
                catch (InterruptedException | ExecutionException exception) {
                    stringBuilder.append(". Token future resulted in error: ").append(exception.toString()).append('\n').append(ExceptionUtil.getStackTrace((Throwable)exception));
                }
            }
            _logger.info((Object)stringBuilder.toString());
        }
        finally {
            this._tokenAccessLock.writeLock().unlock();
        }
    }

    private class DerivedTokenAcquisitionHandler
    implements Function<SamlToken, SamlToken> {
        private final SsoService _ssoService;
        private final SsoServerInfo _stsServerFromWhichToAcquireDerivedToken;
        private final SsoDomain _ssoDomainOfAcquiredToken;
        private final TokenSpec _tokenSpec;
        private final SessionUtil.ThreadContext _threadContext;

        DerivedTokenAcquisitionHandler(@Nonnull SsoService ssoService, @Nonnull SsoServerInfo ssoServerInfo, @Nonnull SsoDomain ssoDomain, @Nonnull TokenSpec tokenSpec, SessionUtil.ThreadContext threadContext) {
            this._ssoService = ssoService;
            this._stsServerFromWhichToAcquireDerivedToken = ssoServerInfo;
            this._ssoDomainOfAcquiredToken = ssoDomain;
            this._tokenSpec = tokenSpec;
            this._threadContext = threadContext;
        }

        public SamlToken apply(SamlToken samlToken) {
            TokenAcquisitionTask tokenAcquisitionTask = new TokenAcquisitionTask(this._ssoService, this._stsServerFromWhichToAcquireDerivedToken, this._ssoDomainOfAcquiredToken, samlToken, this._tokenSpec);
            tokenAcquisitionTask = new ExecutorUtil.ThreadContextPropagatingTask((Callable)tokenAcquisitionTask, this._threadContext);
            try {
                SamlToken samlToken2 = (SamlToken)tokenAcquisitionTask.call();
                return samlToken2;
            }
            catch (Exception exception) {
                throw new TokenException("Failed to acquire token for domain " + this._stsServerFromWhichToAcquireDerivedToken.getSsoDomain(), (Throwable)exception);
            }
        }
    }

    private class TokenAcquisitionListener
    implements Runnable {
        @Nonnull
        private final Future<SamlToken> _future;
        @Nonnull
        private final SsoServerInfo _ssoServerInfoOfTokenIssuer;
        @Nonnull
        private final SsoDomain _domainWhichWillUseTheToken;
        @Nonnull
        private final CountDownLatchEx _allTokensAcquiredLatch;
        @Nonnull
        private final TokenAcquisitionCallback _callback;

        TokenAcquisitionListener(@Nonnull Future<SamlToken> future, @Nonnull SsoServerInfo ssoServerInfo, @Nonnull SsoDomain ssoDomain, @Nonnull CountDownLatchEx countDownLatchEx, TokenAcquisitionCallback tokenAcquisitionCallback) {
            assert (future != null);
            assert (ssoServerInfo != null);
            assert (ssoDomain != null);
            assert (countDownLatchEx != null);
            assert (tokenAcquisitionCallback != null);
            this._future = future;
            this._ssoServerInfoOfTokenIssuer = ssoServerInfo;
            this._domainWhichWillUseTheToken = ssoDomain;
            this._allTokensAcquiredLatch = countDownLatchEx;
            this._callback = tokenAcquisitionCallback;
        }

        @Override
        public void run() {
            try {
                SamlToken samlToken = this._future.get();
                this.onSuccess(samlToken);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = ExceptionUtil.unwrap((Throwable)throwable);
                this.onFailure(throwable2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onSuccess(SamlToken samlToken) {
            try {
                String string = this._ssoServerInfoOfTokenIssuer.getStsUrl();
                SsoDomain ssoDomain = this._ssoServerInfoOfTokenIssuer.getSsoDomain();
                this._callback.tokenAcquired(string, this._domainWhichWillUseTheToken, new TokenEx(samlToken, ssoDomain));
            }
            catch (Exception exception) {
                this.logError("callback.tokenAcquired failed", exception);
            }
            finally {
                this.handleAllTokenAcquisitionTasksCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onFailure(Throwable throwable) {
            try {
                String string = this._ssoServerInfoOfTokenIssuer.getStsUrl();
                SsoDomain ssoDomain = this._ssoServerInfoOfTokenIssuer.getSsoDomain();
                this._callback.tokenAcquisitionFailed(string, ssoDomain, this._domainWhichWillUseTheToken, throwable);
            }
            catch (Exception exception) {
                this.logError("callback.tokenAcquisitionFailed failed", exception);
            }
            finally {
                this.handleAllTokenAcquisitionTasksCompleted();
            }
        }

        private void handleAllTokenAcquisitionTasksCompleted() {
            boolean bl = this._allTokensAcquiredLatch.countDownAndCheckIfZeroIsReachedForTheFirstTime();
            if (bl) {
                ArrayList<TokenAcquisitionResult> arrayList = new ArrayList<TokenAcquisitionResult>(3);
                for (Map.Entry entry : AsyncTokenManager.this._tokenFuturesBySsoDomain.entrySet()) {
                    SsoDomain ssoDomain = (SsoDomain)entry.getKey();
                    Future future = (Future)entry.getValue();
                    try {
                        TokenEx tokenEx = (TokenEx)future.get();
                        arrayList.add(new TokenAcquisitionResult(ssoDomain, tokenEx, null));
                    }
                    catch (Exception exception) {
                        Throwable throwable = ExceptionUtil.unwrap((Throwable)exception);
                        arrayList.add(new TokenAcquisitionResult(ssoDomain, null, throwable));
                    }
                }
                try {
                    this._callback.allTokensAcquired(arrayList);
                }
                catch (Exception exception) {
                    _logger.error((Object)"callback.allTokensAcquired failed", (Throwable)exception);
                }
            }
        }

        private void logError(String string, Throwable throwable) {
            _logger.error((Object)(string + " for SSO domain " + this._domainWhichWillUseTheToken + " and SSO server " + this._ssoServerInfoOfTokenIssuer.getStsUrl() + " from SSO domain " + this._ssoServerInfoOfTokenIssuer.getSsoDomain()), throwable);
        }

        public String toString() {
            return super.toString() + ":" + this._ssoServerInfoOfTokenIssuer.getSsoDomain() + ":" + this._ssoServerInfoOfTokenIssuer.getStsUrl() + ":" + this._domainWhichWillUseTheToken;
        }
    }

    private class DummyTokenAcquisitionTask
    implements Callable<SamlToken> {
        private final SamlToken _token;

        DummyTokenAcquisitionTask(SamlToken samlToken) {
            this._token = samlToken;
        }

        @Override
        public SamlToken call() throws SsoServiceException {
            return this._token;
        }
    }

    private class TokenAcquisitionTask
    implements Callable<SamlToken> {
        private final SsoService _ssoService;
        private final SsoServerInfo _ssoServerInfo;
        private final SsoDomain _authorizationTokenSsoDomain;
        private final SamlToken _authorizationToken;
        private final TokenSpec _tokenSpec;

        TokenAcquisitionTask(@Nonnull SsoService ssoService, @Nonnull SsoServerInfo ssoServerInfo, @Nonnull SsoDomain ssoDomain, @Nonnull SamlToken samlToken, TokenSpec tokenSpec) {
            assert (ssoService != null);
            this._ssoService = ssoService;
            this._ssoServerInfo = ssoServerInfo;
            this._authorizationTokenSsoDomain = ssoDomain;
            this._authorizationToken = samlToken;
            this._tokenSpec = tokenSpec;
        }

        @Override
        public SamlToken call() throws SsoServiceException {
            SsoDomain ssoDomain = this._ssoServerInfo.getSsoDomain();
            _logger.info((Object)("Acquiring token from token for SSO domain " + ssoDomain + " from STS server " + this._ssoServerInfo.getStsUrl()));
            long l = System.nanoTime();
            long l2 = -1L;
            try {
                SamlToken samlToken = this._ssoService.acquireTokenByToken(ssoDomain, this._authorizationTokenSsoDomain, this._authorizationToken, this._tokenSpec);
                l2 = System.nanoTime();
                _logger.info((Object)("Acquired token. Expiration time: " + samlToken.getExpirationTime()));
                SamlToken samlToken2 = samlToken;
                return samlToken2;
            }
            catch (Exception exception) {
                l2 = System.nanoTime();
                String string = "Token acquisition failed for SSO domain " + ssoDomain + " from STS server " + this._ssoServerInfo.getStsUrl();
                _logger.error((Object)string, (Throwable)exception);
                throw new TokenException(string, (Throwable)exception);
            }
            finally {
                long l3 = l2 - l;
                if (l3 > TOKEN_ACQUISITION_THRESHOLD_NANOS) {
                    _logger.warn((Object)("Token acquisition took too long: " + TimeUnit.NANOSECONDS.toMillis(l3)));
                }
            }
        }

        public String toString() {
            SsoDomain ssoDomain = this._ssoServerInfo.getSsoDomain();
            String string = this._ssoServerInfo.getStsUrl();
            return "Token acquisition task for domain " + ssoDomain + ", STS server " + string;
        }
    }
}

