/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import com.vmware.vise.vim.internal.Config;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vise.vim.security.sso.impl.NgcSolutionUser;
import com.vmware.vise.vim.security.sso.impl.SsoAdminServiceImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;

public final class SsoUtil {
    private static final Pattern NETBIOS_PATTERN = Pattern.compile("(.*)\\\\(.+)");
    private static final Pattern UPN_PATTERN = Pattern.compile("(.+)@(.*)");
    private static final AtomicReference<SharedHttpConfigPool> _legacyHttpConfigPoolRef = new AtomicReference();

    @VisibleForTesting
    static void setHttpConfigPool(@Nullable SharedHttpConfigPool sharedHttpConfigPool) {
        _legacyHttpConfigPoolRef.set(sharedHttpConfigPool);
    }

    @Nonnull
    public static SharedHttpConfigPool getLegacyHttpConfigPool() {
        SharedHttpConfigPool sharedHttpConfigPool;
        boolean bl;
        do {
            if ((sharedHttpConfigPool = _legacyHttpConfigPoolRef.get()) == null) continue;
            return sharedHttpConfigPool;
        } while (!(bl = _legacyHttpConfigPoolRef.compareAndSet(null, sharedHttpConfigPool = SharedHttpConfigPool.builder().maxConnections(Config.VMOMI_HTTP_CONNECTION_POOL_SIZE_SSO).timeoutInMillis(Config.VMOMI_HTTP_SOCKET_TIMEOUT_SSO).connectionTimeoutInMillis(Config.VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_SSO).build())));
        return sharedHttpConfigPool;
    }

    public static TokenSpec buildTokenSpec(long l, TokenSpec.DelegationSpec delegationSpec, boolean bl) {
        TokenSpec.Builder builder = new TokenSpec.Builder(l);
        if (delegationSpec != null) {
            builder = builder.delegationSpec(delegationSpec);
        }
        builder = builder.renewable(bl);
        return builder.createTokenSpec();
    }

    public static String getUser() {
        SsoDomain ssoDomain = SsoDomain.getLocal();
        SamlToken samlToken = AuthSessionUtil.getSsoToken((SsoDomain)ssoDomain);
        return SsoUtil.getUser(samlToken);
    }

    public static String getUser(SamlToken samlToken) {
        PrincipalId principalId = samlToken.getSubject();
        return SsoUtil.toString(principalId);
    }

    @Deprecated
    public static Set<String> getGroups() {
        SsoDomain ssoDomain = SsoDomain.getLocal();
        return SsoUtil.getGroups(ssoDomain);
    }

    public static Set<String> getGroups(@Nonnull SsoDomain ssoDomain) {
        Validate.notNull((Object)ssoDomain);
        SamlToken samlToken = AuthSessionUtil.getSsoToken((SsoDomain)ssoDomain);
        return SsoUtil.getGroups(samlToken);
    }

    public static Set<String> getAllGroups() {
        HttpSession httpSession = SessionUtil.getHttpSession();
        Collection collection = AuthSessionUtil.getAllSsoTokens((HttpSession)httpSession).values();
        HashSet<String> hashSet = new HashSet<String>();
        for (SamlToken samlToken : collection) {
            hashSet.addAll(SsoUtil.getGroups(samlToken));
        }
        return hashSet;
    }

    public static Set<String> getGroups(SamlToken samlToken) {
        HashSet<String> hashSet = new HashSet<String>();
        List list = samlToken.getGroupList();
        for (PrincipalId principalId : list) {
            String string = SsoUtil.toString(principalId);
            hashSet.add(string);
        }
        return hashSet;
    }

    private static String toString(PrincipalId principalId) {
        return StringUtil.isNullOrEmpty((String)principalId.getDomain()) ? principalId.getName() : principalId.getDomain() + "\\" + principalId.getName();
    }

    public static String getUserName(String string) {
        Matcher matcher = UPN_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            return string2;
        }
        matcher = NETBIOS_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string3 = matcher.group(2);
            return string3;
        }
        return string;
    }

    public static String getDomainName(String string) {
        Matcher matcher = UPN_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(2);
            return string2;
        }
        matcher = NETBIOS_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string3 = matcher.group(1);
            return string3;
        }
        return "";
    }

    @Deprecated
    public static SamlToken getDelegatedToken(SsoService ssoService, SamlToken samlToken, String string, boolean bl) throws SsoServiceException {
        SsoDomain ssoDomain = SsoDomain.getLocal();
        return SsoUtil.getDelegatedToken(ssoService, ssoDomain, ssoDomain, samlToken, string, bl);
    }

    public static SamlToken getDelegatedToken(SsoService ssoService, SsoDomain ssoDomain, SsoDomain ssoDomain2, SamlToken samlToken, String string, boolean bl) throws SsoServiceException {
        long l = samlToken.getExpirationTime().getTime() - samlToken.getStartTime().getTime();
        TokenSpec.Builder builder = new TokenSpec.Builder(l - 1000L);
        builder.delegationSpec(new TokenSpec.DelegationSpec(false, string));
        builder.renewable(bl);
        TokenSpec tokenSpec = builder.createTokenSpec();
        SamlToken samlToken2 = ssoService.acquireTokenByToken(ssoDomain, ssoDomain2, samlToken, tokenSpec);
        return samlToken2;
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoService ssoService) throws SsoServiceException {
        return SsoUtil.getAdminService(ssoService, (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool());
    }

    public static SsoAdminService getAdminService(SsoService ssoService, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws SsoServiceException {
        try {
            return SsoUtil.getAdminService(ssoService.getServerInfo(), ssoService, (SamlToken)null, httpConfigurationProvider);
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoServerInfo ssoServerInfo, SsoService ssoService, SamlToken samlToken) throws SsoServiceException {
        return SsoUtil.getAdminService(ssoServerInfo, ssoService, samlToken, true);
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoServerInfo ssoServerInfo, SsoService ssoService, SamlToken samlToken, boolean bl) throws SsoServiceException {
        return SsoUtil.getAdminService(ssoServerInfo, ssoService, samlToken, (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool(), bl);
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoServerInfo ssoServerInfo, SsoService ssoService, SamlToken samlToken, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws SsoServiceException {
        return SsoUtil.getAdminService(ssoServerInfo, ssoService, samlToken, httpConfigurationProvider, true);
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoServerInfo ssoServerInfo, SsoService ssoService, SamlToken samlToken, @Nonnull HttpConfigurationProvider httpConfigurationProvider, boolean bl) throws SsoServiceException {
        try {
            SsoAdminServiceImpl ssoAdminServiceImpl = new SsoAdminServiceImpl(ssoServerInfo, ssoService, samlToken, httpConfigurationProvider, bl);
            return ssoAdminServiceImpl;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoServerInfo ssoServerInfo, SsoService ssoService, SsoSolutionUser ssoSolutionUser) throws SsoServiceException {
        return SsoUtil.getAdminService(ssoServerInfo, ssoService, ssoSolutionUser, (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool());
    }

    @Deprecated
    public static SsoAdminService getAdminService(SsoServerInfo ssoServerInfo, SsoService ssoService, SsoSolutionUser ssoSolutionUser, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws SsoServiceException {
        try {
            SsoAdminServiceImpl ssoAdminServiceImpl = new SsoAdminServiceImpl(ssoServerInfo, ssoService, ssoSolutionUser, httpConfigurationProvider);
            return ssoAdminServiceImpl;
        }
        catch (Exception exception) {
            throw new SsoServiceException("SSO admin service failure", exception);
        }
    }

    public static SsoSolutionUser getSolutionUser() {
        return NgcSolutionUser.instance();
    }

    public static SsoServerInfo getSsoServerInfo(@Nonnull Map<SsoDomain, SsoServerInfo> map, @Nonnull SsoDomain ssoDomain) {
        SsoServerInfo ssoServerInfo = map.get(ssoDomain);
        if (ssoServerInfo == null) {
            throw new IllegalStateException("Couldn't find SSO server info for domain " + ssoDomain);
        }
        return ssoServerInfo;
    }

    public static boolean domainHasMultiTokenSupport(SsoService ssoService, SsoDomain ssoDomain) throws SsoServiceException {
        try {
            Map<SsoDomain, SsoServerInfo> map = ssoService.getServerInfos();
            SsoServerInfo ssoServerInfo = SsoUtil.getSsoServerInfo(map, ssoDomain);
            boolean bl = SsoUtil.domainHasMultiTokenSupport(ssoServerInfo);
            return bl;
        }
        catch (Exception exception) {
            throw new SsoServiceException("Can't determine if domain " + ssoDomain + " has VC-trusts capability");
        }
    }

    public static boolean domainHasMultiTokenSupport(SsoServerInfo ssoServerInfo) {
        boolean bl = ssoServerInfo.stsHasVcTrustsCapability();
        return bl;
    }
}

