/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.ServiceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.security.sso.SsoConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoLocator;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.exception.SsoServiceRuntimeException;
import com.vmware.vise.vim.security.sso.impl.SsoAdminServiceImpl;
import com.vmware.vise.vim.security.sso.impl.SsoUtilInternal;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LazyRetrievalSsoConfigurationProviderImpl
implements SsoConfigurationProvider {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @VisibleForTesting
    static final String PROPERTY_NAME_SSO_CLOCK_TOLERANCE = "sso.clockTolerance";
    private final ConfigurationService _configurationService;
    private final SsoLocator _ssoLocator;
    private final HttpConfigurationProvider _httpConfigProvider;
    private volatile Long _clockToleranceInSeconds;
    private final Lock _lock = new ReentrantLock();
    private final long _defaultClockToleranceInSeconds;

    public LazyRetrievalSsoConfigurationProviderImpl(@Nonnull ConfigurationService configurationService, @Nonnull SsoLocator ssoLocator, @Nonnull HttpConfigurationProvider httpConfigurationProvider) {
        this(configurationService, ssoLocator, httpConfigurationProvider, -1L);
    }

    public LazyRetrievalSsoConfigurationProviderImpl(@Nonnull ConfigurationService configurationService, @Nonnull SsoLocator ssoLocator, @Nonnull HttpConfigurationProvider httpConfigurationProvider, long l) {
        Validate.notNull((Object)configurationService);
        Validate.notNull((Object)ssoLocator);
        Validate.notNull((Object)httpConfigurationProvider);
        this._configurationService = configurationService;
        this._ssoLocator = ssoLocator;
        this._httpConfigProvider = httpConfigurationProvider;
        this._defaultClockToleranceInSeconds = l;
        this._clockToleranceInSeconds = null;
    }

    @Nonnull
    private Long getConfiguration() {
        Long l = this._clockToleranceInSeconds;
        if (l != null) {
            return l;
        }
        this._lock.lock();
        try {
            l = this._clockToleranceInSeconds;
            if (l != null) {
                Long l2 = l;
                return l2;
            }
            l = PropertyUtil.getLongProperty((ConfigurationService)this._configurationService, (String)PROPERTY_NAME_SSO_CLOCK_TOLERANCE, (long)-1L);
            if (l < 0L) {
                l = this.fetchConfigurationFromSsoConfigMgmtService();
            } else {
                _logger.info((Object)("Retrieved the clock tolerance from the configuration service: " + l + " seconds"));
            }
            this._clockToleranceInSeconds = l;
            Long l3 = l;
            return l3;
        }
        catch (Exception exception) {
            if (this._defaultClockToleranceInSeconds >= 0L) {
                _logger.error((Object)("Failed to determine the SSO clock tolerance. Will use the default: " + this._defaultClockToleranceInSeconds + " seconds"));
                this._clockToleranceInSeconds = l = Long.valueOf(this._defaultClockToleranceInSeconds);
                Long l4 = l;
                return l4;
            }
            throw new SsoServiceRuntimeException("Failed to determine the SSO clock tolerance.", exception);
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long fetchConfigurationFromSsoConfigMgmtService() throws Exception {
        Client client = null;
        try {
            Map<SsoDomain, SsoServerInfo> map = this._ssoLocator.getSsoServerInfos();
            SsoDomain ssoDomain = SsoDomain.getLocal();
            SsoServerInfo ssoServerInfo = map.get(ssoDomain);
            client = SsoUtilInternal.createSsoAdminClient(ssoServerInfo, this._httpConfigProvider);
            ServiceContent serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            ManagedObjectReference managedObjectReference = serviceContent.getConfigurationManagementService();
            ConfigurationManagementService configurationManagementService = (ConfigurationManagementService)VmomiClientHelper.createStub((Client)client, ConfigurationManagementService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoAdminServiceImpl.class.getClassLoader());
            long l = configurationManagementService.getClockTolerance();
            long l2 = TimeUnit.MILLISECONDS.toSeconds(l);
            _logger.info((Object)("Retrieved the clock tolerance from SSO: " + l2 + " seconds"));
            long l3 = l2;
            return l3;
        }
        finally {
            if (client != null) {
                try {
                    client.shutdown();
                }
                catch (Exception exception) {
                    _logger.error((Object)"Failed to shut down the Client used to retrievethe SSO configuration from the SSO server.", (Throwable)exception);
                }
            }
        }
    }

    @Override
    public long getClockToleranceInSeconds() {
        Long l = this.getConfiguration();
        return l;
    }

    @Override
    public void refresh() {
        this._clockToleranceInSeconds = null;
    }
}

