/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenEx;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.SecurityTokenServiceEx;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoLocator;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.sso.impl.SsoUtilInternal;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NgcSolutionUser
implements SsoSolutionUser {
    private static final Log _logger = LogFactory.getLog(NgcSolutionUser.class);
    static NgcSolutionUser _ngcSolutionUser;
    private static final String DEFAULT_CERT_ALIAS = "vsphere-webclient";
    private final SsoLocator _ssoLocator;
    private final KeystoreService _ksService;
    private final ConfigurationService _configService;
    @Nullable
    private final SsoConfigurationProvider _ssoConfigurationProvider;
    @Nullable
    private final HttpConfigurationProvider _httpConfigProvider;
    X509Certificate _solutionUserCertificate;
    PrivateKey _solutionUserPrivateKey;
    final ConcurrentMap<SsoDomain, TokenEx> _tokenByDomain = new ConcurrentHashMap<SsoDomain, TokenEx>();

    public NgcSolutionUser(SsoLocator ssoLocator, KeystoreService keystoreService, ConfigurationService configurationService, @Nonnull SsoConfigurationProvider ssoConfigurationProvider, @Nonnull HttpConfigurationProvider httpConfigurationProvider) {
        this(true, ssoLocator, keystoreService, configurationService, (SsoConfigurationProvider)ValidationUtil.notNull((Object)ssoConfigurationProvider, (String)"ssoConfigProvider is null"), (HttpConfigurationProvider)ValidationUtil.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null"));
    }

    public NgcSolutionUser(boolean bl, SsoLocator ssoLocator, KeystoreService keystoreService, ConfigurationService configurationService, SsoConfigurationProvider ssoConfigurationProvider, HttpConfigurationProvider httpConfigurationProvider) {
        this._ssoLocator = ssoLocator;
        this._ksService = keystoreService;
        this._configService = configurationService;
        this._ssoConfigurationProvider = ssoConfigurationProvider;
        this._httpConfigProvider = httpConfigurationProvider;
        if (_ngcSolutionUser == null) {
            _ngcSolutionUser = this;
        }
        this.loadKeystore();
    }

    public static NgcSolutionUser instance() {
        return _ngcSolutionUser;
    }

    @Override
    @Deprecated
    public SamlToken getLoggedInToken() {
        return this.getLoggedInToken(SsoDomain.getLocal());
    }

    @Override
    public SamlToken getLoggedInToken(SsoDomain ssoDomain) {
        TokenEx tokenEx = this.getLoggedInTokenEx(ssoDomain);
        return tokenEx != null ? tokenEx.getToken() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenEx getLoggedInTokenEx(SsoDomain ssoDomain) {
        TokenEx tokenEx = this.getValidToken(ssoDomain);
        if (tokenEx != null) {
            return tokenEx;
        }
        NgcSolutionUser ngcSolutionUser = this;
        synchronized (ngcSolutionUser) {
            tokenEx = this.getValidToken(ssoDomain);
            if (tokenEx != null) {
                return tokenEx;
            }
            tokenEx = this.login(ssoDomain);
            return tokenEx;
        }
    }

    private TokenEx getValidToken(SsoDomain ssoDomain) {
        TokenEx tokenEx = (TokenEx)this._tokenByDomain.get(ssoDomain);
        if (tokenEx == null) {
            return null;
        }
        SamlToken samlToken = tokenEx.getToken();
        try {
            if (!SsoUtilInternal.checkTokenLifetime(samlToken)) {
                return tokenEx;
            }
        }
        catch (InvalidTokenException invalidTokenException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this._solutionUserPrivateKey;
    }

    @Override
    public X509Certificate getCertificate() {
        return this._solutionUserCertificate;
    }

    private TokenEx login(SsoDomain ssoDomain) {
        try {
            SamlToken samlToken;
            SsoDomain ssoDomain2;
            SamlToken samlToken2;
            _logger.info((Object)String.format("Solution user logging into domain %s", ssoDomain.getName()));
            SecurityTokenServiceConfig.HolderOfKeyConfig holderOfKeyConfig = new SecurityTokenServiceConfig.HolderOfKeyConfig((Key)this._solutionUserPrivateKey, this._solutionUserCertificate, null);
            SsoServerInfo ssoServerInfo = SsoUtil.getSsoServerInfo(this._ssoLocator.getSsoServerInfos(), ssoDomain);
            SecurityTokenServiceConfig securityTokenServiceConfig = SsoUtilInternal.createStsConfiguration(ssoServerInfo, holderOfKeyConfig, this._ksService, this._ssoConfigurationProvider, this._httpConfigProvider);
            SecurityTokenServiceEx securityTokenServiceEx = SsoUtilInternal.createSts(securityTokenServiceConfig);
            TokenSpec tokenSpec = SsoUtil.buildTokenSpec(28800000L, new TokenSpec.DelegationSpec(true), false);
            if (ssoDomain.isLocal()) {
                samlToken2 = SsoUtilInternal.acquireTokenByCertificate(securityTokenServiceConfig, (SecurityTokenService)securityTokenServiceEx, tokenSpec);
                ssoDomain2 = ssoDomain;
            } else {
                samlToken = this.getLoggedInToken(SsoDomain.getLocal());
                if (samlToken == null) {
                    throw new NoTokenException(String.format("Solution user token for the local %s domain is null/empty. Cannot request token for the remote domain %s", SsoDomain.getLocal(), ssoDomain));
                }
                if (SsoUtil.domainHasMultiTokenSupport(ssoServerInfo)) {
                    samlToken2 = SsoUtilInternal.acquireTokenByToken(ssoServerInfo, securityTokenServiceConfig, securityTokenServiceEx, SsoDomain.getLocal(), samlToken, tokenSpec);
                    ssoDomain2 = ssoDomain;
                } else {
                    samlToken2 = samlToken;
                    ssoDomain2 = SsoDomain.getLocal();
                }
            }
            samlToken = new TokenEx(samlToken2, ssoDomain2);
            this._tokenByDomain.put(ssoDomain, (TokenEx)samlToken);
            _logger.info((Object)String.format("Solution user logged into domain %s", ssoDomain.getName()));
            return samlToken;
        }
        catch (Exception exception) {
            _logger.error((Object)String.format("Solution user login into domain %s failed.", ssoDomain.getName()), (Throwable)exception);
            return null;
        }
    }

    protected void loadKeystore() {
        if (!StringUtil.isNullOrEmpty((String)this._configService.getProperty("keystore.jks.path"))) {
            this.loadLocalKeystore();
            return;
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("VKS2");
            Class<?> clazz = Class.forName("com.vmware.provider.VecsLoadStoreParameter");
            KeyStore.LoadStoreParameter loadStoreParameter = (KeyStore.LoadStoreParameter)clazz.getConstructor(String.class).newInstance(DEFAULT_CERT_ALIAS);
            keyStore.load(loadStoreParameter);
            _logger.info((Object)"VECS NGC solution user store is now loaded successfully.");
            this._solutionUserCertificate = (X509Certificate)keyStore.getCertificate(DEFAULT_CERT_ALIAS);
            this._solutionUserPrivateKey = (PrivateKey)keyStore.getKey(DEFAULT_CERT_ALIAS, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"Error loading VECS NGC solution user store", (Throwable)exception);
        }
    }

    private void loadLocalKeystore() {
        try {
            _logger.info((Object)"Using local keystore to fetch NGC solution user info.");
            KeyStore keyStore = this._ksService.getKeyStore();
            char[] cArray = this._ksService.getKeyStorePassword() != null ? this._ksService.getKeyStorePassword().toCharArray() : null;
            String string = DEFAULT_CERT_ALIAS;
            this._solutionUserCertificate = (X509Certificate)keyStore.getCertificate(string);
            this._solutionUserPrivateKey = (PrivateKey)keyStore.getKey(string, cArray);
        }
        catch (Exception exception) {
            _logger.error((Object)"Failed to fetch solution user info from local key store.", (Throwable)exception);
        }
    }

    static class NoTokenException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoTokenException(String string) {
            super(string);
        }
    }
}

