/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidRequest;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.common.Stub;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.commons.vmomi.VmomiFutureInvocationCallback;
import com.vmware.vise.vim.commons.vmomi.VmomiFutureWrapper;
import com.vmware.vise.vim.commons.vmomi.VmomiImmediateFailedFuture;
import com.vmware.vise.vim.commons.vmomi.VmomiImmediateFuture;
import com.vmware.vise.vim.security.sso.impl.SsoUtilInternal;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyingClient
implements Client {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private volatile ClientWithContext _actualClient;
    @Nonnull
    private final VmodlContext _vmodlContext;
    private final Class<?> _baseVmodlVersionOfClient;
    private final VmomiClientFactory _clientFactory;
    private final boolean _gracefulShutdown;
    private final ScheduledExecutorService _scheduledExec;
    private final int _scheduledTimeout;
    private final TimeUnit _scheduledTimeoutUnit;

    public ProxyingClient(@Nonnull Client client, @Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull VmomiClientFactory vmomiClientFactory, boolean bl, @Nullable ScheduledExecutorService scheduledExecutorService, int n, @Nullable TimeUnit timeUnit) {
        this(client, VmodlContext.getContext(), clazz, clazz2, vmomiClientFactory, bl, scheduledExecutorService, n, timeUnit);
    }

    public ProxyingClient(@Nonnull Client client, @Nonnull VmodlContext vmodlContext, @Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull VmomiClientFactory vmomiClientFactory, boolean bl, @Nullable ScheduledExecutorService scheduledExecutorService, int n, @Nullable TimeUnit timeUnit) {
        ClientWithContext clientWithContext;
        Validate.notNull((Object)client);
        Validate.notNull((Object)vmodlContext);
        Validate.notNull(clazz);
        Validate.notNull(clazz2);
        Validate.notNull((Object)vmomiClientFactory);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Creating a proxying client for VMOMI Client " + client));
        }
        this._actualClient = clientWithContext = new ClientWithContext(client, clazz);
        this._vmodlContext = vmodlContext;
        this._baseVmodlVersionOfClient = clazz2;
        this._clientFactory = vmomiClientFactory;
        this._gracefulShutdown = bl;
        ScheduledExecutorService scheduledExecutorService2 = scheduledExecutorService;
        if (n <= 0 || timeUnit == null) {
            scheduledExecutorService2 = null;
        }
        this._scheduledExec = scheduledExecutorService2;
        this._scheduledTimeout = n;
        this._scheduledTimeoutUnit = timeUnit;
    }

    public <T extends ManagedObject> T createStub(Class<T> clazz, ManagedObjectReference managedObjectReference) {
        ClientWithContext clientWithContext = this.getClientToUse();
        ManagedObject managedObject = clientWithContext.client.createStub(clazz, managedObjectReference);
        return (T)this.createProxyStub(managedObject, clientWithContext);
    }

    public <T extends ManagedObject> T createStub(Class<T> clazz, String string) {
        ClientWithContext clientWithContext = this.getClientToUse();
        ManagedObject managedObject = clientWithContext.client.createStub(clazz, string);
        return (T)this.createProxyStub(managedObject, clientWithContext);
    }

    public <T extends ManagedObject> T createServiceStub(Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    private ClientWithContext getClientToUse() {
        ClientWithContext clientWithContext;
        while (ProxyingClient.isShutdownRequested(clientWithContext = this._actualClient)) {
            if (clientWithContext.shutdownReason == ShutdownReason.VERSION_PROBLEM && !clientWithContext.vmodlVersion.equals(this._baseVmodlVersionOfClient)) continue;
            throw new IllegalStateException("The Client is already shut down");
        }
        return clientWithContext;
    }

    public ProtocolBinding getBinding() {
        return this._actualClient.client.getBinding();
    }

    public void shutdown() {
        this.shutdown(this._actualClient, ShutdownReason.NORMAL);
    }

    public Client getActualClient() {
        return this._actualClient.client;
    }

    void shutdown(final ClientWithContext clientWithContext, ShutdownReason shutdownReason) {
        clientWithContext.shutdownReason = shutdownReason;
        int n = clientWithContext.countOfCallsInProgress.get();
        if (n <= 0 || !this._gracefulShutdown && clientWithContext.shutdownReason != ShutdownReason.VERSION_PROBLEM) {
            if (this._scheduledExec != null) {
                this._scheduledExec.schedule(new Runnable(){

                    @Override
                    public void run() {
                        _logger.warn((Object)("Shutting down VMOMI Client " + clientWithContext.client + " after timeout expired"));
                        ProxyingClient.this.doShutdown(clientWithContext, false);
                    }
                }, (long)this._scheduledTimeout, this._scheduledTimeoutUnit);
            }
            this.doShutdown(clientWithContext, true);
        }
    }

    private <T extends ManagedObject> T createProxyStub(T t, ClientWithContext clientWithContext) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{t});
        VmodlVersionAwareInvocationHandler vmodlVersionAwareInvocationHandler = new VmodlVersionAwareInvocationHandler(clientWithContext, t);
        ClassLoader classLoader = t.getClass().getClassLoader();
        Class clazz = ((com.vmware.vim.vmomi.core.Stub)t)._getManagedObjectClass();
        ManagedObject managedObject = (ManagedObject)Proxy.newProxyInstance(classLoader, new Class[]{clazz, Stub.class}, (InvocationHandler)vmodlVersionAwareInvocationHandler);
        return (T)managedObject;
    }

    private void decrementCountOfCallsInProgress(ClientWithContext clientWithContext) {
        int n = clientWithContext.countOfCallsInProgress.decrementAndGet();
        if (n == 0 && ProxyingClient.isShutdownRequested(clientWithContext)) {
            this.doShutdown(clientWithContext, true);
        }
    }

    private void doShutdown(ClientWithContext clientWithContext, boolean bl) {
        try {
            if (clientWithContext.isShutdownInitiated.compareAndSet(false, true)) {
                if (bl && clientWithContext.shutdownScheduledTask != null) {
                    clientWithContext.shutdownScheduledTask.cancel(false);
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Shutting down VMOMI Client " + clientWithContext.client + "\n" + ExceptionUtil.getCurrentStackTrace()));
                }
                clientWithContext.client.shutdown();
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to shut down VMOMI client " + clientWithContext.client), (Throwable)exception);
        }
    }

    private static boolean isShutdownRequested(ClientWithContext clientWithContext) {
        return clientWithContext.shutdownReason != null;
    }

    private static enum ShutdownReason {
        NORMAL,
        VERSION_PROBLEM;

    }

    private static class ClientWithContextAndStubAndResult
    extends ClientWithContextAndStub {
        final Method method;
        final Object result;
        final Throwable throwable;

        public ClientWithContextAndStubAndResult(ClientWithContext clientWithContext, ManagedObject managedObject, Method method, Object object, Throwable throwable) {
            super(clientWithContext, managedObject);
            this.method = method;
            this.result = object;
            this.throwable = throwable;
        }

        public ClientWithContextAndStubAndResult(ClientWithContextAndStub clientWithContextAndStub, Method method, Object object, Throwable throwable) {
            super(clientWithContextAndStub);
            this.method = method;
            this.result = object;
            this.throwable = throwable;
        }
    }

    private static class ClientWithContextAndStub {
        protected final ClientWithContext client;
        protected final ManagedObject stub;

        public ClientWithContextAndStub(ClientWithContext clientWithContext, ManagedObject managedObject) {
            this.client = clientWithContext;
            this.stub = managedObject;
        }

        public ClientWithContextAndStub(ClientWithContextAndStub clientWithContextAndStub) {
            this.client = clientWithContextAndStub.client;
            this.stub = clientWithContextAndStub.stub;
        }
    }

    private static class ClientWithContext {
        protected final Client client;
        protected final Class<?> vmodlVersion;
        final AtomicInteger countOfCallsInProgress;
        volatile ShutdownReason shutdownReason;
        AtomicBoolean isShutdownInitiated = new AtomicBoolean(false);
        volatile ScheduledFuture<Void> shutdownScheduledTask;

        public ClientWithContext(Client client, Class<?> clazz) {
            this.client = client;
            this.vmodlVersion = clazz;
            this.countOfCallsInProgress = new AtomicInteger(0);
        }
    }

    private class VmodlVersionAwareInvocationHandler
    implements InvocationHandler {
        private volatile ClientWithContextAndStub _clientAndStub;
        private final ManagedObjectType _moType;
        private final Lock _lock = new ReentrantLock();

        VmodlVersionAwareInvocationHandler(ClientWithContext clientWithContext, ManagedObject managedObject) {
            this._clientAndStub = new ClientWithContextAndStub(clientWithContext, managedObject);
            ManagedObjectReference managedObjectReference = managedObject._getRef();
            VmodlTypeMap vmodlTypeMap = ProxyingClient.this._vmodlContext.getVmodlTypeMap();
            Class clazz = ((com.vmware.vim.vmomi.core.Stub)managedObject)._getManagedObjectClass();
            ManagedObjectType managedObjectType = (ManagedObjectType)vmodlTypeMap.getLoadedVmodlType(clazz);
            if (managedObjectType == null) {
                managedObjectType = (ManagedObjectType)vmodlTypeMap.getLoadedVmodlType(managedObjectReference.getType());
            }
            this._moType = managedObjectType;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            ClientWithContextAndStub clientWithContextAndStub = this._clientAndStub;
            if (ProxyingClient.isShutdownRequested(clientWithContextAndStub.client) && clientWithContextAndStub.client.shutdownReason != ShutdownReason.VERSION_PROBLEM) {
                throw new IllegalStateException("The client is shut down");
            }
            boolean bl = false;
            if (this._moType.getManagedProperty(method) != null || this._moType.getMethod(method) != null) {
                bl = true;
            }
            if (!bl) {
                try {
                    return method.invoke((Object)clientWithContextAndStub.stub, objectArray);
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (throwable instanceof InvocationTargetException) {
                        throwable2 = throwable.getCause();
                    }
                    throw throwable2;
                }
            }
            clientWithContextAndStub.client.countOfCallsInProgress.incrementAndGet();
            boolean bl2 = true;
            Object[] objectArray2 = this.wrapFutureIfCallIsAsynchronous(clientWithContextAndStub, method, objectArray);
            if (objectArray2 == null) {
                objectArray2 = objectArray;
            } else {
                bl2 = false;
            }
            try {
                Object object2 = method.invoke((Object)clientWithContextAndStub.stub, objectArray2);
                if (bl2) {
                    ProxyingClient.this.decrementCountOfCallsInProgress(clientWithContextAndStub.client);
                }
                return object2;
            }
            catch (Throwable throwable) {
                Throwable throwable3;
                if (bl2) {
                    ProxyingClient.this.decrementCountOfCallsInProgress(clientWithContextAndStub.client);
                }
                if (throwable instanceof InvocationTargetException) {
                    throwable3 = throwable.getCause();
                }
                ClientWithContextAndStubAndResult clientWithContextAndStubAndResult = this.handleInvocationException(clientWithContextAndStub, method, objectArray2, throwable3);
                if (clientWithContextAndStubAndResult.throwable != null) {
                    throw clientWithContextAndStubAndResult.throwable;
                }
                this._clientAndStub = new ClientWithContextAndStub(clientWithContextAndStubAndResult.client, clientWithContextAndStubAndResult.stub);
                return clientWithContextAndStubAndResult.result;
            }
        }

        private Object[] wrapFutureIfCallIsAsynchronous(ClientWithContextAndStub clientWithContextAndStub, Method method, Object[] objectArray) {
            int n;
            Object object;
            if (objectArray != null && objectArray.length > 0 && (object = objectArray[(n = objectArray.length) - 1]) instanceof Future) {
                Future future = (Future)object;
                VmomiFutureWrapper vmomiFutureWrapper = new VmomiFutureWrapper(future, clientWithContextAndStub.stub, method, objectArray, new VmodlVersionAwareVmomiFutureInvocationCallback(clientWithContextAndStub));
                objectArray = Arrays.copyOf(objectArray, n);
                objectArray[n - 1] = vmomiFutureWrapper;
                return objectArray;
            }
            return null;
        }

        private ClientWithContextAndStubAndResult handleInvocationException(ClientWithContextAndStub clientWithContextAndStub, Method method, Object[] objectArray, Throwable throwable) {
            Object object;
            Class clazz = ProxyingClient.this._baseVmodlVersionOfClient;
            if (clazz.equals(clientWithContextAndStub.client.vmodlVersion)) {
                return new ClientWithContextAndStubAndResult(clientWithContextAndStub, method, null, throwable);
            }
            Throwable throwable2 = ExceptionUtil.findCauseByClass((Throwable)throwable, (Class[])new Class[]{InvalidRequest.class});
            if (throwable2 != null ? (object = throwable2.getMessage()) == null || !((String)object).contains("Request version") && !((String)object).contains("not supported") : clientWithContextAndStub.client == ProxyingClient.this._actualClient) {
                return new ClientWithContextAndStubAndResult(clientWithContextAndStub, method, null, throwable);
            }
            try {
                object = this.createNewClientAndStubIfNecessary(clientWithContextAndStub, clazz, throwable);
            }
            catch (Throwable throwable3) {
                _logger.error((Object)("Failed to create a stub to use. Will throw the original exception: " + throwable.toString() + ". The current failure was: "), throwable3);
                return new ClientWithContextAndStubAndResult(clientWithContextAndStub, method, null, throwable);
            }
            try {
                Object object2 = method.invoke((Object)((ClientWithContextAndStub)object).stub, objectArray);
                return new ClientWithContextAndStubAndResult((ClientWithContextAndStub)object, method, object2, null);
            }
            catch (Throwable throwable4) {
                Throwable throwable5;
                if (throwable4 instanceof InvocationTargetException) {
                    throwable5 = throwable4.getCause();
                }
                return new ClientWithContextAndStubAndResult((ClientWithContextAndStub)object, method, null, throwable5);
            }
        }

        private ClientWithContextAndStub createNewClientAndStubIfNecessary(ClientWithContextAndStub clientWithContextAndStub, Class<?> clazz, Throwable throwable) {
            ClientWithContextAndStub clientWithContextAndStub2 = clientWithContextAndStub;
            this._lock.lock();
            try {
                Object object;
                ClientWithContext clientWithContext = ProxyingClient.this._actualClient;
                if (clientWithContext == clientWithContextAndStub.client) {
                    _logger.warn((Object)("Due to an exception, will replace a Client whose version is " + clientWithContextAndStub.client.vmodlVersion.getName() + " with a Client whose version is " + clazz.getName() + ". The exception is: " + (_logger.isDebugEnabled() ? ExceptionUtil.getStackTrace((Throwable)throwable) : throwable.toString())));
                    object = ProxyingClient.this._clientFactory.createClient(clazz);
                    ClientWithContext clientWithContext2 = new ClientWithContext((Client)object, clazz);
                    ProxyingClient.this._actualClient = clientWithContext2;
                    ManagedObject managedObject = this.createNewStub(clientWithContext2, clientWithContextAndStub.stub);
                    clientWithContextAndStub2 = new ClientWithContextAndStub(clientWithContext2, managedObject);
                    ProxyingClient.this.shutdown(clientWithContextAndStub.client, ShutdownReason.VERSION_PROBLEM);
                } else {
                    object = this.createNewStub(clientWithContext, clientWithContextAndStub.stub);
                    clientWithContextAndStub2 = new ClientWithContextAndStub(clientWithContext, (ManagedObject)object);
                }
                object = clientWithContextAndStub2;
                return object;
            }
            catch (Throwable throwable2) {
                _logger.error((Object)"Failed to create a new Client", throwable2);
                throw throwable2;
            }
            finally {
                this._lock.unlock();
            }
        }

        private ManagedObject createNewStub(ClientWithContext clientWithContext, ManagedObject managedObject) {
            ManagedObjectReference managedObjectReference = managedObject._getRef();
            Class clazz = ((com.vmware.vim.vmomi.core.Stub)managedObject)._getManagedObjectClass();
            ClassLoader classLoader = SsoUtilInternal.class.getClassLoader();
            Client client = clientWithContext.client;
            ManagedObject managedObject2 = VmomiClientHelper.createStub((Client)client, (Class)clazz, (ManagedObjectReference)managedObjectReference, (ClassLoader)classLoader);
            RequestContext requestContext = ((com.vmware.vim.vmomi.core.Stub)managedObject)._getRequestContext();
            if (requestContext != null) {
                ((com.vmware.vim.vmomi.core.Stub)managedObject2)._setRequestContext(requestContext);
            }
            return managedObject2;
        }

        private class VmodlVersionAwareVmomiFutureInvocationCallback<T>
        implements VmomiFutureInvocationCallback<T> {
            private final ClientWithContextAndStub _clientAndStub;

            VmodlVersionAwareVmomiFutureInvocationCallback(ClientWithContextAndStub clientWithContextAndStub) {
                this._clientAndStub = clientWithContextAndStub;
            }

            public VmomiFutureInvocationCallback.VmomiFutureInvocationContext<T> invocationDone(VmomiFutureInvocationCallback.VmomiFutureInvocationContext<T> vmomiFutureInvocationContext) {
                ProxyingClient.this.decrementCountOfCallsInProgress(this._clientAndStub.client);
                Future future = vmomiFutureInvocationContext.getFuture();
                if (future.isCancelled()) {
                    return vmomiFutureInvocationContext;
                }
                try {
                    future.get();
                    return vmomiFutureInvocationContext;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ExecutionException) {
                        Throwable throwable2 = throwable.getCause();
                        Method method = vmomiFutureInvocationContext.getMethod();
                        Object[] objectArray = vmomiFutureInvocationContext.getArgs();
                        ClientWithContextAndStubAndResult clientWithContextAndStubAndResult = VmodlVersionAwareInvocationHandler.this.handleInvocationException(this._clientAndStub, method, objectArray, throwable2);
                        ManagedObject managedObject = clientWithContextAndStubAndResult.stub;
                        VmodlVersionAwareInvocationHandler.this._clientAndStub = new ClientWithContextAndStub(clientWithContextAndStubAndResult.client, managedObject);
                        Object object = clientWithContextAndStubAndResult.result;
                        Throwable throwable3 = clientWithContextAndStubAndResult.throwable;
                        if (throwable3 == null) {
                            VmomiImmediateFuture vmomiImmediateFuture = new VmomiImmediateFuture(object);
                            return new VmomiFutureInvocationCallback.VmomiFutureInvocationContext((Future)vmomiImmediateFuture, managedObject, method, objectArray);
                        }
                        VmomiImmediateFailedFuture vmomiImmediateFailedFuture = new VmomiImmediateFailedFuture(throwable3);
                        return new VmomiFutureInvocationCallback.VmomiFutureInvocationContext((Future)vmomiImmediateFailedFuture, managedObject, method, objectArray);
                    }
                    return vmomiFutureInvocationContext;
                }
            }
        }
    }

    public static interface VmomiClientFactory {
        public Client createClient(Class<?> var1);
    }
}

