/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.google.common.collect.ImmutableMap;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.internal.Config;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.security.sso.SsoLocator;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.vmafd.VmAfDataProvider;
import com.vmware.vise.vim.vmafd.impl.VmAfClientBasedVmAfDataProvider;
import java.security.KeyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoLsLocatorImpl
implements SsoLocator {
    private final LookupService _lsService;
    private final KeystoreService _ksService;
    private final Class<?> _vmodlVersion;
    @Nonnull
    private final VmAfDataProvider _vmAfDataProvider;
    private static final Log _logger = LogFactory.getLog(SsoLsLocatorImpl.class);
    private static final long LOCK_ACQUISITION_THRESHOLD_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private volatile CachedData _cachedData;

    public SsoLsLocatorImpl(LookupService lookupService, KeystoreService keystoreService) {
        this(lookupService, keystoreService, null);
    }

    public SsoLsLocatorImpl(LookupService lookupService, KeystoreService keystoreService, Class<?> clazz) {
        this(lookupService, keystoreService, clazz, null);
    }

    public SsoLsLocatorImpl(LookupService lookupService, KeystoreService keystoreService, Class<?> clazz, @Nullable VmAfDataProvider vmAfDataProvider) {
        this._lsService = lookupService;
        this._ksService = keystoreService;
        this._vmodlVersion = clazz;
        if (vmAfDataProvider == null) {
            vmAfDataProvider = new VmAfClientBasedVmAfDataProvider();
        }
        this._vmAfDataProvider = vmAfDataProvider;
    }

    @Override
    @Nonnull
    public SsoServerInfo getSsoServerInfo() throws Exception {
        Map<SsoDomain, SsoServerInfo> map = this.getSsoServerInfos();
        SsoDomain ssoDomain = SsoDomain.getLocal();
        SsoServerInfo ssoServerInfo = map.get(ssoDomain);
        return ssoServerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Map<SsoDomain, SsoServerInfo> getSsoServerInfos() throws Exception {
        Object object;
        ServiceRegistration.Info[] infoArray;
        long l;
        Object object2;
        long l2;
        String string;
        long l3 = System.currentTimeMillis();
        String string2 = this._lsService.getServiceUrl();
        CachedData cachedData = this.getValidCachedData(string2, string = this._vmAfDataProvider.getDomainController("localhost", SsoDomain.getLocal()));
        if (cachedData == null) {
            l2 = System.nanoTime();
            object2 = this;
            synchronized (object2) {
                l = System.nanoTime() - l2;
                if (l > LOCK_ACQUISITION_THRESHOLD_NANOS) {
                    _logger.warn((Object)("getSsoServerInfo(): Lock acquisition took too long: " + TimeUnit.NANOSECONDS.toMillis(l) + " ms"));
                }
                if ((cachedData = this.getValidCachedData(string2, string)) == null) {
                    _logger.info((Object)"Fetching SSO endpoints from LS");
                    infoArray = LookupUtil.find(this._lsService, LookupUtil.SSO);
                    _logger.debug((Object)"Done with the lsService invocation");
                    object = this.buildSsoServerInfoFromServiceRegistrationInfos(infoArray);
                    this._cachedData = cachedData = new CachedData(string2, string, (Map<SsoDomain, SsoServerInfo>)object);
                }
            }
        }
        l2 = System.currentTimeMillis();
        object2 = cachedData.getSsoServerInfos();
        l = l2 - l3;
        infoArray = new StringBuilder().append("Retrieved locations of services from LS at ").append(this._lsService.getServiceUrl()).append(" in ").append(l).append(" milliseconds:\n");
        if (_logger.isDebugEnabled()) {
            SsoLsLocatorImpl.appendExtendedSsoServerInfos((StringBuilder)infoArray, (Map<SsoDomain, SsoServerInfo>)object2);
        } else {
            infoArray.append(object2.toString());
        }
        if (l > 10000L) {
            object = ExceptionUtil.getCurrentStackTrace();
            infoArray.append('\n').append((String)object);
            _logger.warn((Object)infoArray.toString());
        } else {
            _logger.info((Object)infoArray.toString());
        }
        object = (SsoServerInfo)object2.get(SsoDomain.getLocal());
        if (object == null) {
            String string3 = "Couldn't find SSO servers for the local domain";
            _logger.error((Object)string3);
            throw new IllegalStateException(string3);
        }
        return object2;
    }

    private static void appendExtendedSsoServerInfos(StringBuilder stringBuilder, Map<SsoDomain, SsoServerInfo> map) {
        stringBuilder.append('{');
        boolean bl = true;
        for (Map.Entry<SsoDomain, SsoServerInfo> entry : map.entrySet()) {
            if (!bl) {
                stringBuilder.append(", ");
                bl = false;
            }
            stringBuilder.append(entry.getKey()).append('=');
            stringBuilder.append(entry.getValue().toExtendedString());
        }
        stringBuilder.append('}');
    }

    private Map<SsoDomain, SsoServerInfo> buildSsoServerInfoFromServiceRegistrationInfos(ServiceRegistration.Info[] infoArray) throws Exception {
        Object object;
        Object object2;
        KeyStore keyStore = this._ksService.getKeyStore();
        HashMap<Object, SsoServerInfo.Builder> hashMap = new HashMap<Object, SsoServerInfo.Builder>();
        for (ServiceRegistration.Info info : infoArray) {
            object2 = (SsoDomain)LookupUtil.getSsoDomain(info).orElse(null);
            if (object2 == null) {
                object = info.getServiceType();
                _logger.warn((Object)("Service " + info.getServiceId() + " with type " + object.getProduct() + "/" + object.getType() + " doesn't have domainId. Assuming it's the local SSO domain."));
                object2 = SsoDomain.getLocal();
            }
            if ((object = info.getServiceEndpoints()) == null || ((ServiceRegistration.Endpoint[])object).length == 0) continue;
            String string = LookupUtil.getServiceAttribute(info, "Capabilities");
            Set<String> set = LookupUtil.parseCapabilities(string);
            SsoServerInfo.Builder builder = (SsoServerInfo.Builder)hashMap.get(object2);
            if (builder == null) {
                builder = new SsoServerInfo.Builder().ssoDomain((SsoDomain)object2);
                builder.keyStore = keyStore;
                builder.vmodlVersion = this._vmodlVersion;
                hashMap.put(object2, builder);
            }
            builder.addEndpoints((ServiceRegistration.Endpoint[])object, set);
        }
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            ServiceRegistration.Info info;
            info = (SsoDomain)entry.getKey();
            object2 = (SsoServerInfo.Builder)entry.getValue();
            object = ((SsoServerInfo.Builder)object2).getInstance();
            hashMap2.put(info, object);
        }
        if (hashMap2.isEmpty()) {
            return Collections.emptyMap();
        }
        return ImmutableMap.copyOf((Map)hashMap2);
    }

    @CheckForNull
    private CachedData getValidCachedData(String string, String string2) {
        CachedData cachedData = this._cachedData;
        if (cachedData == null) {
            return null;
        }
        if (System.nanoTime() - cachedData.getCreatedOnNanos() >= Config.SSO_CACHE_REFRESH_INTERVAL_IN_NANOS) {
            return null;
        }
        String string3 = cachedData.getLsServiceUrl();
        if (!Objects.equals(string, string3)) {
            return null;
        }
        String string4 = cachedData.getDomainController();
        if (!Objects.equals(string2, string4)) {
            return null;
        }
        return cachedData;
    }

    @Immutable
    private class CachedData {
        private final String _lsServiceUrl;
        private final String _domainController;
        private final Map<SsoDomain, SsoServerInfo> _ssoServerInfos;
        private final long _createdOnNanos;

        public CachedData(String string, String string2, Map<SsoDomain, SsoServerInfo> map) {
            this._lsServiceUrl = string;
            this._domainController = string2;
            this._ssoServerInfos = map;
            this._createdOnNanos = System.nanoTime();
        }

        public String getLsServiceUrl() {
            return this._lsServiceUrl;
        }

        public String getDomainController() {
            return this._domainController;
        }

        public Map<SsoDomain, SsoServerInfo> getSsoServerInfos() {
            return this._ssoServerInfos;
        }

        public long getCreatedOnNanos() {
            return this._createdOnNanos;
        }
    }
}

