/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.sso.client.GssNegotiationClient;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.SecurityTokenServiceEx;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.annotations.VisibleForTesting;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.internal.Config;
import com.vmware.vise.vim.security.sso.SsoConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoLocator;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vise.vim.security.sso.impl.SsoUtilInternal;
import com.vmware.vise.vim.security.sso.impl.StsPoolableObjectFactory;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class SsoServiceImpl
implements SsoService {
    private volatile ConcurrentMap<SsoDomain, STSConfigHolder> _configHoldersByDomain;
    private final AtomicReference<Future<Map<SsoDomain, STSConfigHolder>>> _stsConfigHolderRefresherTaskRef = new AtomicReference<Object>(null);
    private final SsoLocator _ssoLocator;
    private boolean _useHokToken = false;
    private final SsoSolutionUser _ngcSolutionUser;
    private final KeystoreService _ksService;
    @Nonnull
    private final HttpConfigurationProvider _httpConfigProvider;
    @Nonnull
    private final SsoConfigurationProvider _ssoConfigProvider;
    private KeyPair _hokKeyPair;
    private X509Certificate _hokCertificate;
    private static final Log _logger = LogFactory.getLog(SsoServiceImpl.class);
    private static final long TASK_COMPLETION_THRESHOLD_NANOS = TimeUnit.SECONDS.toNanos(2L);
    private static final long LOCK_ACQUISITION_THRESHOLD_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private final Lock stsPoolLock = new ReentrantLock();
    private final ConcurrentMap<SsoDomain, GenericObjectPool> _stsPoolsByDomain = new ConcurrentHashMap<SsoDomain, GenericObjectPool>();
    private static final int MAX_STS_POOL_SIZE = 60;
    private static AtomicInteger _numberOfRunningTasks = new AtomicInteger(0);

    public SsoServiceImpl(@Nonnull SsoLocator ssoLocator, boolean bl, @Nullable SsoSolutionUser ssoSolutionUser, @Nonnull KeystoreService keystoreService, @Nonnull SsoConfigurationProvider ssoConfigurationProvider, @Nonnull HttpConfigurationProvider httpConfigurationProvider) {
        Validate.notNull((Object)ssoLocator);
        Validate.notNull((Object)keystoreService);
        Validate.notNull((Object)ssoConfigurationProvider);
        Validate.notNull((Object)httpConfigurationProvider);
        this._ssoLocator = ssoLocator;
        this._useHokToken = bl;
        this._ngcSolutionUser = ssoSolutionUser;
        this._ksService = keystoreService;
        this._ssoConfigProvider = ssoConfigurationProvider;
        this._httpConfigProvider = httpConfigurationProvider;
        this.initialize();
    }

    private void initialize() {
        if (this._useHokToken && (this._ngcSolutionUser == null || this._ngcSolutionUser.getCertificate() == null || this._ngcSolutionUser.getPrivateKey() == null)) {
            this.initHokCertificate();
        }
    }

    private void initHokCertificate() {
        this._hokKeyPair = SsoUtilInternal.createHokKeyPair();
        try {
            this._hokCertificate = SsoUtilInternal.createHokCertificate(this._hokKeyPair);
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when generating hok certificate.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<SecurityTokenServiceEx, STSConfigHolder> getSts(SsoDomain ssoDomain) throws Exception {
        Object object;
        SecurityTokenServiceConfig securityTokenServiceConfig = null;
        ConcurrentMap<SsoDomain, STSConfigHolder> concurrentMap = this._configHoldersByDomain;
        if (concurrentMap != null) {
            object = (STSConfigHolder)concurrentMap.get(ssoDomain);
            securityTokenServiceConfig = object != null ? ((STSConfigHolder)object).getSTSConfig() : null;
        }
        object = this.getStsConfigs();
        STSConfigHolder sTSConfigHolder = SsoServiceImpl.getStsConfigHolder(object, ssoDomain);
        SecurityTokenServiceConfig securityTokenServiceConfig2 = sTSConfigHolder.getSTSConfig();
        long l = System.nanoTime();
        SsoServiceImpl ssoServiceImpl = this;
        synchronized (ssoServiceImpl) {
            long l2 = System.nanoTime() - l;
            if (l2 > LOCK_ACQUISITION_THRESHOLD_NANOS) {
                _logger.warn((Object)("Acquisition of lock in getSts() took too long: " + TimeUnit.NANOSECONDS.toMillis(l2) + " ms"));
            }
            GenericObjectPool genericObjectPool = this.getStsObjectPool(ssoDomain, securityTokenServiceConfig, securityTokenServiceConfig2);
            SecurityTokenServiceEx securityTokenServiceEx = (SecurityTokenServiceEx)genericObjectPool.borrowObject();
            return new Pair((Object)securityTokenServiceEx, (Object)sTSConfigHolder);
        }
    }

    @Nonnull
    private static STSConfigHolder getStsConfigHolder(@Nonnull Map<SsoDomain, STSConfigHolder> map, @Nonnull SsoDomain ssoDomain) throws SsoServiceException {
        STSConfigHolder sTSConfigHolder = map.get(ssoDomain);
        if (sTSConfigHolder == null) {
            throw new SsoServiceException("Domain " + ssoDomain.getId() + " not found");
        }
        return sTSConfigHolder;
    }

    private synchronized void clearStsPool(SsoDomain ssoDomain) {
        GenericObjectPool genericObjectPool = (GenericObjectPool)this._stsPoolsByDomain.remove(ssoDomain);
        if (genericObjectPool == null) {
            return;
        }
        try {
            genericObjectPool.close();
        }
        catch (Exception exception) {
            _logger.error((Object)"Error while closing STS pool", (Throwable)exception);
        }
    }

    private GenericObjectPool getStsObjectPool(SsoDomain ssoDomain, SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenServiceConfig securityTokenServiceConfig2) throws Exception {
        GenericObjectPool genericObjectPool = (GenericObjectPool)this._stsPoolsByDomain.get(ssoDomain);
        if (genericObjectPool != null && securityTokenServiceConfig == securityTokenServiceConfig2) {
            return genericObjectPool;
        }
        this.clearStsPool(ssoDomain);
        genericObjectPool = this.createStsObjectPool(ssoDomain, securityTokenServiceConfig2);
        return genericObjectPool;
    }

    private void returnSts(SsoDomain ssoDomain, SecurityTokenService securityTokenService) {
        if (securityTokenService == null) {
            return;
        }
        GenericObjectPool genericObjectPool = (GenericObjectPool)this._stsPoolsByDomain.get(ssoDomain);
        if (genericObjectPool == null) {
            return;
        }
        try {
            genericObjectPool.returnObject((Object)securityTokenService);
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when returning STS instance back to the pool", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<SsoDomain, STSConfigHolder> getStsConfigs() throws Exception {
        boolean bl;
        long l;
        Object object;
        ConcurrentMap<SsoDomain, STSConfigHolder> concurrentMap;
        block17: {
            boolean bl2;
            do {
                if ((object = this._stsConfigHolderRefresherTaskRef.get()) == null) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("An STS config refresher task already exists. (" + object + ") Will wait for its result."));
                }
                l = System.nanoTime();
                bl = false;
                break block17;
            } while (!(bl2 = this._stsConfigHolderRefresherTaskRef.compareAndSet((Future<Map<SsoDomain, STSConfigHolder>>)null, (Future<Map<SsoDomain, STSConfigHolder>>)((Object)(concurrentMap = new FutureTask<Map<SsoDomain, STSConfigHolder>>(new StsConfigsRefresherTask()))))));
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Will run an STS config refresher task in the current thread: " + concurrentMap));
                }
                object = concurrentMap;
                bl = true;
                l = System.nanoTime();
                ((FutureTask)((Object)concurrentMap)).run();
            }
            finally {
                this._stsConfigHolderRefresherTaskRef.compareAndSet((Future<Map<SsoDomain, STSConfigHolder>>)((Object)concurrentMap), (Future<Map<SsoDomain, STSConfigHolder>>)null);
            }
        }
        Exception exception = null;
        try {
            concurrentMap = object.get(Config.SSO_SERVICE_IMPL_REFRESHER_TASK_TIMEOUT_MS, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception2) {
            exception = exception2;
            concurrentMap = this._configHoldersByDomain;
            if (concurrentMap == null) {
                throw exception2;
            }
            _logger.error((Object)"The retrieval of STSConfig failed but since we have a previous cached instance, we'll use it and hopefully it will do the job", (Throwable)exception2);
        }
        finally {
            long l2 = System.nanoTime() - l;
            if (l2 > TASK_COMPLETION_THRESHOLD_NANOS) {
                _logger.warn((Object)("An STS config refresher task took too long: " + TimeUnit.NANOSECONDS.toMillis(l2) + " ms;  ranTaskInThisThread=" + bl + ", task=" + object));
            } else if (_logger.isDebugEnabled()) {
                if (exception != null) {
                    _logger.debug((Object)("STS config refresher task failed: " + exception));
                } else {
                    _logger.debug((Object)"STS config refresher task completed");
                }
            }
        }
        return concurrentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private GenericObjectPool createStsObjectPool(SsoDomain ssoDomain, SecurityTokenServiceConfig securityTokenServiceConfig) throws Exception {
        long l = System.nanoTime();
        SsoServiceImpl ssoServiceImpl = this;
        synchronized (ssoServiceImpl) {
            GenericObjectPool genericObjectPool;
            long l2 = System.nanoTime() - l;
            if (l2 > LOCK_ACQUISITION_THRESHOLD_NANOS) {
                _logger.warn((Object)("Acquisition of lock in createStsObjectPool() took too long: " + l2 + " ms"));
            }
            if ((genericObjectPool = (GenericObjectPool)this._stsPoolsByDomain.get(ssoDomain)) != null) {
                return genericObjectPool;
            }
            _logger.debug((Object)"createStsObjectPool(): start");
            this.stsPoolLock.lock();
            try {
                genericObjectPool = (GenericObjectPool)this._stsPoolsByDomain.get(ssoDomain);
                if (genericObjectPool != null) {
                    GenericObjectPool genericObjectPool2 = genericObjectPool;
                    return genericObjectPool2;
                }
                StsPoolableObjectFactory stsPoolableObjectFactory = new StsPoolableObjectFactory(securityTokenServiceConfig);
                GenericObjectPool.Config config = new GenericObjectPool.Config();
                config.maxActive = 60;
                config.whenExhaustedAction = 1;
                config.testOnReturn = true;
                genericObjectPool = new GenericObjectPool((PoolableObjectFactory)stsPoolableObjectFactory, config);
                GenericObjectPool genericObjectPool3 = this._stsPoolsByDomain.putIfAbsent(ssoDomain, genericObjectPool);
                if (genericObjectPool3 != null) {
                    try {
                        genericObjectPool.close();
                    }
                    catch (Exception exception) {
                        _logger.error((Object)"Error while closing STS pool", (Throwable)exception);
                    }
                    genericObjectPool = genericObjectPool3;
                }
                GenericObjectPool genericObjectPool4 = genericObjectPool;
                return genericObjectPool4;
            }
            finally {
                this.stsPoolLock.unlock();
                _logger.debug((Object)"createStsObjectPool(): end");
            }
        }
    }

    @Override
    public SsoServerInfo getServerInfo() throws Exception {
        Map<SsoDomain, SsoServerInfo> map = this.getServerInfos();
        SsoServerInfo ssoServerInfo = SsoUtil.getSsoServerInfo(map, SsoDomain.getLocal());
        return ssoServerInfo;
    }

    @Override
    public Map<SsoDomain, SsoServerInfo> getServerInfos() throws Exception {
        return this._ssoLocator.getSsoServerInfos();
    }

    @Override
    public X509Certificate[] getStsCertificates() {
        return this.getStsCertificates(SsoDomain.getLocal());
    }

    @Override
    public X509Certificate[] getStsCertificates(SsoDomain ssoDomain) {
        Validate.notNull((Object)ssoDomain);
        try {
            Map<SsoDomain, STSConfigHolder> map = this.getStsConfigs();
            STSConfigHolder sTSConfigHolder = SsoServiceImpl.getStsConfigHolder(map, ssoDomain);
            SecurityTokenServiceConfig securityTokenServiceConfig = sTSConfigHolder.getSTSConfig();
            return securityTokenServiceConfig.getTrustedRootCertificates();
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when fetching sts root certificates ", (Throwable)exception);
            return null;
        }
    }

    @Override
    public SamlToken acquireToken(String string, String string2, TokenSpec tokenSpec) throws SsoServiceException {
        return this.acquireToken(SsoDomain.getLocal(), string, string2, tokenSpec);
    }

    @Override
    public SamlToken acquireToken(SsoDomain ssoDomain, String string, String string2, TokenSpec tokenSpec) throws SsoServiceException {
        Validate.notNull((Object)ssoDomain);
        SecurityTokenService securityTokenService = null;
        try {
            SamlToken samlToken;
            Pair<SecurityTokenServiceEx, STSConfigHolder> pair = this.getSts(ssoDomain);
            securityTokenService = (SecurityTokenService)pair.first;
            SecurityTokenServiceConfig securityTokenServiceConfig = ((STSConfigHolder)pair.second).getSTSConfig();
            SamlToken samlToken2 = samlToken = SsoUtilInternal.acquireToken(securityTokenServiceConfig, securityTokenService, string, string2, tokenSpec);
            this.returnSts(ssoDomain, securityTokenService);
            return samlToken2;
        }
        catch (Exception exception) {
            try {
                throw new SsoServiceException(exception);
            }
            catch (Throwable throwable) {
                this.returnSts(ssoDomain, securityTokenService);
                throw throwable;
            }
        }
    }

    @Override
    public GssNegotiationClient obtainGssNegotiationClient(TokenSpec tokenSpec) throws SsoServiceException {
        return this.obtainGssNegotiationClient(SsoDomain.getLocal(), tokenSpec);
    }

    @Override
    public GssNegotiationClient obtainGssNegotiationClient(SsoDomain ssoDomain, TokenSpec tokenSpec) throws SsoServiceException {
        Validate.notNull((Object)ssoDomain);
        SecurityTokenService securityTokenService = null;
        try {
            Pair<SecurityTokenServiceEx, STSConfigHolder> pair = this.getSts(ssoDomain);
            securityTokenService = (SecurityTokenService)pair.first;
            SecurityTokenServiceConfig securityTokenServiceConfig = ((STSConfigHolder)pair.second).getSTSConfig();
            GssNegotiationClient gssNegotiationClient = SsoUtilInternal.obtainGssNegotiationClient(securityTokenServiceConfig, securityTokenService, tokenSpec);
            this.returnSts(ssoDomain, securityTokenService);
            return gssNegotiationClient;
        }
        catch (Exception exception) {
            try {
                throw new SsoServiceException(exception);
            }
            catch (Throwable throwable) {
                this.returnSts(ssoDomain, securityTokenService);
                throw throwable;
            }
        }
    }

    @Override
    public SamlToken negotiateToken(GssNegotiationClient gssNegotiationClient, String string) throws SsoServiceException {
        try {
            return SsoUtilInternal.negotiateToken(gssNegotiationClient, string);
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
    }

    @Override
    @Deprecated
    public SamlToken acquireTokenByToken(SamlToken samlToken, TokenSpec tokenSpec) throws SsoServiceException {
        SsoDomain ssoDomain = SsoDomain.getLocal();
        return this.acquireTokenByToken(ssoDomain, ssoDomain, samlToken, tokenSpec);
    }

    @Override
    public SamlToken acquireTokenByToken(SsoDomain ssoDomain, SsoDomain ssoDomain2, SamlToken samlToken, TokenSpec tokenSpec) throws SsoServiceException {
        Validate.notNull((Object)ssoDomain);
        Validate.notNull((Object)ssoDomain2);
        SecurityTokenServiceEx securityTokenServiceEx = null;
        try {
            SamlToken samlToken2;
            _logger.debug((Object)"Getting STS pair");
            Pair<SecurityTokenServiceEx, STSConfigHolder> pair = this.getSts(ssoDomain);
            _logger.debug((Object)"Got STS pair");
            securityTokenServiceEx = (SecurityTokenServiceEx)pair.first;
            STSConfigHolder sTSConfigHolder = (STSConfigHolder)pair.second;
            SecurityTokenServiceConfig securityTokenServiceConfig = sTSConfigHolder.getSTSConfig();
            SsoServerInfo ssoServerInfo = sTSConfigHolder.getServerInfo();
            SamlToken samlToken3 = samlToken2 = SsoUtilInternal.acquireTokenByToken(ssoServerInfo, securityTokenServiceConfig, securityTokenServiceEx, ssoDomain2, samlToken, tokenSpec);
            this.returnSts(ssoDomain, (SecurityTokenService)securityTokenServiceEx);
            return samlToken3;
        }
        catch (Exception exception) {
            try {
                throw new SsoServiceException(exception);
            }
            catch (Throwable throwable) {
                this.returnSts(ssoDomain, (SecurityTokenService)securityTokenServiceEx);
                throw throwable;
            }
        }
    }

    @Override
    public SamlToken buildToken(String string) throws SsoServiceException {
        return this.buildToken(SsoDomain.getLocal(), string);
    }

    @Override
    public SamlToken buildToken(SsoDomain ssoDomain, String string) throws SsoServiceException {
        try {
            Map<SsoDomain, STSConfigHolder> map = this.getStsConfigs();
            STSConfigHolder sTSConfigHolder = SsoServiceImpl.getStsConfigHolder(map, ssoDomain);
            SecurityTokenServiceConfig securityTokenServiceConfig = sTSConfigHolder.getSTSConfig();
            SamlToken samlToken = SsoUtilInternal.buildToken(securityTokenServiceConfig, string);
            return samlToken;
        }
        catch (Exception exception) {
            throw new SsoServiceException(exception);
        }
    }

    @Override
    public SamlToken renewToken(SamlToken samlToken, long l) throws SsoServiceException {
        return this.renewToken(SsoDomain.getLocal(), samlToken, l);
    }

    @Override
    public SamlToken renewToken(SsoDomain ssoDomain, SamlToken samlToken, long l) throws SsoServiceException {
        Validate.notNull((Object)ssoDomain);
        SecurityTokenService securityTokenService = null;
        try {
            SamlToken samlToken2;
            Pair<SecurityTokenServiceEx, STSConfigHolder> pair = this.getSts(ssoDomain);
            securityTokenService = (SecurityTokenService)pair.first;
            STSConfigHolder sTSConfigHolder = (STSConfigHolder)pair.second;
            SecurityTokenServiceConfig securityTokenServiceConfig = sTSConfigHolder.getSTSConfig();
            SamlToken samlToken3 = samlToken2 = SsoUtilInternal.renewToken(securityTokenServiceConfig, securityTokenService, samlToken, l);
            this.returnSts(ssoDomain, securityTokenService);
            return samlToken3;
        }
        catch (Exception exception) {
            try {
                throw new SsoServiceException(exception);
            }
            catch (Throwable throwable) {
                this.returnSts(ssoDomain, securityTokenService);
                throw throwable;
            }
        }
    }

    @Override
    public boolean validateToken(SamlToken samlToken) throws SsoServiceException {
        return this.validateToken(SsoDomain.getLocal(), samlToken);
    }

    @Override
    public boolean validateToken(SsoDomain ssoDomain, SamlToken samlToken) throws SsoServiceException {
        Validate.notNull((Object)ssoDomain);
        SecurityTokenService securityTokenService = null;
        try {
            boolean bl;
            Pair<SecurityTokenServiceEx, STSConfigHolder> pair = this.getSts(ssoDomain);
            securityTokenService = (SecurityTokenService)pair.first;
            STSConfigHolder sTSConfigHolder = (STSConfigHolder)pair.second;
            SecurityTokenServiceConfig securityTokenServiceConfig = sTSConfigHolder.getSTSConfig();
            boolean bl2 = bl = SsoUtilInternal.validateToken(securityTokenServiceConfig, securityTokenService, samlToken);
            this.returnSts(ssoDomain, securityTokenService);
            return bl2;
        }
        catch (Exception exception) {
            try {
                throw new SsoServiceException(exception);
            }
            catch (Throwable throwable) {
                this.returnSts(ssoDomain, securityTokenService);
                throw throwable;
            }
        }
    }

    @Override
    public PrivateKey getHokPrivateKey() {
        if (!this._useHokToken) {
            return null;
        }
        if (this._ngcSolutionUser != null && this._ngcSolutionUser.getPrivateKey() != null) {
            return this._ngcSolutionUser.getPrivateKey();
        }
        return this._hokKeyPair.getPrivate();
    }

    @Override
    public X509Certificate getHokCertificate() {
        if (!this._useHokToken) {
            return null;
        }
        if (this._ngcSolutionUser != null && this._ngcSolutionUser.getCertificate() != null) {
            return this._ngcSolutionUser.getCertificate();
        }
        return this._hokCertificate;
    }

    @Override
    public boolean checkTokenLifetime(SamlToken samlToken) throws InvalidTokenException {
        return SsoUtilInternal.checkTokenLifetime(samlToken);
    }

    private void checkHokCertificateValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        if (!this._useHokToken) {
            return;
        }
        X509Certificate x509Certificate = null;
        try {
            if (this._ngcSolutionUser != null && (x509Certificate = this._ngcSolutionUser.getCertificate()) != null) {
                x509Certificate.checkValidity();
                return;
            }
            x509Certificate = this._hokCertificate;
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            _logger.info((Object)("The client certificate has expired at " + x509Certificate.getNotAfter()));
            throw certificateExpiredException;
        }
    }

    public void shutdown() {
        ConcurrentMap<SsoDomain, STSConfigHolder> concurrentMap;
        Future<Map<SsoDomain, STSConfigHolder>> future = this._stsConfigHolderRefresherTaskRef.get();
        if (future != null) {
            future.cancel(true);
        }
        if ((concurrentMap = this._configHoldersByDomain) != null) {
            this.shutdown(null);
            this._configHoldersByDomain = null;
        }
    }

    private void shutdown(@Nullable Collection<SsoDomain> collection) {
        ConcurrentMap<SsoDomain, STSConfigHolder> concurrentMap = this._configHoldersByDomain;
        if (concurrentMap != null) {
            Iterator iterator = concurrentMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SsoDomain ssoDomain = (SsoDomain)entry.getKey();
                if (collection != null && !collection.contains(ssoDomain)) continue;
                this.clearStsPool(ssoDomain);
                iterator.remove();
            }
        }
    }

    private class StsConfigsRefresherTask
    implements Callable<Map<SsoDomain, STSConfigHolder>> {
        private StsConfigsRefresherTask() {
        }

        @Override
        public Map<SsoDomain, STSConfigHolder> call() throws Exception {
            int n = _numberOfRunningTasks.incrementAndGet();
            if (n > 1) {
                _logger.warn((Object)("Multiple STSConfigRefresherTask are running: " + n + "\n" + ExceptionUtil.getCurrentStackTrace()));
            }
            try {
                SsoDomain ssoDomain;
                Object object;
                SsoDomain ssoDomain22;
                Map<Object, SsoServerInfo> map;
                Collection<SsoDomain> collection;
                _logger.debug((Object)"Running an STSConfigRefresherTask");
                Map<SsoDomain, SsoServerInfo> map2 = SsoServiceImpl.this._ssoLocator.getSsoServerInfos();
                _logger.debug((Object)"Fetched the ssoInfo");
                if (map2 == null) {
                    throw new NullPointerException("SsoServerInfos should be non-null.");
                }
                ConcurrentMap concurrentMap = SsoServiceImpl.this._configHoldersByDomain;
                if (concurrentMap == null) {
                    collection = map2.keySet();
                    map = map2;
                } else {
                    collection = this.findMismatchingDomains(map2, concurrentMap);
                    if (collection.isEmpty()) {
                        map = Collections.emptyMap();
                    } else {
                        map = new HashMap<SsoDomain, SsoServerInfo>();
                        for (SsoDomain ssoDomain22 : collection) {
                            object = map2.get(ssoDomain22);
                            if (object == null) continue;
                            map.put(ssoDomain22, (SsoServerInfo)object);
                        }
                    }
                }
                if (collection.isEmpty()) {
                    ssoDomain = concurrentMap;
                } else {
                    _logger.debug((Object)"Creating a new STSConfigHolder");
                    ssoDomain22 = null;
                    if (SsoServiceImpl.this._useHokToken) {
                        ssoDomain22 = new SecurityTokenServiceConfig.HolderOfKeyConfig((Key)SsoServiceImpl.this.getHokPrivateKey(), SsoServiceImpl.this.getHokCertificate(), null);
                    }
                    SsoServiceImpl.this.shutdown(collection);
                    if (!map.isEmpty()) {
                        SsoDomain ssoDomain3;
                        object = SsoUtilInternal.createStsConfigurations(map, (SecurityTokenServiceConfig.HolderOfKeyConfig)ssoDomain22, SsoServiceImpl.this._ksService, SsoServiceImpl.this._ssoConfigProvider, SsoServiceImpl.this._httpConfigProvider);
                        ssoDomain = new SsoDomain();
                        if (concurrentMap != null) {
                            for (Map.Entry entry : concurrentMap.entrySet()) {
                                ssoDomain3 = (SsoDomain)entry.getKey();
                                if (map.containsKey(ssoDomain3)) continue;
                                ssoDomain.put(ssoDomain3, entry.getValue());
                            }
                        }
                        for (Map.Entry entry : object.entrySet()) {
                            ssoDomain3 = (SsoDomain)entry.getKey();
                            SecurityTokenServiceConfig securityTokenServiceConfig = (SecurityTokenServiceConfig)entry.getValue();
                            SsoServerInfo ssoServerInfo = map2.get(ssoDomain3);
                            if (ssoServerInfo == null) {
                                _logger.warn((Object)("Missing ssoInfo for SSO domain " + ssoDomain3.getId()));
                                continue;
                            }
                            STSConfigHolder sTSConfigHolder = new STSConfigHolder(securityTokenServiceConfig, ssoServerInfo);
                            ssoDomain.put(ssoDomain3, sTSConfigHolder);
                        }
                        SsoServiceImpl.this._configHoldersByDomain = ssoDomain;
                        _logger.debug((Object)"Created the STSConfigHolders");
                    } else {
                        ssoDomain = concurrentMap;
                    }
                }
                SsoServiceImpl.this.checkHokCertificateValidity();
                _logger.debug((Object)"Checked the HoK ceritifcate validity");
                ssoDomain22 = ssoDomain;
                return ssoDomain22;
            }
            catch (Exception exception) {
                if ((exception instanceof InternalException || exception instanceof SslException) && exception.getCause() instanceof Exception) {
                    throw (Exception)exception.getCause();
                }
                throw exception;
            }
            finally {
                _numberOfRunningTasks.decrementAndGet();
            }
        }

        @Nonnull
        private Collection<SsoDomain> findMismatchingDomains(Map<SsoDomain, SsoServerInfo> map, Map<SsoDomain, STSConfigHolder> map2) {
            ArrayList<SsoDomain> arrayList = new ArrayList<SsoDomain>();
            for (Map.Entry<SsoDomain, SsoServerInfo> ssoDomain : map.entrySet()) {
                SsoServerInfo ssoServerInfo;
                SsoDomain ssoDomain2 = ssoDomain.getKey();
                STSConfigHolder sTSConfigHolder = map2.get(ssoDomain2);
                if (sTSConfigHolder == null) {
                    arrayList.add(ssoDomain2);
                    continue;
                }
                SsoServerInfo ssoServerInfo2 = ssoDomain.getValue();
                if (ssoServerInfo2.equals(ssoServerInfo = sTSConfigHolder.getServerInfo())) continue;
                arrayList.add(ssoDomain2);
            }
            for (SsoDomain ssoDomain : map2.keySet()) {
                if (map.containsKey(ssoDomain)) continue;
                arrayList.add(ssoDomain);
            }
            if (arrayList.isEmpty()) {
                return Collections.emptyList();
            }
            return arrayList;
        }
    }

    @VisibleForTesting
    static class STSConfigHolder {
        private final SecurityTokenServiceConfig _config;
        private final SsoServerInfo _info;

        public STSConfigHolder(SecurityTokenServiceConfig securityTokenServiceConfig, SsoServerInfo ssoServerInfo) {
            this._config = securityTokenServiceConfig;
            this._info = ssoServerInfo;
        }

        public SecurityTokenServiceConfig getSTSConfig() {
            return this._config;
        }

        public SsoServerInfo getServerInfo() {
            return this._info;
        }
    }
}

