/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceProvider;
import com.vmware.vise.vim.security.sso.SsoUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoServiceProviderImpl
implements SsoServiceProvider,
UserSessionListener {
    private static final Log _logger = LogFactory.getLog(SsoServiceProviderImpl.class);
    private static final String SSO_ADMIN_SERVICE_SESSION_KEY = "#Map<SsoDomain, SsoAdminService>#";
    private final SsoService _ssoService;
    private final HttpConfigurationProvider _httpConfigProvider;
    Map<SsoDomain, SsoAdminService> _solutionAdminServices = new HashMap<SsoDomain, SsoAdminService>();

    public SsoServiceProviderImpl(@Nonnull SsoService ssoService, @Nonnull HttpConfigurationProvider httpConfigurationProvider) {
        this(true, (SsoService)ValidationUtil.notNull((Object)ssoService, (String)"ssoservice is null"), (HttpConfigurationProvider)ValidationUtil.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null"));
    }

    private SsoServiceProviderImpl(boolean bl, SsoService ssoService, HttpConfigurationProvider httpConfigurationProvider) {
        this._ssoService = ssoService;
        this._httpConfigProvider = httpConfigurationProvider;
    }

    public SsoAdminService getAdminService(Object object, SsoDomain ssoDomain) {
        return this.getAdminService(ssoDomain);
    }

    public SsoAdminService getAdminService(SsoDomain ssoDomain) {
        SsoAdminService ssoAdminService;
        Map map = (Map)SessionUtil.getData((String)SSO_ADMIN_SERVICE_SESSION_KEY);
        if (map != null && (ssoAdminService = (SsoAdminService)map.get(ssoDomain)) != null) {
            return ssoAdminService;
        }
        return this.getAdminServiceSynchronized(ssoDomain);
    }

    private synchronized SsoAdminService getAdminServiceSynchronized(SsoDomain ssoDomain) {
        SsoAdminService ssoAdminService;
        HashMap<SsoDomain, SsoAdminService> hashMap = (HashMap<SsoDomain, SsoAdminService>)SessionUtil.getData((String)SSO_ADMIN_SERVICE_SESSION_KEY);
        if (hashMap == null) {
            hashMap = new HashMap<SsoDomain, SsoAdminService>();
            SessionUtil.setData((String)SSO_ADMIN_SERVICE_SESSION_KEY, hashMap, (boolean)false);
        }
        if ((ssoAdminService = (SsoAdminService)hashMap.get(ssoDomain)) != null) {
            return ssoAdminService;
        }
        try {
            SsoServerInfo ssoServerInfo = SsoUtil.getSsoServerInfo(this._ssoService.getServerInfos(), ssoDomain);
            ssoAdminService = SsoUtil.getAdminService(ssoServerInfo, this._ssoService, AuthSessionUtil.getSsoToken((SsoDomain)ssoDomain), this._httpConfigProvider);
            hashMap.put(ssoDomain, ssoAdminService);
            return ssoAdminService;
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed getting SSO admin service: " + exception.getMessage()));
            throw new RuntimeException(exception);
        }
    }

    public SsoAdminService getSolutionAdminService(Object object, SsoDomain ssoDomain) {
        return this.getSolutionAdminService(ssoDomain);
    }

    public SsoAdminService getSolutionAdminService(SsoDomain ssoDomain) {
        SsoAdminService ssoAdminService = this._solutionAdminServices.get(ssoDomain);
        if (ssoAdminService != null) {
            return ssoAdminService;
        }
        return this.getSolutionAdminServiceSynchronized(ssoDomain);
    }

    private synchronized SsoAdminService getSolutionAdminServiceSynchronized(SsoDomain ssoDomain) {
        SsoAdminService ssoAdminService = this._solutionAdminServices.get(ssoDomain);
        if (ssoAdminService != null) {
            return ssoAdminService;
        }
        try {
            SsoServerInfo ssoServerInfo = SsoUtil.getSsoServerInfo(this._ssoService.getServerInfos(), ssoDomain);
            ssoAdminService = SsoUtil.getAdminService(ssoServerInfo, this._ssoService, SsoUtil.getSolutionUser(), this._httpConfigProvider);
            this._solutionAdminServices.put(ssoDomain, ssoAdminService);
            return ssoAdminService;
        }
        catch (Exception exception) {
            _logger.error((Object)("Falied getting SSO solution admin service: " + exception.getMessage()));
            throw new RuntimeException(exception);
        }
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        Map map = (Map)SessionUtil.getData((String)SSO_ADMIN_SERVICE_SESSION_KEY);
        if (map != null) {
            try {
                for (Map.Entry entry : map.entrySet()) {
                    ((SsoAdminService)entry.getValue()).logout();
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"Failed to log out of the SsoAdminService", (Throwable)exception);
            }
        }
    }
}

