/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.sso.impl;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.ServiceContent;
import com.vmware.vim.binding.sso.admin.ServiceInstance;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.binding.sso.version.version1_5;
import com.vmware.vim.binding.sso.version.version3_2;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidRequest;
import com.vmware.vim.sso.client.DefaultSecurityTokenServiceFactory;
import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.GssNegotiationClient;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.SecurityTokenServiceEx;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.InternalError;
import com.vmware.vim.sso.client.exception.InvalidTimingException;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.RequestExpiredException;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import com.vmware.vim.sso.client.exception.ServerSecurityException;
import com.vmware.vim.sso.client.exception.SsoException;
import com.vmware.vim.sso.client.exception.TimeSynchronizationException;
import com.vmware.vim.sso.client.exception.TokenRequestRejectedException;
import com.vmware.vim.sso.client.util.codec.Base64;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.RequestRetryCallback;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.DiagnosticThreadPoolExecutor;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.NonSilentCallerRunsPolicy;
import com.vmware.vise.util.concurrent.ThreadPoolManager;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vmomi.ClientWithSharedHttpConfig;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.commons.vmomi.OpIdAwareClientFactory;
import com.vmware.vise.vim.commons.vmomi.VmomiClientHelper;
import com.vmware.vise.vim.connections.SiteAffinityServerEndpointProvider;
import com.vmware.vise.vim.internal.Config;
import com.vmware.vise.vim.security.sso.SsoConfigurationProvider;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.security.sso.exception.SsoSspiChallenge;
import com.vmware.vise.vim.security.sso.impl.ProxyingClient;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V1CertificateGenerator;

final class SsoUtilInternal {
    private static final Log _logger = LogFactory.getLog(SsoUtilInternal.class);
    private static final String SSO_VERSION_NOT_SUPPORTED = "Request version 'urn:sso/version[^']+' and namespace 'urn:sso' are not supported";
    private static final String SSO_ADMIN_CLIENT_HTTP_CONFIG_ID = "#ssoAdminClientHttpConfigId#";
    private static final Class<?> BASE_VMODL_VERSION = version3_2.class;
    private static final ExecutorService EXECUTOR;

    SsoUtilInternal() {
    }

    public static synchronized X509Certificate createHokCertificate(KeyPair keyPair) throws InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException {
        _logger.info((Object)"Generating a temporary client certificate to be used with HOK tokens");
        String string = "C=AU, O=VMware vSphere Client, OU=VMware vSphere Client Temporary Certificate";
        String string2 = "C=AU, O=VMware vSphere Client, OU=VMware vSphere Client Temporary Certificate";
        X509V1CertificateGenerator x509V1CertificateGenerator = new X509V1CertificateGenerator();
        x509V1CertificateGenerator.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        x509V1CertificateGenerator.setIssuerDN((X509Name)new X509Principal(string));
        x509V1CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis() - 31536000000L));
        x509V1CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 31536000000L));
        x509V1CertificateGenerator.setSubjectDN((X509Name)new X509Principal(string2));
        x509V1CertificateGenerator.setPublicKey(keyPair.getPublic());
        x509V1CertificateGenerator.setSignatureAlgorithm("SHA1WithRSAEncryption");
        X509Certificate x509Certificate = x509V1CertificateGenerator.generate(keyPair.getPrivate());
        x509Certificate.checkValidity(new Date());
        x509Certificate.verify(keyPair.getPublic());
        return x509Certificate;
    }

    @Deprecated
    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, RequestRetryCallback requestRetryCallback, Class<?> clazz) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, requestRetryCallback, clazz, (HttpConfigurationProvider)SsoUtil.getLegacyHttpConfigPool());
    }

    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, RequestRetryCallback requestRetryCallback, Class<?> clazz, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, requestRetryCallback, clazz, httpConfigurationProvider, true);
    }

    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, RequestRetryCallback requestRetryCallback, Class<?> clazz, @Nonnull HttpConfigurationProvider httpConfigurationProvider, boolean bl) throws URISyntaxException {
        Object object;
        URI uRI;
        Validate.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null");
        String string = ssoServerInfo.getAdminAppUrl();
        URI uRI2 = new URI(string);
        KeyStore keyStore = ssoServerInfo.getKeyStore();
        HttpConfiguration httpConfiguration = httpConfigurationProvider.getHttpConfig(SSO_ADMIN_CLIENT_HTTP_CONFIG_ID, keyStore, null);
        HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
        SsoDomain ssoDomain = ssoServerInfo.getSsoDomain();
        httpClientConfiguration.setHttpConfiguration(httpConfiguration);
        if (requestRetryCallback != null) {
            httpClientConfiguration.setRequestRetryCallback(requestRetryCallback);
        }
        if (bl) {
            uRI = null;
            object = new SiteAffinityServerEndpointProvider(ssoDomain, uRI2);
            httpClientConfiguration.setServerEndpointProvider((ServerEndpointProvider)object);
        } else {
            uRI = uRI2;
        }
        object = uRI;
        Client client = SsoUtilInternal.createSsoAdminVmomiClient((URI)object, clazz, httpClientConfiguration, httpConfigurationProvider);
        ProxyingClient proxyingClient = new ProxyingClient(client, clazz, BASE_VMODL_VERSION, new ProxyingClient.VmomiClientFactory((URI)object, httpClientConfiguration, httpConfigurationProvider){
            final /* synthetic */ URI val$vmomiClientUri;
            final /* synthetic */ HttpClientConfiguration val$httpClientConfig;
            final /* synthetic */ HttpConfigurationProvider val$httpConfigProvider;
            {
                this.val$vmomiClientUri = uRI;
                this.val$httpClientConfig = httpClientConfiguration;
                this.val$httpConfigProvider = httpConfigurationProvider;
            }

            @Override
            public Client createClient(Class<?> clazz) {
                return SsoUtilInternal.createSsoAdminVmomiClient(this.val$vmomiClientUri, clazz, this.val$httpClientConfig, this.val$httpConfigProvider);
            }
        }, false, null, -1, null);
        return proxyingClient;
    }

    private static Client createSsoAdminVmomiClient(@Nullable URI uRI, @Nonnull Class<?> clazz, @Nonnull HttpClientConfiguration httpClientConfiguration, @Nonnull HttpConfigurationProvider httpConfigurationProvider) {
        Client client = OpIdAwareClientFactory.createClient((URI)uRI, clazz, (ClientConfiguration)httpClientConfiguration);
        ClientWithSharedHttpConfig clientWithSharedHttpConfig = new ClientWithSharedHttpConfig(client, httpConfigurationProvider, SSO_ADMIN_CLIENT_HTTP_CONFIG_ID);
        return clientWithSharedHttpConfig;
    }

    @Deprecated
    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, RequestRetryCallback requestRetryCallback) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, requestRetryCallback, ssoServerInfo.getVmodlVersion());
    }

    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, RequestRetryCallback requestRetryCallback, HttpConfigurationProvider httpConfigurationProvider) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, requestRetryCallback, httpConfigurationProvider, true);
    }

    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, RequestRetryCallback requestRetryCallback, HttpConfigurationProvider httpConfigurationProvider, boolean bl) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, requestRetryCallback, ssoServerInfo.getVmodlVersion(), httpConfigurationProvider, bl);
    }

    @Deprecated
    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, (RequestRetryCallback)null);
    }

    public static Client createSsoAdminClient(SsoServerInfo ssoServerInfo, HttpConfigurationProvider httpConfigurationProvider) throws URISyntaxException {
        return SsoUtilInternal.createSsoAdminClient(ssoServerInfo, null, httpConfigurationProvider);
    }

    public static ServiceContent getSsoAdminServiceContent(Client client) throws InvalidCredentials, ServiceFault {
        if (client == null) {
            throw new IllegalArgumentException("ssoAdminClient");
        }
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(ServiceInstance.class);
        ManagedObjectReference managedObjectReference = new ManagedObjectReference(vmodlType.getWsdlName(), "SsoAdminServiceInstance");
        ServiceInstance serviceInstance = (ServiceInstance)VmomiClientHelper.createStub((Client)client, ServiceInstance.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoUtilInternal.class.getClassLoader());
        return serviceInstance.retrieveServiceContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] getStsIssuersCertificates(SsoServerInfo ssoServerInfo, @Nullable HttpConfigurationProvider httpConfigurationProvider) throws URISyntaxException, ServiceFault, CertificateException {
        Client client = null;
        try {
            String string;
            _logger.info((Object)("Requesting all STS trusted root certificates from " + ssoServerInfo.getAdminAppUrl()));
            if (httpConfigurationProvider == null) {
                httpConfigurationProvider = SsoUtil.getLegacyHttpConfigPool();
            }
            client = SsoUtilInternal.createSsoAdminClient(ssoServerInfo, httpConfigurationProvider);
            ServiceContent serviceContent = null;
            try {
                serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
            }
            catch (InvalidRequest invalidRequest) {
                string = invalidRequest.getMessage();
                if (string != null && string.matches(SSO_VERSION_NOT_SUPPORTED)) {
                    client = SsoUtilInternal.createSsoAdminClient(ssoServerInfo, null, version1_5.class, httpConfigurationProvider);
                    serviceContent = SsoUtilInternal.getSsoAdminServiceContent(client);
                }
                throw new RuntimeException(invalidRequest);
            }
            ManagedObjectReference managedObjectReference = serviceContent.getConfigurationManagementService();
            string = (ConfigurationManagementService)VmomiClientHelper.createStub((Client)client, ConfigurationManagementService.class, (ManagedObjectReference)managedObjectReference, (ClassLoader)SsoUtilInternal.class.getClassLoader());
            String[] stringArray = string.getIssuersCertificates();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
            for (String string2 : stringArray) {
                byte[] byArray = Base64.decodeBase64((byte[])string2.getBytes());
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                linkedList.add(x509Certificate);
            }
            Object[] objectArray = linkedList.toArray(new X509Certificate[linkedList.size()]);
            return objectArray;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void export(Certificate certificate, File file, boolean bl) {
        OutputStreamWriter outputStreamWriter;
        FileOutputStream fileOutputStream;
        block5: {
            fileOutputStream = null;
            outputStreamWriter = null;
            try {
                byte[] byArray = certificate.getEncoded();
                fileOutputStream = new FileOutputStream(file);
                if (bl) {
                    fileOutputStream.write(byArray);
                    break block5;
                }
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
                outputStreamWriter.write("-----BEGIN CERTIFICATE-----\n");
                outputStreamWriter.write(Base64.encodeBase64String((byte[])byArray));
                outputStreamWriter.write("\n-----END CERTIFICATE-----\n");
                ((Writer)outputStreamWriter).flush();
            }
            catch (Exception exception) {
                try {
                    _logger.error((Object)"Error when exporting the certificate", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    StreamUtil.close(outputStreamWriter);
                    StreamUtil.close(fileOutputStream);
                    throw throwable;
                }
                StreamUtil.close(outputStreamWriter);
                StreamUtil.close((Closeable)fileOutputStream);
            }
        }
        StreamUtil.close(outputStreamWriter);
        StreamUtil.close((Closeable)fileOutputStream);
    }

    public static synchronized KeyPair createHokKeyPair() {
        _logger.info((Object)"Generating a temporary RSA key pair to be used with HOK tokens");
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return keyPair;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _logger.error((Object)"Error when generating the private key", (Throwable)noSuchAlgorithmException);
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static SecurityTokenServiceEx createSts(SecurityTokenServiceConfig securityTokenServiceConfig) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(SsoUtilInternal.class.getClassLoader());
            SecurityTokenServiceEx securityTokenServiceEx = DefaultSecurityTokenServiceFactory.getSecurityTokenServiceEx((SecurityTokenServiceConfig)securityTokenServiceConfig);
            return securityTokenServiceEx;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static SecurityTokenServiceConfig createStsConfiguration(SsoServerInfo ssoServerInfo, SecurityTokenServiceConfig.HolderOfKeyConfig holderOfKeyConfig, KeystoreService keystoreService, @Nonnull SsoConfigurationProvider ssoConfigurationProvider, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws ServiceFault, CertificateException, URISyntaxException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, InvalidKeyException, IllegalStateException, SignatureException, MalformedURLException, InterruptedException {
        SsoDomain ssoDomain = ssoServerInfo.getSsoDomain();
        Map<SsoDomain, SsoServerInfo> map = Collections.singletonMap(ssoDomain, ssoServerInfo);
        Map<SsoDomain, SecurityTokenServiceConfig> map2 = SsoUtilInternal.doCreateStsConfigurations(map, holderOfKeyConfig, keystoreService, ssoConfigurationProvider, httpConfigurationProvider);
        SecurityTokenServiceConfig securityTokenServiceConfig = map2.get(ssoDomain);
        if (securityTokenServiceConfig == null) {
            throw new IllegalStateException("There's no " + SecurityTokenServiceConfig.class.getSimpleName() + " for domain " + ssoDomain);
        }
        return securityTokenServiceConfig;
    }

    public static Map<SsoDomain, SecurityTokenServiceConfig> createStsConfigurations(@Nonnull Map<SsoDomain, SsoServerInfo> map, @Nullable SecurityTokenServiceConfig.HolderOfKeyConfig holderOfKeyConfig, @Nonnull KeystoreService keystoreService, @Nonnull SsoConfigurationProvider ssoConfigurationProvider, @Nonnull HttpConfigurationProvider httpConfigurationProvider) throws ServiceFault, CertificateException, URISyntaxException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, InvalidKeyException, IllegalStateException, SignatureException, MalformedURLException, InterruptedException {
        return SsoUtilInternal.doCreateStsConfigurations((Map)ValidationUtil.notNull(map, (String)"infos is null"), holderOfKeyConfig, (KeystoreService)ValidationUtil.notNull((Object)keystoreService, (String)"ksService is null"), (SsoConfigurationProvider)ValidationUtil.notNull((Object)ssoConfigurationProvider, (String)"ssoConfigProvider is null"), (HttpConfigurationProvider)ValidationUtil.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null"));
    }

    private static void appendDescriptionOfPrimaryStss(StringBuilder stringBuilder, Map<SsoDomain, SsoServerInfo> map) {
        if (map == null) {
            stringBuilder.append((String)null);
            return;
        }
        if (map.isEmpty()) {
            stringBuilder.append("{}");
            return;
        }
        stringBuilder.append('{');
        boolean bl = false;
        for (Map.Entry<SsoDomain, SsoServerInfo> entry : map.entrySet()) {
            SsoDomain ssoDomain = entry.getKey();
            SsoServerInfo ssoServerInfo = entry.getValue();
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(ssoDomain.getId());
            if (ssoDomain.isLocal()) {
                stringBuilder.append("(local)");
            }
            stringBuilder.append('=');
            stringBuilder.append(ssoServerInfo.getStsUrl());
            bl = true;
        }
        stringBuilder.append('}');
    }

    private static Map<SsoDomain, SecurityTokenServiceConfig> doCreateStsConfigurations(Map<SsoDomain, SsoServerInfo> map, SecurityTokenServiceConfig.HolderOfKeyConfig holderOfKeyConfig, KeystoreService keystoreService, @Nullable SsoConfigurationProvider ssoConfigurationProvider, @Nullable HttpConfigurationProvider httpConfigurationProvider) throws ServiceFault, CertificateException, URISyntaxException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, InvalidKeyException, IllegalStateException, SignatureException, MalformedURLException, InterruptedException {
        List list;
        StringBuilder stringBuilder = new StringBuilder().append("Preparing the STS configuration for ");
        SsoUtilInternal.appendDescriptionOfPrimaryStss(stringBuilder, map);
        _logger.info((Object)stringBuilder.toString());
        stringBuilder = null;
        X509Certificate[] x509CertificateArray = keystoreService.getSslTrustCertificates();
        ArrayList<BuildStsConfigTask> arrayList = new ArrayList<BuildStsConfigTask>(map.size());
        for (SsoServerInfo object2 : map.values()) {
            BuildStsConfigTask i = new BuildStsConfigTask(object2, x509CertificateArray, holderOfKeyConfig, ssoConfigurationProvider, httpConfigurationProvider);
            arrayList.add(i);
        }
        try {
            list = ExecutorUtil.executeTasks(arrayList, (Executor)EXECUTOR, (long)20L, (TimeUnit)TimeUnit.SECONDS, (boolean)true, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException | RejectedExecutionException | TimeoutException exception) {
            _logger.error((Object)"Execution of STS config tasks failed", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        HashMap<SsoDomain, SecurityTokenServiceConfig> hashMap = new HashMap<SsoDomain, SecurityTokenServiceConfig>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ExecutorUtil.TaskResult taskResult = (ExecutorUtil.TaskResult)list.get(i);
            if (taskResult.getException() != null) {
                _logger.error((Object)("Failed to create STS config for " + ((BuildStsConfigTask)arrayList.get(i)).getSsoServerInfo().getStsUrl()), (Throwable)taskResult.getException());
                continue;
            }
            if (taskResult.getResult() != null) {
                SsoDomain ssoDomain = ((BuildStsConfigTask)arrayList.get(i)).getSsoServerInfo().getSsoDomain();
                SecurityTokenServiceConfig securityTokenServiceConfig = (SecurityTokenServiceConfig)taskResult.getResult();
                hashMap.put(ssoDomain, securityTokenServiceConfig);
                continue;
            }
            _logger.error((Object)("Missing STS config result for " + ((BuildStsConfigTask)arrayList.get(i)).getSsoServerInfo().getStsUrl()));
        }
        if (hashMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return hashMap;
    }

    public static SamlToken acquireToken(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenService securityTokenService, String string, String string2, TokenSpec tokenSpec) throws CertificateNotYetValidException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException, InvalidKeySpecException, InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, SsoException {
        if (securityTokenServiceConfig == null) {
            throw new IllegalArgumentException("config");
        }
        if (tokenSpec == null) {
            throw new IllegalArgumentException("tokenSpec");
        }
        _logger.info((Object)("Acquiring a SAML token for user " + string + " from " + securityTokenServiceConfig.getConnectionConfig().getUrl()));
        SamlToken samlToken = securityTokenService.acquireToken(string, string2, tokenSpec);
        return samlToken;
    }

    public static SamlToken acquireTokenByCertificate(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenService securityTokenService, TokenSpec tokenSpec) throws InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, TimeSynchronizationException, InvalidTokenException, TokenRequestRejectedException, CertificateValidationException {
        if (securityTokenServiceConfig == null) {
            throw new IllegalArgumentException("config");
        }
        if (tokenSpec == null) {
            throw new IllegalArgumentException("tokenSpec");
        }
        _logger.info((Object)("Acquiring a SAML token by certificate from " + securityTokenServiceConfig.getConnectionConfig().getUrl()));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(SsoUtilInternal.class.getClassLoader());
            SamlToken samlToken = securityTokenService.acquireTokenByCertificate(tokenSpec);
            return samlToken;
        }
        catch (TimeSynchronizationException timeSynchronizationException) {
            _logger.error((Object)"Time sync error: VC Server and local machine's clocks are out of sync by more than the accepted tolerance.");
            throw timeSynchronizationException;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    @Deprecated
    public static SamlToken acquireTokenByToken(SsoServerInfo ssoServerInfo, SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenServiceEx securityTokenServiceEx, SamlToken samlToken, TokenSpec tokenSpec) throws CertificateNotYetValidException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException, InvalidKeySpecException, InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, SsoException {
        return SsoUtilInternal.acquireTokenByToken(ssoServerInfo, securityTokenServiceConfig, securityTokenServiceEx, SsoDomain.getLocal(), samlToken, tokenSpec);
    }

    public static SamlToken acquireTokenByToken(SsoServerInfo ssoServerInfo, SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenServiceEx securityTokenServiceEx, SsoDomain ssoDomain, SamlToken samlToken, TokenSpec tokenSpec) throws CertificateNotYetValidException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException, InvalidKeySpecException, InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, SsoException {
        SamlToken samlToken2;
        Validate.notNull((Object)ssoServerInfo);
        Validate.notNull((Object)securityTokenServiceConfig);
        Validate.notNull((Object)ssoDomain);
        Validate.notNull((Object)samlToken);
        Validate.notNull((Object)tokenSpec);
        SsoDomain ssoDomain2 = ssoServerInfo.getSsoDomain();
        URL uRL = securityTokenServiceConfig.getConnectionConfig().getUrl();
        if (ssoDomain.equals((Object)ssoDomain2)) {
            _logger.info((Object)("Exchanging token " + samlToken.getId() + " for a new one using " + uRL + " from domain " + ssoDomain2));
            samlToken2 = securityTokenServiceEx.acquireTokenByToken(samlToken, tokenSpec);
        } else {
            if (!SsoUtil.domainHasMultiTokenSupport(ssoServerInfo)) {
                throw new IllegalArgumentException("STS " + uRL + " from domain " + ssoDomain2 + " doesn't have multi-token support, yet the token  provided for the acquireTokenByToken operation  is from a different domain: " + ssoDomain);
            }
            _logger.info((Object)("Exchanging token " + samlToken.getId() + " for a new external one using " + uRL + " from domain " + ssoDomain2 + " and a token from domain " + ssoDomain));
            samlToken2 = securityTokenServiceEx.acquireTokenByExternalToken(samlToken, tokenSpec);
        }
        return samlToken2;
    }

    public static SamlToken buildToken(SecurityTokenServiceConfig securityTokenServiceConfig, String string) throws InvalidTokenException {
        _logger.info((Object)("Building a token from its XML representation - " + string));
        SamlToken samlToken = DefaultTokenFactory.createToken((String)string, (X509Certificate[])securityTokenServiceConfig.getTrustedRootCertificates());
        return samlToken;
    }

    public static GssNegotiationClient obtainGssNegotiationClient(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenService securityTokenService, TokenSpec tokenSpec) throws CertificateNotYetValidException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException, InvalidKeySpecException {
        if (tokenSpec == null) {
            throw new IllegalArgumentException("tokenSpec");
        }
        return securityTokenService.obtainGssNegotiationClient(tokenSpec);
    }

    public static SamlToken negotiateToken(GssNegotiationClient gssNegotiationClient, String string) throws SsoSspiChallenge, IOException, InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, CertificateValidationException {
        byte[] byArray = Base64.decodeBase64((String)string);
        GssNegotiationClient.GssNegotiationResult gssNegotiationResult = gssNegotiationClient.negotiateToken(byArray);
        if (gssNegotiationResult.getToken() != null) {
            return gssNegotiationResult.getToken();
        }
        String string2 = Base64.encodeBase64String((byte[])gssNegotiationResult.getLeg());
        throw new SsoSspiChallenge(string2);
    }

    public static SamlToken renewToken(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenService securityTokenService, SamlToken samlToken, long l) throws CertificateNotYetValidException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException, InvalidKeySpecException, InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, SsoException {
        if (securityTokenServiceConfig == null) {
            throw new IllegalArgumentException("config");
        }
        if (samlToken == null) {
            throw new IllegalArgumentException("token");
        }
        _logger.info((Object)("Renewing token " + samlToken.getId() + " using " + securityTokenServiceConfig.getConnectionConfig().getUrl()));
        SamlToken samlToken2 = securityTokenService.renewToken(samlToken, l);
        return samlToken2;
    }

    public static boolean validateToken(SecurityTokenServiceConfig securityTokenServiceConfig, SecurityTokenService securityTokenService, SamlToken samlToken) throws CertificateNotYetValidException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, SignatureException, CertificateException, NoSuchProviderException, InvalidKeySpecException, InvalidTokenException, InternalError, ServerCommunicationException, SsoException {
        if (securityTokenServiceConfig == null) {
            throw new IllegalArgumentException("config");
        }
        if (samlToken == null) {
            throw new IllegalArgumentException("token");
        }
        _logger.info((Object)("Validating token " + samlToken.getId() + " using " + securityTokenServiceConfig.getConnectionConfig().getUrl()));
        boolean bl = securityTokenService.validateToken(samlToken);
        return bl;
    }

    public static boolean checkTokenLifetime(SamlToken samlToken) throws InvalidTokenException {
        if (samlToken == null) {
            throw new IllegalArgumentException("token");
        }
        Date date = samlToken.getExpirationTime();
        Date date2 = Calendar.getInstance().getTime();
        long l = date.getTime() - date2.getTime();
        if (l <= 0L) {
            throw new InvalidTimingException("token expired");
        }
        return l <= 120000L;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        WorkerThreadFactory workerThreadFactory = new WorkerThreadFactory("security-token-service-config");
        DiagnosticThreadPoolExecutor diagnosticThreadPoolExecutor = DiagnosticThreadPoolExecutor.builder((int)30, (int)30, (long)3L, (TimeUnit)TimeUnit.MINUTES, new LinkedBlockingQueue(), (ThreadFactory)workerThreadFactory).name("security-token-service-config").queueWaitTimeThreshold(Config.SSO_UTIL_INTERNAL_THREAD_POOL_WARN_QUEUE_WAIT_TIME_THRESHOLD_NANOS, TimeUnit.NANOSECONDS).delayedTaskStepSizeForLoggingAdditionalDiagnostics(Config.SSO_UTIL_INTERNAL_THREAD_POOL_WARN_DIAGNOSTICS_DELAYED_TASK_STEP_SIZE).rejectedTaskStepSizeForLoggingAdditionalDiagnostics(Config.SSO_UTIL_INTERNAL_THREAD_POOL_WARN_DIAGNOSTICS_REJECTED_TASK_STEP_SIZE).minTimeApartForLoggingAdditionalDiagnostics(Config.SSO_UTIL_INTERNAL_THREAD_POOL_WARN_DIAGNOSTICS_MIN_TIME_APART_NANOS, TimeUnit.NANOSECONDS).build();
        diagnosticThreadPoolExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new NonSilentCallerRunsPolicy());
        diagnosticThreadPoolExecutor.allowCoreThreadTimeOut(true);
        EXECUTOR = diagnosticThreadPoolExecutor;
        ThreadPoolManager.getInstance().register(EXECUTOR);
    }

    private static class BuildStsConfigTask
    implements Callable<SecurityTokenServiceConfig> {
        private final SsoServerInfo _ssoServerInfo;
        private final X509Certificate[] _sslCertificates;
        private final SecurityTokenServiceConfig.HolderOfKeyConfig _hokConfig;
        @Nullable
        private final SsoConfigurationProvider _ssoConfigProvider;
        @Nullable
        private final HttpConfigurationProvider _httpConfigProvider;

        BuildStsConfigTask(SsoServerInfo ssoServerInfo, X509Certificate[] x509CertificateArray, SecurityTokenServiceConfig.HolderOfKeyConfig holderOfKeyConfig, @Nullable SsoConfigurationProvider ssoConfigurationProvider, @Nullable HttpConfigurationProvider httpConfigurationProvider) {
            this._ssoServerInfo = ssoServerInfo;
            this._sslCertificates = x509CertificateArray;
            this._hokConfig = holderOfKeyConfig;
            this._ssoConfigProvider = ssoConfigurationProvider;
            this._httpConfigProvider = httpConfigurationProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SecurityTokenServiceConfig call() throws MalformedURLException, ServiceFault, CertificateException, URISyntaxException {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("BuildStsConfigTask beginning for " + this._ssoServerInfo.getAdminAppUrl()));
            }
            try {
                SecurityTokenServiceConfig securityTokenServiceConfig;
                SecurityTokenServiceConfig.ConnectionConfig connectionConfig = new SecurityTokenServiceConfig.ConnectionConfig(new URL(this._ssoServerInfo.getStsUrl()), this._sslCertificates, null);
                X509Certificate[] x509CertificateArray = SsoUtilInternal.getStsIssuersCertificates(this._ssoServerInfo, this._httpConfigProvider);
                if (this._ssoConfigProvider != null) {
                    long l = this._ssoConfigProvider.getClockToleranceInSeconds();
                    securityTokenServiceConfig = new SecurityTokenServiceConfig(connectionConfig, x509CertificateArray, EXECUTOR, this._hokConfig, l);
                } else {
                    securityTokenServiceConfig = new SecurityTokenServiceConfig(connectionConfig, x509CertificateArray, EXECUTOR, this._hokConfig);
                }
                SecurityTokenServiceConfig securityTokenServiceConfig2 = securityTokenServiceConfig;
                return securityTokenServiceConfig2;
            }
            finally {
                _logger.debug((Object)"BuildStsConfigTask is done");
            }
        }

        public SsoServerInfo getSsoServerInfo() {
            return this._ssoServerInfo;
        }

        public String toString() {
            return this.getClass().getCanonicalName() + " for " + this._ssoServerInfo.getAdminAppUrl();
        }
    }
}

