/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.vapi;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vapi.bindings.Service;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vise.util.Optional;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vise.vim.vapi.EndpointInfo;
import com.vmware.vise.vim.vapi.StaticEndpointVapiConnectionManager;
import com.vmware.vise.vim.vapi.VapiConnectionAuthenticationStrategy;
import com.vmware.vise.vim.vapi.VapiConnectionAuthenticationStrategyFactory;
import com.vmware.vise.vim.vapi.VapiConnectionControl;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostBasedVapiConnectionManagerRegistry
implements VapiConnectionManagerRegistry<String> {
    private static final Log _logger = LogFactory.getLog(HostBasedVapiConnectionManagerRegistry.class);
    private final KeystoreService _ksService;
    private final ExecutorService _asyncCallExecutor;
    private final LookupService _lsService;
    private volatile Map<String, UrlDomainPair> _endpointByHost;
    private final ConcurrentMap<String, VapiConnectionManager> _connectionManagerByHost;
    private final EndpointInfo _endpointType;
    private final VapiConnectionManagerRegistry.ControlFactory<String> _controlFactory;
    private final VapiConnectionAuthenticationStrategyFactory _authnStrategyFactory;

    public HostBasedVapiConnectionManagerRegistry(KeystoreService keystoreService, ExecutorService executorService, LookupService lookupService, EndpointInfo endpointInfo, VapiConnectionManagerRegistry.ControlFactory<String> controlFactory, VapiConnectionAuthenticationStrategyFactory vapiConnectionAuthenticationStrategyFactory) {
        Validate.notNull((Object)keystoreService);
        Validate.notNull((Object)executorService);
        Validate.notNull((Object)lookupService);
        Validate.notNull((Object)endpointInfo);
        Validate.notNull(controlFactory);
        Validate.notNull((Object)vapiConnectionAuthenticationStrategyFactory);
        this._ksService = keystoreService;
        this._asyncCallExecutor = executorService;
        this._lsService = lookupService;
        this._endpointType = endpointInfo;
        this._controlFactory = controlFactory;
        this._connectionManagerByHost = new ConcurrentHashMap<String, VapiConnectionManager>();
        this._endpointByHost = null;
        this._authnStrategyFactory = vapiConnectionAuthenticationStrategyFactory;
    }

    @Override
    public <C extends Service> C getService(Class<C> clazz, String string) {
        VapiConnectionManager vapiConnectionManager = this.getConnectionManager(string);
        if (vapiConnectionManager == null) {
            return null;
        }
        return (C)((Service)clazz.cast(vapiConnectionManager.createServiceStub(clazz)));
    }

    @Override
    public VapiConnectionManager getConnectionManager(String string) {
        VapiConnectionManager vapiConnectionManager;
        if (this._connectionManagerByHost.containsKey(string)) {
            vapiConnectionManager = (VapiConnectionManager)this._connectionManagerByHost.get(string);
        } else {
            VapiConnectionManager vapiConnectionManager2 = this.createVapiConnectionManagerForHost(string);
            if (vapiConnectionManager2 != null) {
                this._connectionManagerByHost.putIfAbsent(string, vapiConnectionManager2);
            }
            vapiConnectionManager = (VapiConnectionManager)this._connectionManagerByHost.get(string);
        }
        return vapiConnectionManager;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        for (VapiConnectionManager vapiConnectionManager : this._connectionManagerByHost.values()) {
            vapiConnectionManager.sessionEnded(httpSessionEvent);
        }
    }

    private VapiConnectionManager createVapiConnectionManagerForHost(String string) {
        UrlDomainPair urlDomainPair = this.getEndpoint(string);
        if (urlDomainPair == null) {
            _logger.debug((Object)String.format("Unable to find endpoint of type '%s' on host '%s'.", this._endpointType.toString(), string));
            return null;
        }
        VapiConnectionAuthenticationStrategy vapiConnectionAuthenticationStrategy = this._authnStrategyFactory.createAuthenticationStrategy(urlDomainPair.url, urlDomainPair.ssoDomain);
        VapiConnectionControl vapiConnectionControl = this._controlFactory.getControlForEndpoint(string);
        StaticEndpointVapiConnectionManager staticEndpointVapiConnectionManager = new StaticEndpointVapiConnectionManager(urlDomainPair.url, this._ksService, this._asyncCallExecutor, vapiConnectionAuthenticationStrategy, vapiConnectionControl);
        return staticEndpointVapiConnectionManager;
    }

    private UrlDomainPair getEndpoint(String string) {
        if (this._endpointByHost == null) {
            this.retrieveEndpoints();
        }
        if (this._endpointByHost == null) {
            return null;
        }
        return this._endpointByHost.get(string);
    }

    private synchronized void retrieveEndpoints() {
        ServiceRegistration.Info[] infoArray;
        if (this._endpointByHost != null) {
            return;
        }
        try {
            infoArray = this.retrieveServices();
            if (infoArray == null) {
                infoArray = new ServiceRegistration.Info[]{};
            }
        }
        catch (EntryNotFoundFault entryNotFoundFault) {
            _logger.error((Object)"Could not retrieve services from LS", (Throwable)entryNotFoundFault);
            return;
        }
        HashMap<String, UrlDomainPair> hashMap = new HashMap<String, UrlDomainPair>();
        for (ServiceRegistration.Info info : infoArray) {
            if (info.getServiceEndpoints().length > 1) {
                _logger.warn((Object)"Found more than one endpoint of type on host.");
            }
            ServiceRegistration.Endpoint endpoint = info.getServiceEndpoints()[0];
            URI uRI = endpoint.getUrl();
            String string = uRI.getHost();
            hashMap.put(string, new UrlDomainPair(uRI, HostBasedVapiConnectionManagerRegistry.getSsoDomain(info)));
        }
        this._endpointByHost = hashMap;
    }

    private ServiceRegistration.Info[] retrieveServices() throws EntryNotFoundFault {
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setServiceType(new ServiceRegistration.ServiceType(this._endpointType.getProductId(), this._endpointType.getServiceTypeId()));
        filter.setEndpointType(new ServiceRegistration.EndpointType(this._endpointType.getEndpointProtocolId(), this._endpointType.getEndpointTypeId()));
        filter.setSearchAllSsoDomains(Boolean.valueOf(true));
        return this._lsService.getServiceRegistrationInfos(filter);
    }

    private static SsoDomain getSsoDomain(ServiceRegistration.Info info) {
        Optional<SsoDomain> optional = LookupUtil.getSsoDomain(info);
        return (SsoDomain)optional.orElse((Object)SsoDomain.getLocal());
    }

    private static class UrlDomainPair {
        final URI url;
        final SsoDomain ssoDomain;

        UrlDomainPair(URI uRI, SsoDomain ssoDomain) {
            assert (uRI != null && ssoDomain != null);
            this.url = uRI;
            this.ssoDomain = ssoDomain;
        }
    }
}

